/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.AnnotationState;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.util.Library;

public class AnnotationFactory {
    private static final Logger logger = Logger.getLogger(AnnotationFactory.class.toString());
    public static final int LINK_ANNOTATION = 1;

    public static Annotation buildAnnotation(Library library, int type, Rectangle rect, AnnotationState annotationState) {
        StateManager stateManager = library.getStateManager();
        Hashtable<Name, Object> entries = new Hashtable<Name, Object>();
        entries.put(Dictionary.TYPE_KEY, Annotation.TYPE_VALUE);
        entries.put(Dictionary.SUBTYPE_KEY, Annotation.SUBTYPE_LINK);
        if (rect != null) {
            entries.put(Annotation.RECTANGLE_KEY, PRectangle.getPRectangleVector(rect));
        } else {
            entries.put(Annotation.RECTANGLE_KEY, new Rectangle(10, 10, 50, 100));
        }
        if (type == 1) {
            LinkAnnotation linkAnnotation = new LinkAnnotation(library, entries);
            linkAnnotation.setPObjectReference(stateManager.getNewReferencNumber());
            linkAnnotation.setNew(true);
            if (annotationState != null) {
                annotationState.restore(linkAnnotation);
            } else {
                annotationState = new AnnotationState(1, "I", 1.0f, "S", Color.RED);
                annotationState.restore(linkAnnotation);
            }
            return linkAnnotation;
        }
        logger.warning("Unsupported Annotation type. ");
        return null;
    }
}

