/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.Arrays;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;

public class ScoreNodeIteratorImpl
implements ScoreNodeIterator {
    private ListIterator<ScoreNode[]> iterator;
    private int size;

    public ScoreNodeIteratorImpl(ScoreNode[][] scoreNodes) {
        this.iterator = Arrays.asList(scoreNodes).listIterator();
        this.size = scoreNodes.length;
    }

    public ScoreNode[] nextScoreNodes() {
        return (ScoreNode[])this.next();
    }

    public long getPosition() {
        return this.iterator.nextIndex();
    }

    public long getSize() {
        return this.size;
    }

    public void skip(long n) throws IllegalArgumentException, NoSuchElementException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip(" + n + ")");
        }
        for (long i = 0L; i < n; ++i) {
            this.next();
        }
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() throws NoSuchElementException {
        return this.iterator.next();
    }

    public void remove() throws UnsupportedOperationException, IllegalStateException {
        this.iterator.remove();
        --this.size;
    }

    public void skipBack(long skipNum) {
        if (skipNum < 0L) {
            throw new IllegalArgumentException("skip(" + skipNum + ")");
        }
        if ((long)this.iterator.nextIndex() - skipNum < 0L) {
            throw new NoSuchElementException();
        }
        for (long i = 0L; i < skipNum; ++i) {
            this.iterator.previous();
        }
    }
}

