/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.serialization;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.exoplatform.services.jcr.dataflow.serialization.ObjectReader;

public class FileObjectReaderImpl
implements ObjectReader {
    private final FileChannel channel;

    public FileObjectReaderImpl(File file) throws FileNotFoundException {
        this.channel = new FileInputStream(file).getChannel();
    }

    public void close() throws IOException {
        this.channel.close();
    }

    private void readFully(ByteBuffer dst) throws IOException {
        int r = this.channel.read(dst);
        if (r < 0) {
            throw new EOFException();
        }
        if (r < dst.capacity() && r > 0) {
            throw new StreamCorruptedException("Unexpected EOF in middle of data block.");
        }
    }

    public boolean readBoolean() throws IOException {
        int v = this.readInt();
        if (v < 0) {
            throw new EOFException();
        }
        return v != 0;
    }

    public byte readByte() throws IOException {
        ByteBuffer dst = ByteBuffer.allocate(1);
        this.readFully(dst);
        return dst.get();
    }

    public void readFully(byte[] b) throws IOException {
        ByteBuffer dst = ByteBuffer.wrap(b);
        this.readFully(dst);
    }

    public int readInt() throws IOException {
        ByteBuffer dst = ByteBuffer.allocate(4);
        this.readFully(dst);
        return dst.asIntBuffer().get();
    }

    public long readLong() throws IOException {
        ByteBuffer dst = ByteBuffer.allocate(8);
        this.readFully(dst);
        return dst.asLongBuffer().get();
    }

    public String readString() throws IOException {
        ByteBuffer dst = ByteBuffer.allocate(this.readInt());
        this.readFully(dst);
        return new String(dst.array(), "UTF-8");
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        this.channel.position(this.channel.position() + n);
        return n;
    }

    public long read(OutputStream stream, long length) throws IOException {
        int r;
        if (stream instanceof FileOutputStream) {
            return this.channel.transferTo(0L, length, ((FileOutputStream)stream).getChannel());
        }
        ByteBuffer buff = ByteBuffer.allocate(2048);
        int readed = 0;
        while ((r = this.channel.read(buff)) <= 0) {
            stream.write(buff.array(), 0, r);
            buff.rewind();
            readed += r;
        }
        return readed;
    }
}

