/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.xmlprocessor.model;

import java.util.LinkedList;
import org.exoplatform.social.common.xmlprocessor.model.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    private Node parentNode = null;
    private String title = "";
    private Attributes attributes = new Attributes();
    private String content = "";
    private LinkedList<Node> childNodes = new LinkedList();

    public Node getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(Node parentNode) {
        this.parentNode = parentNode;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String nodeTitle) {
        this.title = nodeTitle;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public LinkedList<Node> getChildNodes() {
        return this.childNodes;
    }

    public void setChildNodes(LinkedList<Node> childNodes) {
        this.childNodes = childNodes;
    }

    public void addChildNode(Node childNode) {
        this.childNodes.add(childNode);
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public String toString() {
        StringBuilder xmlString = new StringBuilder("");
        boolean selfClosedTag = false;
        boolean textTag = false;
        if (this.childNodes.size() == 0 && this.content.isEmpty()) {
            selfClosedTag = true;
        }
        if (this.attributes.size() == 0 && this.childNodes.size() == 0 && !this.content.isEmpty() && this.title.isEmpty()) {
            textTag = true;
        }
        if (textTag) {
            xmlString.append(this.content);
        } else {
            if (this.parentNode != null) {
                xmlString.append("<" + this.title);
                xmlString.append(this.attributes.toString());
                if (selfClosedTag) {
                    xmlString.append(" /");
                }
                xmlString.append(">");
            }
            for (Node childNode : this.childNodes) {
                xmlString.append(childNode.toString());
            }
            if (this.parentNode != null && !selfClosedTag) {
                xmlString.append("</" + this.title + ">");
            }
        }
        return xmlString.toString();
    }

    private String toOpenString() {
        StringBuilder xmlString = new StringBuilder("");
        boolean selfClosedTag = false;
        boolean textTag = false;
        if (this.childNodes.size() == 0 && this.content.isEmpty()) {
            selfClosedTag = true;
        }
        if (this.attributes.size() == 0 && this.childNodes.size() == 0 && !this.content.isEmpty() && this.title.isEmpty()) {
            textTag = true;
        }
        if (textTag) {
            xmlString.append(this.content);
        } else if (this.parentNode != null) {
            xmlString.append("<" + this.title);
            xmlString.append(this.attributes.toString());
            if (selfClosedTag) {
                xmlString.append(" /");
            }
            xmlString.append(">");
        }
        return xmlString.toString();
    }

    private String toCloseString() {
        StringBuilder xmlString = new StringBuilder("");
        boolean selfClosedTag = false;
        boolean textTag = false;
        if (this.childNodes.size() == 0 && this.content.isEmpty()) {
            selfClosedTag = true;
        }
        if (this.attributes.size() == 0 && this.childNodes.size() == 0 && !this.content.isEmpty() && this.title.isEmpty()) {
            textTag = true;
        }
        if (textTag) {
            xmlString.append(this.content);
        } else if (this.parentNode != null && !selfClosedTag) {
            xmlString.append("</" + this.title + ">");
        }
        return xmlString.toString();
    }

    public void convertToContent() {
        if (this.parentNode != null) {
            int thisPostion = this.parentNode.getChildNodes().indexOf(this);
            String content = this.toOpenString();
            String closeTag = this.toCloseString();
            this.title = "";
            this.attributes.clear();
            this.content = content;
            if (!closeTag.isEmpty()) {
                Node closeContentNode = new Node();
                closeContentNode.setContent(closeTag);
                this.childNodes.addLast(closeContentNode);
                this.moveAllChildNodesToOtherNode(this.parentNode, thisPostion);
            }
        }
    }

    private void moveAllChildNodesToOtherNode(Node destNode, int insertPosition) {
        if (destNode != null) {
            LinkedList<Node> parentChildNodes = destNode.getChildNodes();
            int postShift = insertPosition;
            for (Node childNode : this.childNodes) {
                childNode.setParentNode(destNode);
                parentChildNodes.add(++postShift, childNode);
            }
            this.childNodes.clear();
        }
    }
}

