/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import javax.jcr.RepositoryException;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeContainer;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTreeList;
import org.exoplatform.ecm.webui.selector.UIPermissionSelector;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.ext.manager.UIAbstractManager;

@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UITaxonomyManagerTrees
extends UIAbstractManager {
    public UITaxonomyManagerTrees() throws Exception {
        this.addChild(UITaxonomyTreeList.class, null, null);
    }

    public void initPopupTreeContainer(String id) throws Exception {
        UITaxonomyTreeContainer uiTaxonomyTreeContainer;
        UIPopupWindow uiPopup = (UIPopupWindow)this.getChildById(id);
        if (uiPopup == null) {
            uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, id);
            uiPopup.setWindowSize(650, 450);
            uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)this.createUIComponent(UITaxonomyTreeContainer.class, null, null);
        } else {
            uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)uiPopup.findFirstComponentOfType(UITaxonomyTreeContainer.class);
            uiPopup.setRendered(true);
        }
        uiPopup.setUIComponent((UIComponent)uiTaxonomyTreeContainer);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public void refresh() throws Exception {
        this.update();
    }

    public void update() throws Exception {
        UITaxonomyTreeList uiTaxonomyTreeList = (UITaxonomyTreeList)this.getChild(UITaxonomyTreeList.class);
        uiTaxonomyTreeList.updateTaxonomyTreeListGrid(uiTaxonomyTreeList.getUIPageIterator().getCurrentPage());
    }

    public void initPopupPermission(String membership) throws Exception {
        this.removePopup();
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "PopupTaxonomyTreePermission");
        uiPopup.setWindowSize(560, 300);
        UIPermissionSelector uiTaxonomyTreePermission = (UIPermissionSelector)this.createUIComponent(UIPermissionSelector.class, null, null);
        uiTaxonomyTreePermission.setSelectedMembership(true);
        if (membership != null && membership.indexOf(":/") > -1) {
            String[] arrMember = membership.split(":/");
            uiTaxonomyTreePermission.setCurrentPermission("/" + arrMember[1]);
        }
        uiPopup.setUIComponent((UIComponent)uiTaxonomyTreePermission);
        uiPopup.setShow(true);
    }

    public String getSystemWorkspaceName(String repository) throws RepositoryException, RepositoryConfigurationException {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        return manageableRepository.getConfiguration().getSystemWorkspaceName();
    }

    public String getDmsSystemWorkspaceName(String repository) {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        DMSRepositoryConfiguration dmsRepoConfig = dmsConfiguration.getConfig(repository);
        return dmsRepoConfig.getSystemWorkspace();
    }

    public void initPopupJCRBrowser(String workspace, boolean isDisable) throws Exception {
        this.removePopup();
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "PopupTaxonomyJCRBrowser");
        uiPopup.setWindowSize(610, 300);
        String[] filterType = new String[]{"nt:folder", "nt:unstructured"};
        UIOneNodePathSelector uiOneNodePathSelector = (UIOneNodePathSelector)this.createUIComponent(UIOneNodePathSelector.class, null, null);
        uiOneNodePathSelector.setIsDisable(workspace, isDisable);
        uiOneNodePathSelector.setShowRootPathSelect(true);
        uiOneNodePathSelector.setAcceptedNodeTypesInTree(filterType);
        uiOneNodePathSelector.setAcceptedNodeTypesInPathPanel(filterType);
        uiOneNodePathSelector.setRootNodeLocation(repository, workspace, "/");
        if (SessionProviderFactory.isAnonim()) {
            uiOneNodePathSelector.init(SessionProviderFactory.createAnonimProvider());
        } else if (workspace.equals(this.getSystemWorkspaceName(repository))) {
            uiOneNodePathSelector.init(SessionProviderFactory.createSystemProvider());
        } else {
            uiOneNodePathSelector.init(SessionProviderFactory.createSessionProvider());
        }
        uiPopup.setUIComponent((UIComponent)uiOneNodePathSelector);
        UITaxonomyTreeContainer uiTaxonomyTreeContainer = (UITaxonomyTreeContainer)this.findFirstComponentOfType(UITaxonomyTreeContainer.class);
        uiOneNodePathSelector.setSourceComponent((UIComponent)uiTaxonomyTreeContainer, new String[]{"TaxoTreeHomePath"});
        uiPopup.setShow(true);
    }

    public void initPopupComponent(UIComponent uiComp, String id) throws Exception {
        this.removePopup();
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, id);
        uiPopup.setUIComponent(uiComp);
        uiPopup.setWindowSize(640, 300);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    private void removePopup() {
        this.removeChildById("PopupComponent");
        this.removeChildById("PopupTaxonomyTreePermission");
        this.removeChildById("PopupTaxonomyJCRBrowser");
    }
}

