/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.form.field;

import org.exoplatform.ecm.webui.form.DialogFormField;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIFormWYSIWYGField
extends DialogFormField {
    private final String TOOBAR = "toolbar".intern();
    private final String SOURCE_MODE = "SourceModeOnStartup".intern();
    private final String WIDTH = "width".intern();
    private final String HEIGHT = "height".intern();
    private String toolbarName;
    private boolean sourceModeOnStartup = false;
    private String width;
    private String height;

    public UIFormWYSIWYGField(String name, String label, String[] arguments) {
        super(name, label, arguments);
    }

    @Override
    public <T extends UIFormInputBase> T createUIFormInput() throws Exception {
        UIFormWYSIWYGInput wysiwyg = new UIFormWYSIWYGInput(this.name, this.name, this.defaultValue);
        this.parseOptions();
        wysiwyg.setToolBarName(this.toolbarName);
        wysiwyg.setSourceModeOnStartup(this.sourceModeOnStartup);
        wysiwyg.setWidth(this.width);
        wysiwyg.setHeight(this.height);
        if (this.validateType != null) {
            DialogFormUtil.addValidators((UIFormInputBase)wysiwyg, this.validateType);
        }
        return (T)wysiwyg;
    }

    private void parseOptions() {
        if ("basic".equals(this.options)) {
            this.toolbarName = UIFormWYSIWYGInput.BASIC_TOOLBAR;
        } else if ("default".equals(this.options) || this.options == null) {
            this.toolbarName = UIFormWYSIWYGInput.DEFAULT_TOOLBAR;
        } else if (this.options.indexOf(",") > 0) {
            for (String s : this.options.split(",")) {
                this.setPredefineOptions(s);
            }
        } else if (this.options.indexOf(":") > 0) {
            this.setPredefineOptions(this.options);
        } else {
            this.toolbarName = UIFormWYSIWYGInput.DEFAULT_TOOLBAR;
            this.sourceModeOnStartup = false;
        }
    }

    private void setPredefineOptions(String option) {
        String[] entry = option.split(":");
        if (this.TOOBAR.equals(entry[0])) {
            this.toolbarName = entry[1];
        } else if (this.SOURCE_MODE.equals(entry[0])) {
            this.sourceModeOnStartup = Boolean.parseBoolean(entry[1]);
        } else if (this.WIDTH.equals(entry[0])) {
            this.width = entry[1];
        } else if (this.HEIGHT.equals(entry[0])) {
            this.height = entry[1];
        }
    }
}

