/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private Map<String, String> groupTypeMappings = new HashMap<String, String>();
    private boolean useParentIdAsGroupType = false;
    private boolean passwordAsAttribute = false;
    private String defaultGroupType = "GTN_GROUP_TYPE";
    private String rootGroupName = "GTN_ROOT_GROUP";
    private String pathSeparator = ".";
    private String slashReplacement = "@_@_@";
    private boolean forceMembershipOfMappedTypes = false;
    private String associationMembershipType;
    private boolean ignoreMappedMembershipType = true;
    private boolean useJTA = false;
    private boolean sortGroups = true;
    private boolean sortMemberships = true;

    public String getGroupType(String parentId) {
        if (parentId == null || parentId.length() == 0) {
            parentId = "/";
        }
        if (!this.useParentIdAsGroupType) {
            String type = this._getGroupType(parentId, true, true, true);
            if (type != null) {
                return type;
            }
            return this.getDefaultGroupType();
        }
        String type = this._getGroupType(parentId, false, true, true);
        if (type == null) {
            type = this._getGroupType(parentId, true, false, true);
        }
        if (type == null) {
            type = this.convertType(parentId);
        }
        return type;
    }

    private String _getGroupType(String parentId, boolean checkParents, boolean matchExact, boolean matchInherited) {
        String id;
        if (matchExact && this.getGroupTypeMappings().keySet().contains(parentId)) {
            return this.getGroupTypeMappings().get(parentId);
        }
        String string = id = !parentId.equals("/") ? parentId + "/*" : "/*";
        if (matchInherited && this.getGroupTypeMappings().keySet().contains(id)) {
            return this.getGroupTypeMappings().get(id);
        }
        if (checkParents && !parentId.equals("/") && parentId.contains("/")) {
            for (String key : this.groupTypeMappings.keySet()) {
                id = key;
                if (!id.endsWith("/*") || !parentId.startsWith(id = id.substring(0, id.length() - 2))) continue;
                return this.groupTypeMappings.get(key);
            }
        }
        return null;
    }

    public String getParentId(String type) {
        for (Map.Entry<String, String> entry : this.groupTypeMappings.entrySet()) {
            if (!entry.getValue().equals(type)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getPLIDMGroupName(String gtnGroupName) {
        return gtnGroupName.replaceAll(this.getSlashReplacement(), "/");
    }

    public String getGtnGroupName(String plidmGroupName) {
        return plidmGroupName.replaceAll("/", this.getSlashReplacement());
    }

    Set<String> getTypes(String id) {
        HashSet<String> types = new HashSet<String>();
        for (String key : this.groupTypeMappings.keySet()) {
            if (!key.equals(id) && !key.equals(id + "/*")) continue;
            types.add(this.groupTypeMappings.get(key));
        }
        return types;
    }

    Set<String> getAllTypes() {
        HashSet<String> types = new HashSet<String>(this.groupTypeMappings.values());
        return types;
    }

    private String convertType(String type) {
        return type.replaceAll("/", this.pathSeparator);
    }

    public boolean isUseParentIdAsGroupType() {
        return this.useParentIdAsGroupType;
    }

    public void setUseParentIdAsGroupType(boolean useParentIdAsGroupType) {
        this.useParentIdAsGroupType = useParentIdAsGroupType;
    }

    public String getDefaultGroupType() {
        return this.defaultGroupType;
    }

    public void setDefaultGroupType(String defaultGroupType) {
        this.defaultGroupType = defaultGroupType;
    }

    public String getRootGroupName() {
        return this.rootGroupName;
    }

    public void setRootGroupName(String rootGroupName) {
        this.rootGroupName = rootGroupName;
    }

    public void setGroupTypeMappings(Map<String, String> groupTypeMappings) {
        this.groupTypeMappings = groupTypeMappings;
    }

    public Map<String, String> getGroupTypeMappings() {
        return this.groupTypeMappings;
    }

    public boolean isPasswordAsAttribute() {
        return this.passwordAsAttribute;
    }

    public void setPasswordAsAttribute(boolean passwordAsAttribute) {
        this.passwordAsAttribute = passwordAsAttribute;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator;
    }

    public boolean isForceMembershipOfMappedTypes() {
        return this.forceMembershipOfMappedTypes;
    }

    public void setForceMembershipOfMappedTypes(boolean forceMembershipOfMappedTypes) {
        this.forceMembershipOfMappedTypes = forceMembershipOfMappedTypes;
    }

    public String getAssociationMembershipType() {
        return this.associationMembershipType;
    }

    public void setAssociationMembershipType(String associationMembershipType) {
        this.associationMembershipType = associationMembershipType;
    }

    public boolean isIgnoreMappedMembershipType() {
        return this.ignoreMappedMembershipType;
    }

    public void setIgnoreMappedMembershipType(boolean ignoreMappedMembershipType) {
        this.ignoreMappedMembershipType = ignoreMappedMembershipType;
    }

    public boolean isUseJTA() {
        return this.useJTA;
    }

    public void setUseJTA(boolean useJTA) {
        this.useJTA = useJTA;
    }

    public String getSlashReplacement() {
        return this.slashReplacement;
    }

    public void setSlashReplacement(String slashReplacement) {
        this.slashReplacement = slashReplacement;
    }

    public boolean isSortGroups() {
        return this.sortGroups;
    }

    public void setSortGroups(boolean sortGroups) {
        this.sortGroups = sortGroups;
    }

    public boolean isSortMemberships() {
        return this.sortMemberships;
    }

    public void setSortMemberships(boolean sortMemberships) {
        this.sortMemberships = sortMemberships;
    }
}

