/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.service.LinkProvider;

public class MentionsProcessor
extends BaseActivityProcessorPlugin {
    private LinkProvider linkProvider;

    public MentionsProcessor(InitParams params, LinkProvider linkProvider) {
        super(params);
        this.linkProvider = linkProvider;
    }

    public void processActivity(Activity activity) {
        if (activity != null) {
            activity.setTitle(this.substituteUsernames(activity.getTitle()));
            activity.setBody(this.substituteUsernames(activity.getBody()));
            Map<String, String> templateParams = activity.getTemplateParams();
            if (templateParams != null) {
                for (Map.Entry<String, String> entry : templateParams.entrySet()) {
                    templateParams.put(entry.getKey(), this.substituteUsernames(entry.getValue()));
                }
            }
        }
    }

    private String substituteUsernames(String message) {
        if (message == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("@([^\\s]+)|@([^\\s]+)$");
        Matcher matcher = pattern.matcher(message);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String replaceStr = matcher.group().substring(1);
            String portalOwner = null;
            try {
                portalOwner = Util.getPortalRequestContext().getPortalOwner();
            }
            catch (Exception e) {
                portalOwner = LinkProvider.DEFAULT_PORTAL_OWNER;
            }
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            LinkProvider lp = (LinkProvider)container.getComponentInstanceOfType(LinkProvider.class);
            replaceStr = lp.getProfileLink(replaceStr, portalOwner);
            matcher.appendReplacement(buf, replaceStr);
        }
        matcher.appendTail(buf);
        return buf.toString();
    }
}

