/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.connection.impl;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.presence.DefaultPresenceStatus;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.xmpp.connection.impl.XMPPMessenger;
import org.exoplatform.services.xmpp.history.impl.jcr.HistoryImpl;
import org.exoplatform.services.xmpp.rest.RESTXMPPService;
import org.exoplatform.services.xmpp.userinfo.UserInfoService;
import org.exoplatform.ws.frameworks.cometd.transport.ContinuationServiceDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationLoginListener
extends Listener<ConversationRegistry, ConversationState> {
    protected static final Log log = ExoLogger.getLogger((String)"chat.AuthenticationLoginListener");

    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        block3: {
            try {
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                XMPPMessenger messenger = (XMPPMessenger)container.getComponentInstanceOfType(XMPPMessenger.class);
                RESTXMPPService restXmppService = (RESTXMPPService)container.getComponentInstanceOfType(RESTXMPPService.class);
                DefaultPresenceStatus dps = (DefaultPresenceStatus)container.getComponentInstance(DefaultPresenceStatus.class);
                if (messenger != null && restXmppService != null) {
                    String userId = ((ConversationState)event.getData()).getIdentity().getUserId();
                    UserInfoService organization = (UserInfoService)container.getComponentInstanceOfType(UserInfoService.class);
                    ConversationState.setCurrent((ConversationState)((ConversationState)event.getData()));
                    String password = organization.providePassword(userId);
                    ContinuationServiceDelegate delegate = (ContinuationServiceDelegate)container.getComponentInstanceOfType(ContinuationServiceDelegate.class);
                    HistoryImpl history = (HistoryImpl)container.getComponentInstanceOfType(HistoryImpl.class);
                    messenger.login(userId, password, organization, delegate, history, restXmppService.loadResourceBundle());
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)e.getMessage());
            }
        }
    }
}

