/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.security;

import org.apache.jackrabbit.webdav.security.Privilege;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SupportedPrivilege
implements XmlSerializable {
    private static final String XML_SUPPORTED_PRIVILEGE = "supported-privilege";
    private static final String XML_ABSTRACT = "abstract";
    private static final String XML_DESCRIPTION = "description";
    private final Privilege privilege;
    private final boolean isAbstract;
    private final String description;
    private final String descriptionLanguage;
    private final SupportedPrivilege[] supportedPrivileges;

    public SupportedPrivilege(Privilege privilege, String description, String descriptionLanguage, boolean isAbstract, SupportedPrivilege[] supportedPrivileges) {
        if (privilege == null) {
            throw new IllegalArgumentException("DAV:supported-privilege element must contain a single privilege.");
        }
        this.privilege = privilege;
        this.description = description;
        this.descriptionLanguage = descriptionLanguage;
        this.isAbstract = isAbstract;
        this.supportedPrivileges = supportedPrivileges;
    }

    public Element toXml(Document document) {
        Element spElem = DomUtil.createElement(document, XML_SUPPORTED_PRIVILEGE, SecurityConstants.NAMESPACE);
        spElem.appendChild(this.privilege.toXml(document));
        if (this.isAbstract) {
            DomUtil.addChildElement(spElem, XML_ABSTRACT, SecurityConstants.NAMESPACE);
        }
        if (this.description != null) {
            Element desc = DomUtil.addChildElement(spElem, XML_DESCRIPTION, SecurityConstants.NAMESPACE, this.description);
            if (this.descriptionLanguage != null) {
                DomUtil.setAttribute(desc, "lang", Namespace.XML_NAMESPACE, this.descriptionLanguage);
            }
        }
        if (this.supportedPrivileges != null) {
            for (int i = 0; i < this.supportedPrivileges.length; ++i) {
                spElem.appendChild(this.supportedPrivileges[i].toXml(document));
            }
        }
        return spElem;
    }
}

