/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.ext.backup.BackupChain;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupConfigurationException;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupChain;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupChainLog;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupConfig;
import org.exoplatform.services.jcr.ext.backup.impl.BackupChainImpl;
import org.exoplatform.services.jcr.ext.backup.impl.FileNameProducer;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RepositoryBackupChainImpl
implements RepositoryBackupChain {
    private static Log log = ExoLogger.getLogger("exo.jcr.component.ext.RepositoryBackupChainImpl");
    private final RepositoryBackupConfig config;
    private final Set<BackupChain> workspaceBackups;
    private final RepositoryBackupChainLog repositoryChainLog;
    private final String repositoryBackupId;
    private final Calendar startTime;
    private int state;

    public RepositoryBackupChainImpl(RepositoryBackupConfig config, File logDirectory, RepositoryService repositoryService, String fullBackupType, String incrementalBackupType, String repositoryBackupId) throws BackupOperationException, BackupConfigurationException {
        RepositoryEntry repository;
        this.config = config;
        this.workspaceBackups = Collections.synchronizedSet(new HashSet());
        this.startTime = Calendar.getInstance();
        this.repositoryBackupId = repositoryBackupId;
        ArrayList<String> wsLogFilePathList = new ArrayList<String>();
        try {
            repository = repositoryService.getConfig().getRepositoryConfiguration(config.getRepository());
        }
        catch (RepositoryConfigurationException e) {
            throw new BackupOperationException("Can not get repository \"" + config.getRepository() + "\"", e);
        }
        for (WorkspaceEntry workspaceEntry : repository.getWorkspaceEntries()) {
            BackupConfig wsBackupConfig = new BackupConfig();
            wsBackupConfig.setRepository(config.getRepository());
            wsBackupConfig.setWorkspace(workspaceEntry.getName());
            wsBackupConfig.setBackupType(config.getBackupType());
            wsBackupConfig.setIncrementalJobNumber(config.getIncrementalJobNumber());
            wsBackupConfig.setIncrementalJobPeriod(config.getIncrementalJobPeriod());
            Calendar startTime = Calendar.getInstance();
            File dir = FileNameProducer.generateBackupSetDir(wsBackupConfig.getRepository(), wsBackupConfig.getWorkspace(), config.getBackupDir().getPath(), startTime);
            PrivilegedFileHelper.mkdirs(dir);
            wsBackupConfig.setBackupDir(dir);
            BackupChainImpl bchain = new BackupChainImpl(wsBackupConfig, wsBackupConfig.getBackupDir(), repositoryService, fullBackupType, incrementalBackupType, IdGenerator.generate(), logDirectory, startTime);
            wsLogFilePathList.add(bchain.getLogFilePath());
            this.workspaceBackups.add(bchain);
        }
        this.repositoryChainLog = new RepositoryBackupChainLog(logDirectory, this.config, fullBackupType, incrementalBackupType, repository.getSystemWorkspaceName(), wsLogFilePathList, this.repositoryBackupId, this.startTime, repository, repositoryService.getConfig());
        this.state = 0;
    }

    public String getLogFilePath() {
        return this.repositoryChainLog.getLogFilePath();
    }

    public int getState() {
        if (this.state != 4) {
            BackupChain bc;
            if (log.isDebugEnabled()) {
                for (BackupChain bc2 : this.workspaceBackups) {
                    log.debug(this.repositoryBackupId + " : " + this.getState(bc2.getFullBackupState()));
                }
            }
            int fullBackupsState = -1;
            int incrementalBackupsState = -1;
            Iterator<BackupChain> i$ = this.workspaceBackups.iterator();
            while (i$.hasNext() && (fullBackupsState = (bc = i$.next()).getFullBackupState()) == 4) {
            }
            for (BackupChain bChein : this.workspaceBackups) {
                if (bChein.getBackupConfig().getBackupType() == 1 && (incrementalBackupsState = bChein.getIncrementalBackupState()) == 2) break;
            }
            this.state = this.config.getBackupType() == 0 ? (fullBackupsState == 4 ? 4 : 8) : (fullBackupsState == 4 && incrementalBackupsState == 4 ? 4 : (fullBackupsState == 4 && incrementalBackupsState == 2 ? 16 : 8));
        }
        return this.state;
    }

    public boolean isFinished() {
        return this.getState() == 4;
    }

    public void startBackup() {
        for (BackupChain wsChain : this.workspaceBackups) {
            wsChain.startBackup();
        }
        this.state = 8;
    }

    public void stopBackup() {
        if (this.state != 0 || this.getState() != 4) {
            for (BackupChain wsChain : this.workspaceBackups) {
                wsChain.stopBackup();
            }
            this.repositoryChainLog.endLog();
        }
        this.state = this.getState();
    }

    public String getBackupId() {
        return this.repositoryBackupId;
    }

    public Calendar getStartedTime() {
        return this.startTime;
    }

    public RepositoryBackupConfig getBackupConfig() {
        return this.config;
    }

    private String getState(int type) {
        String state = "UNDEFINED STATE";
        if (type == 4) {
            state = "FINISHED";
        } else if (type == 0) {
            state = "STARTING";
        } else if (type == 1) {
            state = "WAITING";
        } else if (type == 2) {
            state = "WORKING";
        }
        return state;
    }
}

