/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ftp.command;

import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.services.ftp.command.FtpCommandImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CmdSize
extends FtpCommandImpl {
    private static Log log = ExoLogger.getLogger("exo.jcr.component.ftp.CmdSize");

    public CmdSize() {
        this.commandName = "SIZE";
    }

    public void run(String[] params) throws IOException {
        if (params.length < 2) {
            this.reply(String.format("500 %s: command requires a parameter", "SIZE"));
            return;
        }
        String resName = params[1];
        ArrayList<String> newPath = this.clientSession().getFullPath(resName);
        if (newPath.size() == 0) {
            this.reply(String.format("550 %s: No such file", resName));
            return;
        }
        String repoPath = this.clientSession().getRepoPath(newPath);
        try {
            Session curSession = this.clientSession().getSession(newPath.get(0));
            Node curNode = (Node)curSession.getItem(repoPath);
            if (curNode.isNodeType("nt:file")) {
                Node contentNode = curNode.getNode("jcr:content");
                int size = contentNode.getProperty("jcr:data").getStream().available();
                this.reply(String.format("213 %s", String.format("%d", size)));
                return;
            }
        }
        catch (PathNotFoundException pexc) {
        }
        catch (NoSuchWorkspaceException wexc) {
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), exc);
        }
        this.reply(String.format("550 %s: No such file", resName));
    }
}

