/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.common.webui;

import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.cs.common.webui.EventUIComponent;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.commons.UIDocumentSelector;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=Lifecycle.class, template="classpath:groovy/exoplatform/cs/common/webui/UIAddAttachment.gtmpl", events={@EventConfig(listeners={CancelActionListener.class}), @EventConfig(listeners={AttachFileActionListener.class}), @EventConfig(listeners={AttachLinkActionListener.class})})
public class UIAddAttachment
extends UIContainer
implements UIPopupComponent {
    protected static Log log = ExoLogger.getLogger(UIAddAttachment.class);
    protected static final String UIDOCUMENTSELECTOR = "UIDocumentSelector";
    protected static final String CANCEL = "Cancel";
    protected static final String ATTACH = "AttachFile";
    protected static final String ATTACHLINK = "AttachLink";
    public static final String SELECTEDFILE = "selectedFile";
    public static final String ISATTACHFILE = "isAttachFile";
    private EventUIComponent targetAttachEvent;

    public UIAddAttachment() {
        try {
            UIDocumentSelector documentSelector = (UIDocumentSelector)this.addChild(UIDocumentSelector.class, null, UIDOCUMENTSELECTOR);
            documentSelector.setAllowAddFolder(false);
            documentSelector.setAllowDeleteItem(false);
        }
        catch (Exception e) {
            log.error((Object)"An exception happens when init UIAddAttachment", (Throwable)e);
        }
    }

    public EventUIComponent getTargetAttachEvent() {
        return this.targetAttachEvent;
    }

    public void setTargetAttachEvent(EventUIComponent targetAttachEvent) {
        this.targetAttachEvent = targetAttachEvent;
    }

    public String getFileURL(String path) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (!(context instanceof PortalRequestContext)) {
            context = (WebuiRequestContext)context.getParentAppRequestContext();
        }
        String portalName = this.getPortalName();
        String requestURL = ((PortalRequestContext)context).getRequest().getRequestURL().toString();
        String domainURL = requestURL.substring(0, requestURL.indexOf(portalName));
        Session session = this.getCurrentSession();
        String workspace = session.getWorkspace().getName();
        String repository = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
        String url = domainURL + portalName + "/" + PortalContainer.getCurrentRestContextName() + "/jcr/" + repository + "/" + workspace + path;
        return url;
    }

    public Session getCurrentSession() throws Exception {
        RepositoryService repoService = (RepositoryService)PortalContainer.getInstance().getComponentInstanceOfType(RepositoryService.class);
        String defaultWorkspace = repoService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        return repoService.getDefaultRepository().getSystemSession(defaultWorkspace);
    }

    private String getPortalName() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortalContainerInfo containerInfo = (PortalContainerInfo)container.getComponentInstanceOfType(PortalContainerInfo.class);
        return containerInfo.getContainerName();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GenericAttachActionListener
    extends EventListener<UIAddAttachment> {
        public String getSelectedFile(Event<UIAddAttachment> event) throws Exception {
            return ((UIDocumentSelector)((UIAddAttachment)((Object)event.getSource())).getChild(UIDocumentSelector.class)).getSeletedFile();
        }

        public void execute(Event<UIAddAttachment> event) throws Exception {
            UIAddAttachment component = (UIAddAttachment)((Object)event.getSource());
            EventUIComponent eventUIComponent = component.getTargetAttachEvent();
            UIPortletApplication portlet = (UIPortletApplication)component.getAncestorOfType(UIPortletApplication.class);
            UIComponent targerComponent = portlet.findComponentById(eventUIComponent.getId());
            Event xEvent = targerComponent.createEvent(eventUIComponent.getEventName(), Event.Phase.PROCESS, event.getRequestContext());
            if (StringUtils.isEmpty((String)this.getSelectedFile(event))) {
                UIApplication uiApp = (UIApplication)((UIAddAttachment)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIAddAttachment.msg.not-a-file", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            this.processEvent(event);
            if (xEvent != null) {
                xEvent.broadcast();
            }
            UIPopupWindow uiPopupWindow = (UIPopupWindow)((UIAddAttachment)((Object)event.getSource())).getParent();
            uiPopupWindow.setShow(false);
            uiPopupWindow.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPopupWindow.getParent());
        }

        public void processEvent(Event<UIAddAttachment> event) throws Exception {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttachLinkActionListener
    extends GenericAttachActionListener {
        @Override
        public void processEvent(Event<UIAddAttachment> event) throws Exception {
            UIAddAttachment component = (UIAddAttachment)((Object)event.getSource());
            event.getRequestContext().setAttribute(UIAddAttachment.SELECTEDFILE, (Object)component.getFileURL(this.getSelectedFile(event)));
            event.getRequestContext().setAttribute(UIAddAttachment.ISATTACHFILE, (Object)false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttachFileActionListener
    extends GenericAttachActionListener {
        @Override
        public void processEvent(Event<UIAddAttachment> event) throws Exception {
            event.getRequestContext().setAttribute(UIAddAttachment.SELECTEDFILE, (Object)this.getSelectedFile(event));
            event.getRequestContext().setAttribute(UIAddAttachment.ISATTACHFILE, (Object)true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIAddAttachment> {
        public void execute(Event<UIAddAttachment> event) throws Exception {
            UIPopupWindow uiPopupWindow = (UIPopupWindow)((UIAddAttachment)((Object)event.getSource())).getParent();
            uiPopupWindow.setShow(false);
            uiPopupWindow.setRendered(false);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPopupWindow.getParent());
        }
    }
}

