/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.tiff;

import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class TiffMetadataReader {
    public static Metadata readMetadata(File file) throws TiffProcessingException {
        DataInputStream dataInputStream;
        Metadata metadata = new Metadata();
        try {
            dataInputStream = new DataInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TiffProcessingException("JPEG file does not exist", fileNotFoundException);
        }
        byte[] byArray = new byte[(int)file.length()];
        try {
            dataInputStream.readFully(byArray);
        }
        catch (IOException iOException) {
            throw new TiffProcessingException("Error copying file contents to byte buffer", iOException);
        }
        new ExifReader(byArray).extractTiff(metadata);
        return metadata;
    }

    public static Metadata readMetadata(InputStream inputStream) throws TiffProcessingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
        }
        catch (IOException iOException) {
            throw new TiffProcessingException("Error processing tiff stream", iOException);
        }
        Metadata metadata = new Metadata();
        new ExifReader(byteArrayOutputStream.toByteArray()).extractTiff(metadata);
        return metadata;
    }
}

