/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.RPCManager;
import org.jboss.cache.ReplicationException;
import org.jboss.cache.SuspectException;
import org.jboss.cache.commands.ReplicableCommand;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.RuntimeConfig;
import org.jboss.cache.factories.ComponentRegistry;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.factories.annotations.Stop;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.jmx.annotations.MBean;
import org.jboss.cache.jmx.annotations.ManagedAttribute;
import org.jboss.cache.jmx.annotations.ManagedOperation;
import org.jboss.cache.lock.LockManager;
import org.jboss.cache.lock.LockUtil;
import org.jboss.cache.lock.TimeoutException;
import org.jboss.cache.marshall.CommandAwareRpcDispatcher;
import org.jboss.cache.marshall.InactiveRegionAwareRpcDispatcher;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.remoting.jgroups.ChannelMessageListener;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionTable;
import org.jboss.cache.util.CachePrinter;
import org.jboss.cache.util.concurrent.ReclosableLatch;
import org.jboss.cache.util.reflect.ReflectionUtil;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelFactory;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.ExtendedMembershipListener;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MessageListener;
import org.jgroups.View;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.pbcast.STREAMING_STATE_TRANSFER;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBean(objectName="RPCManager", description="Manages RPC connections to remote caches")
public class RPCManagerImpl
implements RPCManager {
    private Channel channel;
    private final Log log = LogFactory.getLog(RPCManagerImpl.class);
    private final boolean trace = this.log.isTraceEnabled();
    private volatile List<Address> members;
    private long replicationCount;
    private long replicationFailures;
    private boolean statisticsEnabled = false;
    private final Object coordinatorLock = new Object();
    private volatile boolean coordinator = false;
    volatile Address lastStateTransferSource;
    private CommandAwareRpcDispatcher rpcDispatcher = null;
    private ChannelMessageListener messageListener;
    Configuration configuration;
    private Notifier notifier;
    private CacheSPI spi;
    private InvocationContextContainer invocationContextContainer;
    private Marshaller marshaller;
    private TransactionManager txManager;
    private TransactionTable txTable;
    private InterceptorChain interceptorChain;
    private boolean isUsingBuddyReplication;
    private volatile boolean isInLocalMode;
    private ComponentRegistry componentRegistry;
    private LockManager lockManager;
    private FlushTracker flushTracker;

    @Inject
    public void setupDependencies(ChannelMessageListener messageListener, Configuration configuration, Notifier notifier, CacheSPI spi, Marshaller marshaller, TransactionTable txTable, TransactionManager txManager, InvocationContextContainer container, InterceptorChain interceptorChain, ComponentRegistry componentRegistry, LockManager lockManager) {
        this.messageListener = messageListener;
        this.configuration = configuration;
        this.notifier = notifier;
        this.spi = spi;
        this.marshaller = marshaller;
        this.txManager = txManager;
        this.txTable = txTable;
        this.invocationContextContainer = container;
        this.interceptorChain = interceptorChain;
        this.componentRegistry = componentRegistry;
        this.lockManager = lockManager;
    }

    @Override
    @Start(priority=15)
    public void start() {
        switch (this.configuration.getCacheMode()) {
            case LOCAL: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"cache mode is local, will not create the channel");
                }
                this.isInLocalMode = true;
                this.isUsingBuddyReplication = false;
                break;
            }
            case REPL_SYNC: 
            case REPL_ASYNC: 
            case INVALIDATION_ASYNC: 
            case INVALIDATION_SYNC: {
                this.isInLocalMode = false;
                boolean bl = this.isUsingBuddyReplication = this.configuration.getBuddyReplicationConfig() != null && this.configuration.getBuddyReplicationConfig().isEnabled();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Cache mode is " + (Object)((Object)this.configuration.getCacheMode())));
                }
                boolean fetchState = this.shouldFetchStateOnStartup();
                boolean nonBlocking = this.configuration.isNonBlockingStateTransfer();
                this.sanityCheckConfiguration(nonBlocking, fetchState);
                this.flushTracker = nonBlocking ? new NonBlockingFlushTracker() : new StandardFlushTracker();
                this.initialiseChannelAndRpcDispatcher(fetchState && !nonBlocking, nonBlocking);
                if (!fetchState || nonBlocking) {
                    try {
                        if (nonBlocking) {
                            this.componentRegistry.setStatusCheckNecessary(false);
                        }
                        this.channel.connect(this.configuration.getClusterName());
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("Cache local address is " + this.getLocalAddress()));
                        }
                    }
                    catch (ChannelException e) {
                        throw new CacheException("Unable to connect to JGroups channel", e);
                    }
                    if (!fetchState) {
                        return;
                    }
                }
                long start = System.currentTimeMillis();
                if (nonBlocking) {
                    this.startNonBlockStateTransfer(this.getMembers());
                } else {
                    try {
                        this.channel.connect(this.configuration.getClusterName(), null, null, this.configuration.getStateRetrievalTimeout());
                        if (this.log.isInfoEnabled()) {
                            this.log.info((Object)("Cache local address is " + this.getLocalAddress()));
                        }
                        if (this.getMembers().size() > 1 && !this.isCoordinator()) {
                            this.messageListener.waitForState();
                        }
                    }
                    catch (ChannelException e) {
                        throw new CacheException("Unable to connect to JGroups channel", e);
                    }
                    catch (Exception ex) {
                        this.disconnect();
                        throw new CacheException("Unable to fetch state on startup", ex);
                    }
                }
                if (!this.log.isInfoEnabled()) break;
                this.log.info((Object)("state was retrieved successfully (in " + CachePrinter.prettyPrint(System.currentTimeMillis() - start) + ")"));
            }
        }
    }

    private void sanityCheckJGroupsStack(JChannel channel) {
        if (channel.getProtocolStack().findProtocol(STREAMING_STATE_TRANSFER.class) == null) {
            throw new ConfigurationException("JGroups channel does not use STREAMING_STATE_TRANSFER!  This is a requirement for non-blocking state transfer.  Either make sure your JGroups configuration uses STREAMING_STATE_TRANSFER or disable non-blocking state transfer.");
        }
    }

    private void sanityCheckConfiguration(boolean nonBlockingStateTransfer, boolean fetchStateOnStart) {
        if (this.isInLocalMode || !nonBlockingStateTransfer || !fetchStateOnStart) {
            return;
        }
        if (this.configuration.getNodeLockingScheme() != Configuration.NodeLockingScheme.MVCC) {
            throw new ConfigurationException("Non-blocking state transfer is only supported with the MVCC node locking scheme.  Please change your node locking scheme to MVCC or disable non-blocking state transfer.");
        }
        if (this.isUsingBuddyReplication) {
            throw new ConfigurationException("Non-blocking state transfer cannot be used with buddy replication at this time.  Please disable either buddy replication or non-blocking state transfer.");
        }
    }

    private void startNonBlockStateTransfer(List<Address> members) {
        if (members.size() < 2) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Not retrieving state since cluster size is " + members.size()));
            }
            return;
        }
        boolean success = false;
        int numRetries = 5;
        int initwait = (1 + new Random().nextInt(10)) * 100;
        int waitIncreaseFactor = 2;
        int wait = initwait;
        block4: for (int i = 0; i < numRetries; ++i) {
            for (Address member : members) {
                if (member.equals(this.getLocalAddress())) continue;
                try {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)("Trying to fetch state from: " + member));
                    }
                    if (!this.getState(null, member)) continue;
                    this.messageListener.waitForState();
                    success = true;
                    break block4;
                }
                catch (Exception e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)"Error while fetching state", (Throwable)e);
                }
            }
            if (success) continue;
            wait *= waitIncreaseFactor;
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Could not find available peer for state, backing off and retrying after " + wait + " millis.  Retries left: " + (numRetries - 1 - i)));
            }
            try {
                Thread.sleep(wait);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (!success) {
            this.disconnect();
            throw new CacheException("Unable to fetch state on startup");
        }
        this.componentRegistry.setStatusCheckNecessary(true);
    }

    @Override
    public void disconnect() {
        if (this.channel != null && this.channel.isOpen()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"Disconnecting and closing the Channel");
            }
            this.channel.disconnect();
            this.channel.close();
        }
    }

    @Override
    @Stop(priority=8)
    public void stop() {
        try {
            this.disconnect();
        }
        catch (Exception toLog) {
            this.log.error((Object)"Problem closing channel; setting it to null", (Throwable)toLog);
        }
        this.channel = null;
        this.configuration.getRuntimeConfig().setChannel(null);
        if (this.rpcDispatcher != null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"Stopping the RpcDispatcher");
            }
            this.rpcDispatcher.stopDispatcher();
        }
        if (this.members != null) {
            this.members = null;
        }
        this.coordinator = false;
        this.rpcDispatcher = null;
    }

    private boolean shouldFetchStateOnStartup() {
        boolean loaderFetch = this.configuration.getCacheLoaderConfig() != null && this.configuration.getCacheLoaderConfig().isFetchPersistentState();
        return !this.configuration.isInactiveOnStartup() && !this.isUsingBuddyReplication && (this.configuration.isFetchInMemoryState() || loaderFetch);
    }

    private void initialiseChannelAndRpcDispatcher(boolean fetchStateWithoutNBST, boolean nbst) throws CacheException {
        this.channel = this.configuration.getRuntimeConfig().getChannel();
        if (this.channel == null) {
            this.channel = this.getMultiplexerChannel();
            if (this.channel != null) {
                ReflectionUtil.setValue(this.configuration, "accessible", true);
                this.configuration.setUsingMultiplexer(true);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Created Multiplexer Channel for cache cluster " + this.configuration.getClusterName() + " using stack " + this.configuration.getMultiplexerStack()));
                }
            } else {
                try {
                    if (this.configuration.getJGroupsConfigFile() != null) {
                        URL u = this.configuration.getJGroupsConfigFile();
                        if (this.trace) {
                            this.log.trace((Object)("Grabbing cluster properties from " + u));
                        }
                        this.channel = new JChannel(u);
                    } else if (this.configuration.getClusterConfig() == null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"setting cluster properties to default value");
                        }
                        this.channel = new JChannel(this.configuration.getDefaultClusterConfig());
                    } else {
                        if (this.trace) {
                            this.log.trace((Object)("Cache cluster properties: " + this.configuration.getClusterConfig()));
                        }
                        this.channel = new JChannel(this.configuration.getClusterConfig());
                    }
                }
                catch (ChannelException e) {
                    throw new CacheException(e);
                }
            }
            this.configuration.getRuntimeConfig().setChannel(this.channel);
        }
        if (nbst) {
            this.sanityCheckJGroupsStack((JChannel)this.channel);
        }
        this.channel.setOpt(3, (Object)false);
        this.channel.setOpt(5, (Object)true);
        this.channel.setOpt(6, (Object)fetchStateWithoutNBST);
        this.channel.setOpt(0, (Object)true);
        this.rpcDispatcher = this.configuration.isUseRegionBasedMarshalling() ? new InactiveRegionAwareRpcDispatcher(this.channel, (MessageListener)this.messageListener, (MembershipListener)new MembershipListenerAdaptor(), this.spi, this.invocationContextContainer, this.interceptorChain, this.componentRegistry, this) : new CommandAwareRpcDispatcher(this.channel, (MessageListener)this.messageListener, (MembershipListener)new MembershipListenerAdaptor(), this.invocationContextContainer, this.invocationContextContainer, this.interceptorChain, this.componentRegistry, this);
        this.checkAppropriateConfig();
        this.rpcDispatcher.setRequestMarshaller((RpcDispatcher.Marshaller)this.marshaller);
        this.rpcDispatcher.setResponseMarshaller((RpcDispatcher.Marshaller)this.marshaller);
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    private JChannel getMultiplexerChannel() throws CacheException {
        String stackName = this.configuration.getMultiplexerStack();
        RuntimeConfig rtc = this.configuration.getRuntimeConfig();
        ChannelFactory channelFactory = rtc.getMuxChannelFactory();
        JChannel muxchannel = null;
        if (channelFactory != null) {
            try {
                muxchannel = (JChannel)channelFactory.createMultiplexerChannel(stackName, this.configuration.getClusterName());
            }
            catch (Exception e) {
                throw new CacheException("Failed to create multiplexed channel using stack " + stackName, e);
            }
        }
        if (this.trace) {
            if (muxchannel == null) {
                this.log.trace((Object)"Null mux channel!");
            } else {
                this.log.trace((Object)("Using multiplex channel: " + muxchannel.printProtocolSpec(true)));
            }
        }
        return muxchannel;
    }

    @Deprecated
    private void removeLocksForDeadMembers(NodeSPI node, List deadMembers) {
        HashSet<GlobalTransaction> deadOwners = new HashSet<GlobalTransaction>();
        Object owner = this.lockManager.getWriteOwner(node);
        if (this.isLockOwnerDead(owner, deadMembers)) {
            deadOwners.add((GlobalTransaction)owner);
        }
        for (Object object : this.lockManager.getReadOwners(node)) {
            if (!this.isLockOwnerDead(object, deadMembers)) continue;
            deadOwners.add((GlobalTransaction)object);
        }
        for (GlobalTransaction globalTransaction : deadOwners) {
            boolean localTx = globalTransaction.getAddress().equals(this.getLocalAddress());
            boolean broken = LockUtil.breakTransactionLock(node.getFqn(), this.lockManager, globalTransaction, localTx, this.txTable, this.txManager);
            if (!broken || !this.trace) continue;
            this.log.trace((Object)("Broke lock for node " + node.getFqn() + " held by " + globalTransaction));
        }
        for (Object object : node.getChildrenDirect()) {
            this.removeLocksForDeadMembers((NodeSPI)object, deadMembers);
        }
    }

    private void removeLocksForDeadMembers(InternalNode<?, ?> node, List deadMembers) {
        HashSet<GlobalTransaction> deadOwners = new HashSet<GlobalTransaction>();
        Object owner = this.lockManager.getWriteOwner(node.getFqn());
        if (this.isLockOwnerDead(owner, deadMembers)) {
            deadOwners.add((GlobalTransaction)owner);
        }
        for (GlobalTransaction globalTransaction : deadOwners) {
            boolean localTx = globalTransaction.getAddress().equals(this.getLocalAddress());
            boolean broken = LockUtil.breakTransactionLock(node.getFqn(), this.lockManager, globalTransaction, localTx, this.txTable, this.txManager);
            if (!broken || !this.trace) continue;
            this.log.trace((Object)("Broke lock for node " + node.getFqn() + " held by " + globalTransaction));
        }
        for (InternalNode internalNode : node.getChildren()) {
            this.removeLocksForDeadMembers(internalNode, deadMembers);
        }
    }

    private boolean isLockOwnerDead(Object owner, List deadMembers) {
        boolean result = false;
        if (owner != null && owner instanceof GlobalTransaction) {
            Object addr = ((GlobalTransaction)owner).getAddress();
            result = deadMembers.contains(addr);
        }
        return result;
    }

    @Override
    public List<Object> callRemoteMethods(Vector<Address> recipients, ReplicableCommand command, int mode, long timeout, boolean useOutOfBandMessage) throws Exception {
        return this.callRemoteMethods(recipients, command, mode, timeout, null, useOutOfBandMessage);
    }

    @Override
    public List<Object> callRemoteMethods(Vector<Address> recipients, ReplicableCommand command, boolean synchronous, long timeout, boolean useOutOfBandMessage) throws Exception {
        return this.callRemoteMethods(recipients, command, synchronous ? 2 : 6, timeout, useOutOfBandMessage);
    }

    @Override
    public List<Object> callRemoteMethods(Vector<Address> recipients, ReplicableCommand command, int mode, long timeout, RspFilter responseFilter, boolean useOutOfBandMessage) throws Exception {
        boolean success = true;
        boolean unlock = false;
        try {
            if (this.rpcDispatcher == null) {
                List<Object> list = null;
                return list;
            }
            int modeToUse = mode;
            int preferredMode = this.spi.getInvocationContext().getOptionOverrides().getGroupRequestMode();
            if (preferredMode > -1) {
                modeToUse = preferredMode;
            }
            if (this.trace) {
                this.log.trace((Object)("callRemoteMethods(): valid members are " + recipients + " methods: " + command + " Using OOB? " + useOutOfBandMessage + " modeToUse: " + modeToUse));
            }
            this.flushTracker.lockProcessingLock();
            unlock = true;
            this.flushTracker.waitForFlushCompletion(this.configuration.getStateRetrievalTimeout());
            useOutOfBandMessage = false;
            RspList rsps = this.rpcDispatcher.invokeRemoteCommands(recipients, command, modeToUse, timeout, this.isUsingBuddyReplication, useOutOfBandMessage, responseFilter);
            if (mode == 6) {
                List<Object> list = Collections.emptyList();
                return list;
            }
            if (this.trace) {
                this.log.trace((Object)("(" + this.getLocalAddress() + "): responses for method " + command.getClass().getSimpleName() + ":\n" + rsps));
            }
            if (rsps == null) {
                List<Object> list = Collections.emptyList();
                return list;
            }
            ArrayList<Object> retval = new ArrayList<Object>(rsps.size());
            for (Rsp rsp : rsps.values()) {
                if (rsp.wasSuspected() || !rsp.wasReceived()) {
                    CacheException ex = rsp.wasSuspected() ? new SuspectException("Suspected member: " + rsp.getSender()) : new TimeoutException("Replication timeout for " + rsp.getSender());
                    retval.add(new ReplicationException("rsp=" + rsp, ex));
                    success = false;
                    continue;
                }
                Object value = rsp.getValue();
                if (value instanceof Exception && !(value instanceof ReplicationException)) {
                    if (this.trace) {
                        this.log.trace((Object)("Recieved exception'" + value + "' from " + rsp.getSender()));
                    }
                    throw (Exception)value;
                }
                retval.add(value);
                success = true;
            }
            ArrayList<Object> arrayList = retval;
            return arrayList;
        }
        catch (Exception e) {
            success = false;
            throw e;
        }
        finally {
            this.computeStats(success);
            if (unlock) {
                this.flushTracker.unlockProcessingLock();
            }
        }
    }

    @Override
    public void fetchPartialState(List<Address> sources, Fqn sourceTarget, Fqn integrationTarget) throws Exception {
        String encodedStateId = sourceTarget + "_PARTIAL_STATE_DELIMITER" + integrationTarget;
        this.fetchPartialState(sources, encodedStateId);
    }

    @Override
    public void fetchPartialState(List<Address> sources, Fqn subtree) throws Exception {
        if (subtree == null) {
            throw new IllegalArgumentException("Cannot fetch partial state. Null subtree.");
        }
        this.fetchPartialState(sources, subtree.toString());
    }

    private void fetchPartialState(List<Address> sources, String stateId) throws Exception {
        if (sources == null || sources.isEmpty() || stateId == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("Cannot fetch partial state, targets are " + sources + " and stateId is " + stateId));
            }
            return;
        }
        LinkedList<Address> targets = new LinkedList<Address>(sources);
        targets.remove(this.getLocalAddress());
        if (targets.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Cannot fetch partial state. There are no target members specified");
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Node " + this.getLocalAddress() + " fetching partial state " + stateId + " from members " + targets));
        }
        boolean successfulTransfer = false;
        for (Address target : targets) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Node " + this.getLocalAddress() + " fetching partial state " + stateId + " from member " + target));
                }
                this.messageListener.setStateSet(false);
                successfulTransfer = this.getState(stateId, target);
                if (successfulTransfer) {
                    try {
                        this.messageListener.waitForState();
                    }
                    catch (Exception transferFailed) {
                        if (this.trace) {
                            this.log.trace((Object)"Error while fetching state", (Throwable)transferFailed);
                        }
                        successfulTransfer = false;
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Node " + this.getLocalAddress() + " fetching partial state " + stateId + " from member " + target + (successfulTransfer ? " successful" : " failed")));
                }
                if (!successfulTransfer) continue;
                break;
            }
            catch (IllegalStateException ise) {
                if (!this.log.isInfoEnabled()) continue;
                this.log.info((Object)"Channel problems fetching state.  Continuing on to next provider. ", (Throwable)ise);
            }
        }
        if (!successfulTransfer && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Node " + this.getLocalAddress() + " could not fetch partial state " + stateId + " from any member " + targets));
        }
    }

    private boolean getState(String stateId, Address target) throws ChannelNotConnectedException, ChannelClosedException {
        this.lastStateTransferSource = target;
        return ((JChannel)this.channel).getState(target, stateId, this.configuration.getStateRetrievalTimeout(), !this.configuration.isNonBlockingStateTransfer());
    }

    @ManagedAttribute(description="Local address")
    public String getLocalAddressString() {
        Address address = this.getLocalAddress();
        return address == null ? "null" : address.toString();
    }

    @Override
    public Address getLastStateTransferSource() {
        return this.lastStateTransferSource;
    }

    @Override
    public Address getLocalAddress() {
        return this.channel != null ? this.channel.getLocalAddress() : null;
    }

    @ManagedAttribute(description="Cluster view")
    public String getMembersString() {
        List<Address> l = this.getMembers();
        return l == null ? "null" : l.toString();
    }

    @Override
    public List<Address> getMembers() {
        if (this.isInLocalMode) {
            return null;
        }
        if (this.members == null) {
            return Collections.emptyList();
        }
        return this.members;
    }

    @Override
    public boolean isCoordinator() {
        return this.coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address getCoordinator() {
        if (this.channel == null) {
            return null;
        }
        Object object = this.coordinatorLock;
        synchronized (object) {
            while (this.members == null || this.members.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"getCoordinator(): waiting on viewAccepted()");
                }
                try {
                    this.coordinatorLock.wait();
                }
                catch (InterruptedException e) {
                    this.log.error((Object)"getCoordinator(): Interrupted while waiting for members to be set", (Throwable)e);
                    break;
                }
            }
            return this.members != null && this.members.size() > 0 ? this.members.get(0) : null;
        }
    }

    private void computeStats(boolean success) {
        if (this.statisticsEnabled && this.rpcDispatcher != null) {
            if (success) {
                ++this.replicationCount;
            } else {
                ++this.replicationFailures;
            }
        }
    }

    @ManagedOperation
    public void resetStatistics() {
        this.replicationCount = 0L;
        this.replicationFailures = 0L;
    }

    @ManagedAttribute(description="number of successful replications")
    public long getReplicationCount() {
        return this.replicationCount;
    }

    @ManagedAttribute(description="number of failed replications")
    public long getReplicationFailures() {
        return this.replicationFailures;
    }

    @ManagedAttribute(description="whether or not jmx statistics are enabled")
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @ManagedAttribute(description="whether or not the RPCManager is used in this cache instance")
    public boolean isEnabled() {
        return !this.isInLocalMode;
    }

    @ManagedAttribute
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @ManagedAttribute(description="RPC call success ratio")
    public String getSuccessRatio() {
        if (this.replicationCount == 0L || !this.statisticsEnabled) {
            return "N/A";
        }
        double totalCount = this.replicationCount + this.replicationFailures;
        double ration = (double)this.replicationCount / totalCount * 100.0;
        return NumberFormat.getInstance().format(ration) + "%";
    }

    private void checkAppropriateConfig() {
        ProtocolStack stack;
        TP transport;
        if (this.configuration.getMultiplexerStack() != null) {
            return;
        }
        Configuration.CacheMode cacheMode = this.configuration.getCacheMode();
        if (!cacheMode.equals((Object)Configuration.CacheMode.LOCAL) && this.configuration.getCacheMode().isSynchronous() && (transport = (stack = ((JChannel)this.channel).getProtocolStack()).getTransport()).isEnableBundling() && this.log.isWarnEnabled()) {
            this.log.warn((Object)"You have enabled jgroups's message bundling, which is not recommended for sync replication. If there is no particular reason for this we strongly recommend to disable message bundling in JGroups config (enable_bundling=\"false\").");
        }
        if (!cacheMode.isSynchronous() && !(transport = (stack = ((JChannel)this.channel).getProtocolStack()).getTransport()).isEnableBundling() && this.log.isWarnEnabled()) {
            this.log.warn((Object)"You have disabled jgroups's message bundling, which is not recommended for async replication. If there is no particular reason for this we strongly recommend to enable message bundling in JGroups config (enable_bundling=\"true\").");
        }
    }

    @Override
    public FlushTracker getFlushTracker() {
        return this.flushTracker;
    }

    protected class MembershipListenerAdaptor
    implements ExtendedMembershipListener {
        protected MembershipListenerAdaptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewAccepted(View newView) {
            try {
                Vector newMembers = newView.getMembers();
                if (RPCManagerImpl.this.log.isInfoEnabled()) {
                    RPCManagerImpl.this.log.info((Object)("Received new cluster view: " + newView));
                }
                Object object = RPCManagerImpl.this.coordinatorLock;
                synchronized (object) {
                    boolean needNotification = false;
                    if (newMembers != null) {
                        if (RPCManagerImpl.this.members != null) {
                            ArrayList removed = new ArrayList(RPCManagerImpl.this.members);
                            removed.removeAll(newMembers);
                            RPCManagerImpl.this.spi.getInvocationContext().getOptionOverrides().setSkipCacheStatusCheck(true);
                            NodeSPI root = RPCManagerImpl.this.spi.getRoot();
                            if (root != null) {
                                if (RPCManagerImpl.this.configuration.getNodeLockingScheme() == Configuration.NodeLockingScheme.MVCC) {
                                    RPCManagerImpl.this.removeLocksForDeadMembers(root.getDelegationTarget(), removed);
                                } else {
                                    RPCManagerImpl.this.removeLocksForDeadMembers(root, removed);
                                }
                            }
                        }
                        RPCManagerImpl.this.members = new ArrayList(newMembers);
                        needNotification = true;
                    }
                    RPCManagerImpl.this.coordinator = RPCManagerImpl.this.members != null && RPCManagerImpl.this.members.size() != 0 && ((Address)RPCManagerImpl.this.members.get(0)).equals(RPCManagerImpl.this.getLocalAddress());
                    if (needNotification && RPCManagerImpl.this.notifier != null) {
                        InvocationContext ctx = RPCManagerImpl.this.spi.getInvocationContext();
                        RPCManagerImpl.this.notifier.notifyViewChange(newView, ctx);
                    }
                    RPCManagerImpl.this.coordinatorLock.notifyAll();
                }
            }
            catch (Throwable e) {
                RPCManagerImpl.this.log.error((Object)"Error found while processing view accepted!!!", e);
            }
        }

        public void suspect(Address suspected_mbr) {
        }

        public void block() {
            if (!RPCManagerImpl.this.configuration.isNonBlockingStateTransfer()) {
                try {
                    if (RPCManagerImpl.this.log.isDebugEnabled()) {
                        RPCManagerImpl.this.log.debug((Object)("Block received at " + RPCManagerImpl.this.getLocalAddress()));
                    }
                    RPCManagerImpl.this.flushTracker.block();
                    RPCManagerImpl.this.notifier.notifyCacheBlocked(true);
                    RPCManagerImpl.this.notifier.notifyCacheBlocked(false);
                    if (RPCManagerImpl.this.log.isDebugEnabled()) {
                        RPCManagerImpl.this.log.debug((Object)("Block processed at " + RPCManagerImpl.this.getLocalAddress()));
                    }
                }
                catch (Throwable e) {
                    RPCManagerImpl.this.log.error((Object)"Error found while processing block()", e);
                }
            }
        }

        public void unblock() {
            if (!RPCManagerImpl.this.configuration.isNonBlockingStateTransfer()) {
                try {
                    if (RPCManagerImpl.this.log.isDebugEnabled()) {
                        RPCManagerImpl.this.log.debug((Object)("UnBlock received at " + RPCManagerImpl.this.getLocalAddress()));
                    }
                    RPCManagerImpl.this.notifier.notifyCacheUnblocked(true);
                    RPCManagerImpl.this.notifier.notifyCacheUnblocked(false);
                    RPCManagerImpl.this.flushTracker.unblock();
                    if (RPCManagerImpl.this.log.isDebugEnabled()) {
                        RPCManagerImpl.this.log.debug((Object)("UnBlock processed at " + RPCManagerImpl.this.getLocalAddress()));
                    }
                }
                catch (Throwable e) {
                    RPCManagerImpl.this.log.error((Object)"Error found while processing unblock", e);
                }
            }
        }
    }

    private final class NonBlockingFlushTracker
    extends FlushTracker {
        private final ReentrantReadWriteLock coordinationLock;

        private NonBlockingFlushTracker() {
            this.coordinationLock = new ReentrantReadWriteLock();
        }

        public void lockProcessingLock() throws InterruptedException {
            if (!this.coordinationLock.readLock().tryLock(RPCManagerImpl.this.configuration.getStateRetrievalTimeout(), TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Could not obtain processing lock");
            }
        }

        public void unlockProcessingLock() {
            this.coordinationLock.readLock().unlock();
        }

        public void lockSuspendProcessingLock() throws InterruptedException {
            while (true) {
                try {
                    if (!this.coordinationLock.writeLock().tryLock(RPCManagerImpl.this.configuration.getStateRetrievalTimeout(), TimeUnit.MILLISECONDS)) {
                        throw new TimeoutException("Could not obtain processing lock");
                    }
                    return;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }

        public void unlockSuspendProcessingLock() {
            if (this.coordinationLock.isWriteLockedByCurrentThread()) {
                this.coordinationLock.writeLock().unlock();
            }
        }

        public void waitForFlushCompletion(long timeout) throws InterruptedException {
            while (true) {
                try {
                    if (!this.flushBlockGate.await(timeout, TimeUnit.MILLISECONDS)) {
                        throw new TimeoutException("Timed out waiting for flush to unblock. (timeout = " + CachePrinter.prettyPrint(timeout) + ")");
                    }
                    return;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }

        public void waitForFlushStart(long timeout) throws InterruptedException {
            while (true) {
                try {
                    if (!this.flushWaitGate.await(timeout, TimeUnit.MILLISECONDS)) {
                        throw new TimeoutException("Timed out waiting for flush to block. (timeout = " + CachePrinter.prettyPrint(timeout) + ")");
                    }
                    return;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
        }
    }

    private final class StandardFlushTracker
    extends FlushTracker {
        private StandardFlushTracker() {
        }

        public void lockProcessingLock() {
        }

        public void lockSuspendProcessingLock() {
        }

        public void unlockProcessingLock() {
        }

        public void unlockSuspendProcessingLock() {
        }
    }

    public abstract class FlushTracker {
        final ReclosableLatch flushBlockGate = new ReclosableLatch(true);
        private final AtomicInteger flushCompletionCount = new AtomicInteger();
        final ReclosableLatch flushWaitGate = new ReclosableLatch(false);

        public void block() {
            this.flushBlockGate.close();
            this.flushWaitGate.open();
        }

        public void unblock() {
            this.flushWaitGate.close();
            this.flushCompletionCount.incrementAndGet();
            this.flushBlockGate.open();
        }

        public int getFlushCompletionCount() {
            return this.flushCompletionCount.get();
        }

        public abstract void lockProcessingLock() throws InterruptedException;

        public abstract void unlockProcessingLock();

        public abstract void lockSuspendProcessingLock() throws InterruptedException;

        public abstract void unlockSuspendProcessingLock();

        public void waitForFlushCompletion(long timeout) throws InterruptedException {
            if (RPCManagerImpl.this.channel.flushSupported() && !this.flushBlockGate.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Timed out waiting for flush to unblock. (timeout = " + CachePrinter.prettyPrint(timeout) + ")");
            }
        }

        public void waitForFlushStart(long timeout) throws InterruptedException {
            if (RPCManagerImpl.this.channel.flushSupported() && !this.flushWaitGate.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Timed out waiting for flush to block. (timeout = " + CachePrinter.prettyPrint(timeout) + " )");
            }
        }
    }
}

