/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.form;

import java.io.InputStream;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.form.DialogFormException;
import org.exoplatform.ecm.webui.form.DialogFormField;
import org.exoplatform.ecm.webui.form.field.UIFormActionField;
import org.exoplatform.ecm.webui.form.field.UIFormCalendarField;
import org.exoplatform.ecm.webui.form.field.UIFormCheckBoxField;
import org.exoplatform.ecm.webui.form.field.UIFormHiddenField;
import org.exoplatform.ecm.webui.form.field.UIFormRadioBoxField;
import org.exoplatform.ecm.webui.form.field.UIFormRichtextField;
import org.exoplatform.ecm.webui.form.field.UIFormSelectBoxField;
import org.exoplatform.ecm.webui.form.field.UIFormTextAreaField;
import org.exoplatform.ecm.webui.form.field.UIFormTextField;
import org.exoplatform.ecm.webui.form.field.UIFormUploadField;
import org.exoplatform.ecm.webui.form.field.UIFormWYSIWYGField;
import org.exoplatform.ecm.webui.form.field.UIMixinField;
import org.exoplatform.ecm.webui.form.validator.UploadFileMimeTypesValidator;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.scripts.CmsScript;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.ecm.fckconfig.FCKConfigService;
import org.exoplatform.services.ecm.fckconfig.FCKEditorContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.form.UIFormRichtextInput;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.UIFormUploadInput;
import org.exoplatform.webui.form.wysiwyg.FCKEditorConfig;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(type=UIFormMultiValueInputSet.class, id="WYSIWYGRichTextMultipleInputset", events={@EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIFormMultiValueInputSet.RemoveActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIDialogForm
extends UIForm {
    private static final Log LOG = ExoLogger.getLogger((String)"webui.form.UIDialogForm");
    private final String REPOSITORY = "repository";
    protected static final String CANCEL_ACTION = "Cancel".intern();
    protected static final String SAVE_ACTION = "Save".intern();
    protected static final String[] ACTIONS = new String[]{SAVE_ACTION, CANCEL_ACTION};
    private static final String WYSIWYG_MULTI_ID = "WYSIWYGRichTextMultipleInputset";
    protected Map<String, Map<String, String>> componentSelectors = new HashMap<String, Map<String, String>>();
    protected Map<String, String> fieldNames = new HashMap<String, String>();
    protected Map<String, String> propertiesName = new HashMap<String, String>();
    protected Map<String, String[]> uiMultiValueParam = new HashMap<String, String[]>();
    protected String contentType;
    protected boolean isAddNew = true;
    protected boolean isRemovePreference;
    protected boolean isRemoveActionField;
    protected boolean isShowingComponent;
    protected boolean isUpdateSelect;
    protected Map<String, JcrInputProperty> properties = new HashMap<String, JcrInputProperty>();
    protected String repositoryName;
    protected JCRResourceResolver resourceResolver;
    private String childPath;
    private boolean isNotEditNode;
    private boolean dataRemoved_;
    private boolean isNTFile;
    private boolean isOnchange;
    private boolean isResetForm;
    private boolean isResetMultiField;
    protected String nodePath;
    protected String i18nNodePath = null;
    private List<String> postScriptInterceptor = new ArrayList<String>();
    private List<String> prevScriptInterceptor = new ArrayList<String>();
    private List<String> listTaxonomy = new ArrayList<String>();
    private String storedPath;
    protected String workspaceName;
    protected boolean isReference;
    protected boolean isShowActionsOnTop_ = false;
    private String selectedTab;
    private static final String TAXONOMIES_ALIAS = "exoTaxonomiesPath";
    private String SEPARATOR_VALUE = "::";
    private boolean isKeepinglock = false;

    public boolean isEditing() {
        return !this.isAddNew;
    }

    public boolean isAddNew() {
        return this.isAddNew;
    }

    public void addNew(boolean b) {
        this.isAddNew = b;
    }

    public void setSelectedTab(String selectedTab) {
        this.selectedTab = selectedTab;
    }

    public String getSelectedTab() {
        return this.selectedTab;
    }

    public boolean isKeepinglock() {
        return this.isKeepinglock;
    }

    public void setIsKeepinglock(boolean isKeepinglock) {
        this.isKeepinglock = isKeepinglock;
    }

    public boolean isShowActionsOnTop() {
        return this.isShowActionsOnTop_;
    }

    public void setShowActionsOnTop(boolean isShowActionsOnTop) {
        this.isShowActionsOnTop_ = isShowActionsOnTop;
    }

    public void releaseLock() throws Exception {
        Node currentNode;
        if (this.isKeepinglock() && (currentNode = this.getNode()) != null && currentNode.isLocked()) {
            try {
                if (currentNode.holdsLock()) {
                    String lockToken = LockUtil.getLockTokenOfUser(currentNode);
                    if (lockToken != null) {
                        currentNode.getSession().addLockToken(LockUtil.getLockToken(currentNode));
                    }
                    currentNode.unlock();
                    currentNode.removeMixin("mix:lockable");
                    currentNode.save();
                    LockUtil.removeLock(currentNode);
                }
            }
            catch (LockException le) {
                LOG.error((Object)"Fails when unlock node that is editing", (Throwable)le);
            }
        }
        this.setIsKeepinglock(false);
    }

    public List<String> getListTaxonomy() {
        return this.listTaxonomy;
    }

    public void setListTaxonomy(List<String> listTaxonomy) {
        this.listTaxonomy = listTaxonomy;
    }

    @Deprecated
    public void setStoredLocation(String repository, String workspace, String storedPath) {
        this.setStoredLocation(workspace, storedPath);
    }

    public void setStoredLocation(String workspace, String storedPath) {
        try {
            this.repositoryName = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getConfiguration().getName();
        }
        catch (RepositoryException ex) {
            this.repositoryName = null;
        }
        this.setWorkspace(workspace);
        this.setStoredPath(storedPath);
    }

    protected String getCategoryLabel(String resource) {
        String[] taxonomyPathSplit = resource.split("/");
        StringBuilder buildPathlabel = new StringBuilder();
        for (int i = 0; i < taxonomyPathSplit.length; ++i) {
            StringBuilder buildlabel = new StringBuilder("eXoTaxonomies");
            for (int j = 0; j <= i; ++j) {
                buildlabel.append(".").append(taxonomyPathSplit[j]);
            }
            try {
                buildPathlabel.append(Utils.getResourceBundle(buildlabel.append(".label").toString())).append("/");
                continue;
            }
            catch (MissingResourceException me) {
                buildPathlabel.append(taxonomyPathSplit[i]).append("/");
            }
        }
        return buildPathlabel.substring(0, buildPathlabel.length() - 1);
    }

    public void seti18nNodePath(String nodePath) {
        this.i18nNodePath = nodePath;
    }

    public String geti18nNodePath() {
        return this.i18nNodePath;
    }

    public void addActionField(String name, String label, String[] arguments) throws Exception {
        Object uiInput;
        UIFormActionField formActionField = new UIFormActionField(name, label, arguments);
        if (formActionField.useSelector()) {
            this.componentSelectors.put(name, formActionField.getSelectorInfo());
        }
        String jcrPath = formActionField.getJcrPath();
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, inputProperty);
        Node node = this.getNode();
        boolean isFirstTimeRender = false;
        if (formActionField.isMultiValues()) {
            uiInput = this.findComponentById(name);
            if (uiInput == null) {
                isFirstTimeRender = true;
                uiInput = this.addMultiValuesInput(UIFormStringInput.class, name, label);
                String defaultValue = formActionField.getDefaultValue();
                if (defaultValue != null && UIFormMultiValueInputSet.class.isInstance(uiInput)) {
                    String[] arrDefaultValues = defaultValue.split(",");
                    ArrayList<String> lstValues = new ArrayList<String>();
                    for (String itemDefaultValues : arrDefaultValues) {
                        if (lstValues.contains(itemDefaultValues.trim())) continue;
                        lstValues.add(itemDefaultValues.trim());
                    }
                    ((UIFormMultiValueInputSet)uiInput).setValue(lstValues);
                }
            }
            ((UIFormMultiValueInputSet)uiInput).setEditable(formActionField.isEditable());
            if (node == null) {
                this.renderField(name);
                return;
            }
        } else {
            uiInput = this.findComponentById(name);
            if (uiInput == null) {
                isFirstTimeRender = true;
                uiInput = formActionField.createUIFormInput();
                this.addUIFormInput((UIFormInput)uiInput);
            }
            ((UIFormStringInput)uiInput).setEditable(formActionField.isEditable());
        }
        String propertyName = this.getPropertyName(jcrPath);
        this.propertiesName.put(name, propertyName);
        this.fieldNames.put(propertyName, name);
        if (!(node == null || this.isShowingComponent || this.isRemovePreference || this.isRemoveActionField || !jcrPath.equals("/node") || formActionField.isEditable() && !formActionField.isEditableIfNull())) {
            ((UIFormStringInput)uiInput).setEditable(false);
        }
        if (node != null && !this.isShowingComponent && !this.isRemovePreference && !this.isRemoveActionField && isFirstTimeRender) {
            if (jcrPath.equals("/node") && (!formActionField.isEditable() || formActionField.isEditableIfNull())) {
                ((UIFormStringInput)uiInput).setValue((Object)node.getName());
            } else if (node.hasProperty(propertyName) && !this.isUpdateSelect) {
                String relPath = "";
                String itemRelPath = "";
                if (node.getProperty(propertyName).getDefinition().isMultiple()) {
                    StringBuffer buffer = new StringBuffer();
                    Value[] values = node.getProperty(propertyName).getValues();
                    if (UIFormStringInput.class.isInstance(uiInput)) {
                        for (Value value : values) {
                            buffer.append(value).append(",");
                        }
                        if (buffer.toString().endsWith(",")) {
                            buffer.deleteCharAt(buffer.length() - 1);
                        }
                        ((UIFormStringInput)uiInput).setValue((Object)buffer.toString());
                    }
                    if (UIFormMultiValueInputSet.class.isInstance(uiInput)) {
                        ArrayList<String> lstValues = new ArrayList<String>();
                        for (Value value : values) {
                            lstValues.add(value.getString());
                        }
                        ((UIFormMultiValueInputSet)uiInput).setValue(lstValues);
                    }
                } else {
                    String value = node.getProperty(propertyName).getValue().getString();
                    if (node.getProperty(propertyName).getDefinition().getRequiredType() == 9) {
                        value = this.getNodePathByUUID(value);
                    }
                    ((UIFormStringInput)uiInput).setValue((Object)value);
                }
            }
        }
        Node childNode = this.getChildNode();
        if (this.isNotEditNode && !this.isShowingComponent && !this.isRemovePreference && !this.isRemoveActionField) {
            if (childNode != null) {
                ((UIFormInput)uiInput).setValue((Object)propertyName);
            } else if (childNode == null && jcrPath.equals("/node") && node != null) {
                ((UIFormInput)uiInput).setValue((Object)node.getName());
            } else {
                ((UIFormInput)uiInput).setValue(null);
            }
        }
        this.renderField(name);
    }

    public void addActionField(String name, String[] arguments) throws Exception {
        this.addActionField(name, null, arguments);
    }

    public void addCalendarField(String name, String label, String[] arguments) throws Exception {
        UIFormCalendarField calendarField = new UIFormCalendarField(name, label, arguments);
        String jcrPath = calendarField.getJcrPath();
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, inputProperty);
        if (calendarField.isMultiValues()) {
            this.renderMultiValuesInput(UIFormDateTimeInput.class, name, label);
            return;
        }
        boolean isFirstTimeRender = false;
        UIFormDateTimeInput uiDateTime = (UIFormDateTimeInput)this.findComponentById(name);
        if (uiDateTime == null) {
            isFirstTimeRender = true;
            uiDateTime = (UIFormDateTimeInput)calendarField.createUIFormInput();
            if (calendarField.validateType != null) {
                DialogFormUtil.addValidators((UIFormInputBase)uiDateTime, calendarField.validateType);
            }
        }
        uiDateTime.setDisplayTime(calendarField.isDisplayTime());
        String propertyName = this.getPropertyName(jcrPath);
        this.propertiesName.put(name, propertyName);
        this.fieldNames.put(propertyName, name);
        Node node = this.getNode();
        uiDateTime.setCalendar(uiDateTime.getCalendar());
        if (node != null && node.hasProperty(propertyName) && !this.isShowingComponent && !this.isRemovePreference && isFirstTimeRender) {
            uiDateTime.setCalendar(node.getProperty(propertyName).getDate());
        }
        Node childNode = this.getChildNode();
        if (this.isNotEditNode && !this.isShowingComponent && !this.isRemovePreference) {
            if (childNode != null) {
                if (childNode.hasProperty(propertyName)) {
                    if (childNode.getProperty(propertyName).getDefinition().isMultiple()) {
                        Value[] values;
                        for (Value value : values = childNode.getProperty(propertyName).getValues()) {
                            if (uiDateTime.getDefaultValue() != null) continue;
                            uiDateTime.setCalendar(value.getDate());
                            uiDateTime.setDefaultValue(uiDateTime.getValue());
                        }
                    } else {
                        uiDateTime.setCalendar(childNode.getProperty(propertyName).getValue().getDate());
                    }
                }
            } else if (childNode == null && jcrPath.equals("/node") && node != null) {
                uiDateTime.setCalendar(node.getProperty(propertyName).getDate());
            } else {
                uiDateTime.setCalendar((Calendar)new GregorianCalendar());
            }
        }
        if (this.findComponentById(name) == null) {
            this.addUIFormInput((UIFormInput)uiDateTime);
        }
        if (calendarField.isVisible()) {
            this.renderField(name);
        }
    }

    public void addCalendarField(String name, String[] arguments) throws Exception {
        this.addCalendarField(name, null, arguments);
    }

    public void addHiddenField(String name, String[] arguments) throws Exception {
        UIFormHiddenField formHiddenField = new UIFormHiddenField(name, null, arguments);
        String jcrPath = formHiddenField.getJcrPath();
        JcrInputProperty inputProperty = formHiddenField.createJcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        if (formHiddenField.getMixinTypes() != null) {
            inputProperty.setMixintype(formHiddenField.getMixinTypes());
        }
        if (formHiddenField.getNodeType() != null) {
            inputProperty.setNodetype(formHiddenField.getNodeType());
        }
        this.setInputProperty(name, inputProperty);
    }

    public void addInterceptor(String scriptPath, String type) {
        if (scriptPath.length() > 0 && type.length() > 0) {
            if (type.equals("prev")) {
                this.prevScriptInterceptor.add(scriptPath);
            } else if (type.equals("post")) {
                this.postScriptInterceptor.add(scriptPath);
            }
        }
    }

    public void addMixinField(String name, String label, String[] arguments) throws Exception {
        UIMixinField mixinField = new UIMixinField(name, label, arguments);
        String jcrPath = mixinField.getJcrPath();
        String nodetype = mixinField.getNodeType();
        String mixintype = mixinField.getMixinTypes();
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        if (nodetype != null || mixintype != null) {
            inputProperty.setType(1);
            if (nodetype != null) {
                inputProperty.setNodetype(nodetype);
            }
            if (mixintype != null) {
                inputProperty.setMixintype(mixintype);
            }
        }
        this.setInputProperty(name, inputProperty);
        Node node = this.getNode();
        if (node != null && mixinField.isVisibleIfNotNull()) {
            UIFormStringInput uiMixin = (UIFormStringInput)this.findComponentById(name);
            if (uiMixin == null) {
                uiMixin = (UIFormStringInput)mixinField.createUIFormInput();
                uiMixin.setValue((Object)node.getName());
                this.addUIFormInput((UIFormInput)uiMixin);
            } else {
                uiMixin.setValue((Object)node.getName());
            }
            uiMixin.setEditable(false);
            this.renderField(name);
        }
    }

    public void addMixinField(String name, String[] arguments) throws Exception {
        this.addMixinField(name, null, arguments);
    }

    public void addCheckBoxField(String name, String lable, String[] arguments) throws Exception {
        UIFormCheckBoxField formCheckBoxField = new UIFormCheckBoxField(name, lable, arguments);
        String jcrPath = formCheckBoxField.getJcrPath();
        String defaultValue = formCheckBoxField.getDefaultValue();
        if (defaultValue == null) {
            defaultValue = "false";
        }
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, inputProperty);
        String propertyName = this.getPropertyName(jcrPath);
        this.propertiesName.put(name, propertyName);
        this.fieldNames.put(propertyName, name);
        Node node = this.getNode();
        UIFormCheckBoxInput uiCheckBoxInput = (UIFormCheckBoxInput)this.findComponentById(name);
        boolean isFirstTimeRender = false;
        if (uiCheckBoxInput == null || this.isResetForm) {
            isFirstTimeRender = true;
            uiCheckBoxInput = new UIFormCheckBoxInput(name, name, null);
            if (defaultValue != null) {
                uiCheckBoxInput.setValue((Object)defaultValue);
                uiCheckBoxInput.setChecked(Boolean.valueOf(defaultValue).booleanValue());
            }
        }
        if (node != null && node.hasProperty(propertyName) && isFirstTimeRender) {
            uiCheckBoxInput.setValue((Object)node.getProperty(propertyName).getValue());
            uiCheckBoxInput.setChecked(node.getProperty(propertyName).getValue().getBoolean());
        }
        if (formCheckBoxField.validateType != null) {
            DialogFormUtil.addValidators((UIFormInputBase)uiCheckBoxInput, formCheckBoxField.validateType);
        }
        if (formCheckBoxField.isOnchange()) {
            uiCheckBoxInput.setOnChange("Onchange");
            uiCheckBoxInput.setValue(uiCheckBoxInput.getValue());
        }
        this.removeChildById(name);
        this.addUIFormInput((UIFormInput)uiCheckBoxInput);
        this.renderField(name);
    }

    public void addCheckBoxField(String name, String[] arguments) throws Exception {
        this.addCheckBoxField(name, null, arguments);
    }

    public void addRadioBoxField(String name, String label, String[] arguments) throws Exception {
        Node child;
        UIFormRadioBoxField formRadioBoxField = new UIFormRadioBoxField(name, label, arguments);
        String jcrPath = formRadioBoxField.getJcrPath();
        String options = formRadioBoxField.getOptions();
        String defaultValue = formRadioBoxField.getDefaultValue();
        ArrayList<SelectItemOption> optionsList = new ArrayList<SelectItemOption>();
        UIFormRadioBoxInput uiRadioBox = (UIFormRadioBoxInput)this.findComponentById(name);
        boolean isFirstTimeRender = false;
        if (uiRadioBox == null) {
            isFirstTimeRender = true;
            uiRadioBox = new UIFormRadioBoxInput(name, defaultValue, null);
            if (options != null && options.length() > 0) {
                String[] array = options.split(";");
                for (int i = 0; i < array.length; ++i) {
                    String[] arrayChild = array[i].trim().split(",");
                    for (int j = 0; j < arrayChild.length; ++j) {
                        optionsList.add(new SelectItemOption(arrayChild[j], (Object)arrayChild[j]));
                    }
                }
                uiRadioBox.setOptions(optionsList);
            } else {
                uiRadioBox.setOptions(optionsList);
            }
            if (defaultValue != null) {
                uiRadioBox.setDefaultValue((Object)defaultValue);
            }
        }
        this.addUIFormInput((UIFormInput)uiRadioBox);
        String propertyName = this.getPropertyName(jcrPath);
        this.propertiesName.put(name, propertyName);
        this.fieldNames.put(propertyName, name);
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, inputProperty);
        Node node = this.getNode();
        Node childNode = this.getChildNode();
        if (childNode != null) {
            if (childNode.hasProperty(propertyName) && isFirstTimeRender) {
                uiRadioBox.setValue((Object)childNode.getProperty(propertyName).getValue().getString());
            }
        } else if (node != null && node.hasProperty(propertyName) && isFirstTimeRender) {
            uiRadioBox.setValue((Object)node.getProperty(propertyName).getString());
        }
        if (this.isNotEditNode && (child = this.getChildNode()) != null && child.hasProperty(propertyName) && isFirstTimeRender) {
            uiRadioBox.setValue((Object)DialogFormUtil.getPropertyValueAsString(child, propertyName));
        }
        this.renderField(name);
    }

    public void addRadioBoxField(String name, String[] arguments) throws Exception {
        this.addRadioBoxField(name, null, arguments);
    }

    public void addSelectBoxField(String name, String label, String[] arguments) throws Exception {
        String oldValue;
        Node child;
        UIFormSelectBoxField formSelectBoxField = new UIFormSelectBoxField(name, label, arguments);
        String jcrPath = formSelectBoxField.getJcrPath();
        String editable = formSelectBoxField.getEditable();
        String onchange = formSelectBoxField.getOnchange();
        String defaultValue = formSelectBoxField.getDefaultValue();
        String options = formSelectBoxField.getOptions();
        String script = formSelectBoxField.getGroovyScript();
        if (editable == null) {
            formSelectBoxField.setEditable("true");
        }
        ArrayList<SelectItemOption> optionsList = new ArrayList<SelectItemOption>();
        UIFormSelectBox uiSelectBox = (UIFormSelectBox)this.findComponentById(name);
        boolean isFirstTimeRender = false;
        if (uiSelectBox == null || this.isResetForm) {
            isFirstTimeRender = true;
            uiSelectBox = new UIFormSelectBox(name, name, null);
            if (script != null) {
                try {
                    String[] scriptParams = formSelectBoxField.getScriptParams();
                    this.executeScript(script, uiSelectBox, scriptParams, true);
                }
                catch (Exception e) {
                    LOG.error((Object)"An unexpected error occurs", (Throwable)e);
                    uiSelectBox.setOptions(optionsList);
                }
            } else if (options != null && options.length() > 0) {
                String[] array = options.split(",");
                RequestContext context = RequestContext.getCurrentInstance();
                ResourceBundle res = context.getApplicationResourceBundle();
                for (int i = 0; i < array.length; ++i) {
                    String optionLabel;
                    ArrayList<String> listValue = new ArrayList<String>();
                    String[] arrayChild = array[i].trim().split(this.SEPARATOR_VALUE);
                    for (int j = 0; j < arrayChild.length; ++j) {
                        if (arrayChild[j].trim().equals("")) continue;
                        listValue.add(arrayChild[j].trim());
                    }
                    try {
                        String tagName = ((String)listValue.get(0)).replaceAll(" ", "-");
                        optionLabel = res.getString(tagName);
                    }
                    catch (MissingResourceException e) {
                        optionLabel = (String)listValue.get(0);
                    }
                    if (listValue.size() > 1) {
                        optionsList.add(new SelectItemOption(optionLabel, listValue.get(1)));
                        continue;
                    }
                    optionsList.add(new SelectItemOption(optionLabel, listValue.get(0)));
                }
                uiSelectBox.setOptions(optionsList);
            } else {
                uiSelectBox.setOptions(optionsList);
            }
            if (defaultValue != null) {
                uiSelectBox.setValue(defaultValue);
            }
        }
        this.propertiesName.put(name, this.getPropertyName(jcrPath));
        this.fieldNames.put(this.getPropertyName(jcrPath), name);
        if (formSelectBoxField.validateType != null) {
            DialogFormUtil.addValidators((UIFormInputBase)uiSelectBox, formSelectBoxField.validateType);
        }
        String[] arrNodes = jcrPath.split("/");
        Node childNode = null;
        Node node = this.getNode();
        String propertyName = this.getPropertyName(jcrPath);
        if (node != null && arrNodes.length == 4) {
            childNode = node.getNode(arrNodes[2]);
        }
        if (formSelectBoxField.isMultiValues()) {
            Object values;
            ArrayList valueList;
            if (formSelectBoxField.getSize() != null && StringUtils.isAlphanumeric((String)formSelectBoxField.getSize())) {
                uiSelectBox.setSize(Integer.parseInt(formSelectBoxField.getSize()));
            }
            uiSelectBox.setMultiple(true);
            StringBuffer buffer = new StringBuffer();
            if (childNode != null && isFirstTimeRender && childNode.hasProperty(propertyName)) {
                valueList = new ArrayList();
                for (Value value : values = childNode.getProperty(propertyName).getValues()) {
                    buffer.append(value.getString()).append(",");
                }
                uiSelectBox.setSelectedValues(StringUtils.split((String)buffer.toString(), (String)","));
            } else if (node != null && isFirstTimeRender && node.hasProperty(propertyName)) {
                valueList = new ArrayList();
                if (!(!node.getProperty(propertyName).getDefinition().isMultiple() || "true".equals(onchange) && this.isOnchange)) {
                    for (Value value : values = node.getProperty(propertyName).getValues()) {
                        buffer.append(value.getString()).append(",");
                    }
                } else if ("true".equals(onchange) && this.isOnchange) {
                    if (uiSelectBox.isMultiple()) {
                        for (Value value : values = uiSelectBox.getSelectedValues()) {
                            buffer.append((String)value).append(",");
                        }
                    } else {
                        values = (String)uiSelectBox.getValue();
                        buffer.append((String)values).append(",");
                    }
                } else {
                    for (Value value : values = node.getProperty(propertyName).getValues()) {
                        buffer.append(value.getString()).append(",");
                    }
                }
                uiSelectBox.setSelectedValues(StringUtils.split((String)buffer.toString(), (String)","));
            }
        } else if (childNode != null && isFirstTimeRender && childNode.hasProperty(propertyName)) {
            uiSelectBox.setValue(childNode.getProperty(propertyName).getValue().getString());
        } else if (node != null && node.hasProperty(propertyName)) {
            if (node.getProperty(propertyName).getDefinition().isMultiple()) {
                if (this.findComponentById(name) == null) {
                    uiSelectBox.setValue(node.getProperty(propertyName).getValues().toString());
                }
            } else if (formSelectBoxField.isOnchange() && this.isOnchange) {
                uiSelectBox.setValue((String)uiSelectBox.getValue());
            } else if (this.findComponentById(name) == null) {
                uiSelectBox.setValue(node.getProperty(propertyName).getValue().getString());
            }
        }
        uiSelectBox.setEditable(formSelectBoxField.isEditable());
        if (this.isNotEditNode && (child = this.getChildNode()) != null && child.hasProperty(propertyName)) {
            if (child.getProperty(propertyName).getDefinition().isMultiple()) {
                Value[] values = child.getProperty(propertyName).getValues();
                ArrayList<String> listValues = new ArrayList<String>();
                for (Value value : values) {
                    listValues.add(value.getString());
                }
                uiSelectBox.setSelectedValues(listValues.toArray(new String[listValues.size()]));
            } else {
                uiSelectBox.setValue(DialogFormUtil.getPropertyValueAsString(child, propertyName));
            }
        }
        if (formSelectBoxField.isOnchange()) {
            uiSelectBox.setOnChange("Onchange");
        }
        if (this.findComponentById(name) == null) {
            this.addUIFormInput((UIFormInput)uiSelectBox);
        }
        StringBuilder newValues = new StringBuilder();
        int count = 0;
        for (String v : ((UIFormSelectBox)this.findComponentById(name)).getSelectedValues()) {
            if (count++ > 0) {
                newValues.append(",");
            }
            newValues.append(v);
        }
        String newValue = newValues.toString();
        JcrInputProperty inputProperty = this.properties.get(name);
        if (inputProperty == null) {
            inputProperty = new JcrInputProperty();
            inputProperty.setJcrPath(jcrPath);
            this.setInputProperty(name, inputProperty);
        } else if (inputProperty.getValue() != null && (oldValue = inputProperty.getValue().toString()) != null && !oldValue.equals(newValue)) {
            Iterator<String> componentSelector = this.componentSelectors.keySet().iterator();
            Map<String, String> obj = null;
            while (componentSelector.hasNext()) {
                String componentName = componentSelector.next();
                obj = this.componentSelectors.get(componentName);
                Set<String> set = obj.keySet();
                for (String key : set) {
                    if (!name.equals(obj.get(key))) continue;
                    UIComponent uiInput = this.findComponentById(componentName);
                    ((UIFormStringInput)uiInput).reset();
                }
            }
        }
        inputProperty.setValue((Object)newValue);
        if (this.isUpdateSelect && newValue != null) {
            String[] values1 = newValue.split(",");
            uiSelectBox.setSelectedValues(values1);
        }
        this.renderField(name);
    }

    public void addSelectBoxField(String name, String[] arguments) throws Exception {
        this.addSelectBoxField(name, null, arguments);
    }

    public void addTextAreaField(String name, String label, String[] arguments) throws Exception {
        UIFormTextAreaField formTextAreaField = new UIFormTextAreaField(name, label, arguments);
        if (formTextAreaField.useSelector()) {
            this.componentSelectors.put(name, formTextAreaField.getSelectorInfo());
        }
        String jcrPath = formTextAreaField.getJcrPath();
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, inputProperty);
        String propertyName = this.getPropertyName(jcrPath);
        this.propertiesName.put(name, propertyName);
        this.fieldNames.put(propertyName, name);
        Node node = this.getNode();
        Node childNode = this.getChildNode();
        boolean isFirstTimeRender = false;
        if (formTextAreaField.isMultiValues()) {
            ArrayList<String> valueList;
            Object[] params;
            int p_end;
            int p_begin;
            String s_param;
            String[] validatorList;
            String validateType;
            UIFormMultiValueInputSet uiMulti;
            if (node == null && childNode == null) {
                uiMulti = (UIFormMultiValueInputSet)this.findComponentById(name);
                if (uiMulti == null) {
                    isFirstTimeRender = true;
                    uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
                    uiMulti.setId(name);
                    uiMulti.setName(name);
                    uiMulti.setType(UIFormTextAreaInput.class);
                    uiMulti.setEditable(formTextAreaField.isEditable());
                    if (formTextAreaField.validateType != null) {
                        validateType = formTextAreaField.validateType;
                        validatorList = null;
                        validatorList = validateType.indexOf(44) > -1 ? validateType.split(",") : new String[]{validateType};
                        for (String validator : validatorList) {
                            s_param = null;
                            p_begin = validator.indexOf(DialogFormUtil.VALIDATOR_PARAM_BEGIN);
                            p_end = validator.indexOf(DialogFormUtil.VALIDATOR_PARAM_END);
                            if (p_begin >= 0 && p_end > p_begin) {
                                s_param = validator.substring(p_begin, p_end);
                                params = s_param.split(DialogFormUtil.VALIDATOR_PARAM_SEPERATOR);
                                uiMulti.addValidator(DialogFormUtil.getValidator(validator.trim()), params);
                                continue;
                            }
                            uiMulti.addValidator(DialogFormUtil.getValidator(validator.trim()), new Object[0]);
                        }
                    }
                    valueList = new ArrayList();
                    List listChildren = uiMulti.getChildren();
                    if (listChildren.size() == 0) {
                        valueList.add(formTextAreaField.getDefaultValue());
                    } else {
                        for (UIComponent component : listChildren) {
                            UIFormTextAreaInput uiTextAreaInput = (UIFormTextAreaInput)component;
                            if (uiTextAreaInput.getValue() != null) {
                                valueList.add(((String)uiTextAreaInput.getValue()).trim());
                                continue;
                            }
                            valueList.add(formTextAreaField.getDefaultValue());
                        }
                    }
                    uiMulti.setValue(valueList);
                    this.addUIFormInput((UIFormInput)uiMulti);
                }
            } else {
                uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
                isFirstTimeRender = true;
                uiMulti.setId(name);
                uiMulti.setName(name);
                uiMulti.setType(UIFormTextAreaInput.class);
                uiMulti.setEditable(formTextAreaField.isEditable());
                if (formTextAreaField.validateType != null) {
                    validateType = formTextAreaField.validateType;
                    validatorList = null;
                    validatorList = validateType.indexOf(44) > -1 ? validateType.split(",") : new String[]{validateType};
                    for (String validator : validatorList) {
                        s_param = null;
                        p_begin = validator.indexOf(DialogFormUtil.VALIDATOR_PARAM_BEGIN);
                        p_end = validator.indexOf(DialogFormUtil.VALIDATOR_PARAM_END);
                        if (p_begin >= 0 && p_end > p_begin) {
                            s_param = validator.substring(p_begin, p_end);
                            params = s_param.split(DialogFormUtil.VALIDATOR_PARAM_SEPERATOR);
                            uiMulti.addValidator(DialogFormUtil.getValidator(validator.trim()), params);
                            continue;
                        }
                        uiMulti.addValidator(DialogFormUtil.getValidator(validator.trim()), new Object[0]);
                    }
                }
                this.addUIFormInput((UIFormInput)uiMulti);
            }
            valueList = new ArrayList<String>();
            boolean valueListIsSet = false;
            if (node != null && node.hasNode("jcr:content") && childNode == null) {
                Node jcrContentNode = node.getNode("jcr:content");
                if (jcrContentNode.hasProperty(propertyName)) {
                    Value[] values;
                    for (Value value : values = jcrContentNode.getProperty(propertyName).getValues()) {
                        valueList.add(value.getString());
                    }
                    uiMulti.setEditable(formTextAreaField.isEditable());
                    uiMulti.setValue(valueList);
                    valueListIsSet = true;
                }
            } else if (childNode != null && childNode.hasProperty(propertyName)) {
                Value[] values;
                for (Value value : values = childNode.getProperty(propertyName).getValues()) {
                    valueList.add(value.getString());
                }
                uiMulti.setEditable(formTextAreaField.isEditable());
                uiMulti.setValue(valueList);
                valueListIsSet = true;
            }
            if (!valueListIsSet && node != null && !this.isShowingComponent && !this.isRemovePreference && isFirstTimeRender) {
                String propertyPath = jcrPath.substring("/node/".length());
                if (node.hasProperty(propertyPath)) {
                    Value[] values = node.getProperty(propertyPath).getValues();
                    if (node.getProperty(propertyPath).getType() == 9) {
                        for (Value vl : values) {
                            if (vl == null) continue;
                            String strUUID = vl.getString();
                            try {
                                String strReferenceableNodePath = node.getSession().getNodeByUUID(strUUID).getPath();
                                if (strReferenceableNodePath.length() > 1) {
                                    strReferenceableNodePath = strReferenceableNodePath.substring(1);
                                }
                                valueList.add(strReferenceableNodePath);
                            }
                            catch (ItemNotFoundException infEx) {
                                valueList.add(formTextAreaField.getDefaultValue());
                            }
                            catch (RepositoryException repoEx) {
                                valueList.add(formTextAreaField.getDefaultValue());
                            }
                        }
                    } else {
                        for (Value vl : values) {
                            if (vl == null) continue;
                            valueList.add(vl.getString());
                        }
                    }
                }
                uiMulti.setValue(valueList);
            }
            if (this.isResetMultiField) {
                uiMulti.setValue(new ArrayList());
            }
            uiMulti.setEditable(formTextAreaField.isEditable());
            this.renderField(name);
            return;
        }
        UIFormTextAreaInput uiTextArea = (UIFormTextAreaInput)this.findComponentById(name);
        if (uiTextArea == null) {
            isFirstTimeRender = true;
            uiTextArea = (UIFormTextAreaInput)formTextAreaField.createUIFormInput();
            if (formTextAreaField.getRowSize() != null) {
                uiTextArea.setRows(Integer.parseInt(formTextAreaField.getRowSize()));
            } else {
                uiTextArea.setRows(10);
            }
            if (formTextAreaField.getColSize() != null) {
                uiTextArea.setColumns(Integer.parseInt(formTextAreaField.getColSize()));
            } else {
                uiTextArea.setColumns(30);
            }
            this.addUIFormInput((UIFormInput)uiTextArea);
        }
        if (node != null && !this.isShowingComponent && !this.isRemovePreference && isFirstTimeRender) {
            Node jcrContentNode;
            String value = null;
            if (node.hasProperty(propertyName)) {
                value = node.getProperty(propertyName).getValue().getString();
            } else if (node.isNodeType("nt:file") && (jcrContentNode = node.getNode("jcr:content")).hasProperty(propertyName)) {
                if (jcrContentNode.getProperty(propertyName).getDefinition().isMultiple()) {
                    Value[] values;
                    for (Value v : values = jcrContentNode.getProperty(propertyName).getValues()) {
                        value = value + v.getString();
                    }
                } else {
                    value = jcrContentNode.getProperty(propertyName).getValue().getString();
                }
            }
            uiTextArea.setValue((Object)value);
        }
        if (this.isNotEditNode && !this.isShowingComponent && !this.isRemovePreference && isFirstTimeRender) {
            if (node != null && node.hasNode("jcr:content") && childNode != null) {
                Node jcrContentNode = node.getNode("jcr:content");
                uiTextArea.setValue((Object)jcrContentNode.getProperty("jcr:data").getValue().getString());
            } else if (childNode != null) {
                uiTextArea.setValue((Object)propertyName);
            } else if (childNode == null && jcrPath.equals("/node") && node != null) {
                uiTextArea.setValue((Object)node.getName());
            } else {
                uiTextArea.setValue(null);
            }
        }
        if (uiTextArea.getValue() == null) {
            if (formTextAreaField.getDefaultValue() != null) {
                uiTextArea.setValue((Object)formTextAreaField.getDefaultValue());
            } else {
                uiTextArea.setValue((Object)"");
            }
        }
        uiTextArea.setEditable(formTextAreaField.isEditable());
        this.renderField(name);
    }

    public void addTextAreaField(String name, String[] arguments) throws Exception {
        this.addTextAreaField(name, null, arguments);
    }

    public String getPathTaxonomy() throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig().getSystemWorkspace();
        String userName = Util.getPortalRequestContext().getRemoteUser();
        Session session = userName != null ? WCMCoreUtils.getUserSessionProvider().getSession(workspace, this.getRepository()) : WCMCoreUtils.createAnonimProvider().getSession(workspace, this.getRepository());
        return ((Node)session.getItem(nodeHierarchyCreator.getJcrPath(TAXONOMIES_ALIAS))).getPath();
    }

    public void addTextField(String name, String label, String[] arguments) throws Exception {
        UIFormTextField formTextField = new UIFormTextField(name, label, arguments);
        String jcrPath = formTextField.getJcrPath();
        String mixintype = formTextField.getMixinTypes();
        String nodetype = formTextField.getNodeType();
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, inputProperty);
        String propertyName = this.getPropertyName(jcrPath);
        if (mixintype != null) {
            inputProperty.setMixintype(mixintype);
        }
        if (jcrPath.equals("/node") && nodetype != null) {
            inputProperty.setNodetype(nodetype);
        }
        this.properties.put(name, inputProperty);
        this.propertiesName.put(name, propertyName);
        this.fieldNames.put(propertyName, name);
        Node node = this.getNode();
        Node childNode = this.getChildNode();
        if (!this.isReference) {
            this.isReference = formTextField.isReference();
        }
        boolean isFirstTimeRender = false;
        if (formTextField.isMultiValues()) {
            ArrayList<String> valueList;
            Object[] params;
            int p_end;
            int p_begin;
            String s_param;
            String[] validatorList;
            String validateType;
            UIFormMultiValueInputSet uiMulti;
            if (node == null && childNode == null) {
                uiMulti = (UIFormMultiValueInputSet)this.findComponentById(name);
                if (uiMulti == null) {
                    isFirstTimeRender = true;
                    uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
                    uiMulti.setId(name);
                    uiMulti.setName(name);
                    uiMulti.setType(UIFormStringInput.class);
                    uiMulti.setEditable(formTextField.isEditable());
                    if (formTextField.validateType != null) {
                        validateType = formTextField.validateType;
                        validatorList = null;
                        validatorList = validateType.indexOf(44) > -1 ? validateType.split(",") : new String[]{validateType};
                        for (String validator : validatorList) {
                            s_param = null;
                            p_begin = validator.indexOf(DialogFormUtil.VALIDATOR_PARAM_BEGIN);
                            p_end = validator.indexOf(DialogFormUtil.VALIDATOR_PARAM_END);
                            if (p_begin >= 0 && p_end > p_begin) {
                                s_param = validator.substring(p_begin, p_end);
                                params = s_param.split(DialogFormUtil.VALIDATOR_PARAM_SEPERATOR);
                                uiMulti.addValidator(DialogFormUtil.getValidator(validator.trim()), params);
                                continue;
                            }
                            uiMulti.addValidator(DialogFormUtil.getValidator(validator.trim()), new Object[0]);
                        }
                    }
                    valueList = new ArrayList();
                    List listChildren = uiMulti.getChildren();
                    if (listChildren.size() == 0) {
                        valueList.add(formTextField.getDefaultValue());
                    } else {
                        for (UIComponent component : listChildren) {
                            UIFormStringInput uiStringInput = (UIFormStringInput)component;
                            if (uiStringInput.getValue() != null) {
                                valueList.add(((String)uiStringInput.getValue()).trim());
                                continue;
                            }
                            valueList.add(formTextField.getDefaultValue());
                        }
                    }
                    uiMulti.setValue(valueList);
                    this.addUIFormInput((UIFormInput)uiMulti);
                }
            } else {
                uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
                isFirstTimeRender = true;
                uiMulti.setId(name);
                uiMulti.setName(name);
                uiMulti.setType(UIFormStringInput.class);
                uiMulti.setEditable(formTextField.isEditable());
                if (formTextField.validateType != null) {
                    validateType = formTextField.validateType;
                    validatorList = null;
                    validatorList = validateType.indexOf(44) > -1 ? validateType.split(",") : new String[]{validateType};
                    for (String validator : validatorList) {
                        s_param = null;
                        p_begin = validator.indexOf(DialogFormUtil.VALIDATOR_PARAM_BEGIN);
                        p_end = validator.indexOf(DialogFormUtil.VALIDATOR_PARAM_END);
                        if (p_begin >= 0 && p_end > p_begin) {
                            s_param = validator.substring(p_begin, p_end);
                            params = s_param.split(DialogFormUtil.VALIDATOR_PARAM_SEPERATOR);
                            uiMulti.addValidator(DialogFormUtil.getValidator(validator.trim()), params);
                            continue;
                        }
                        uiMulti.addValidator(DialogFormUtil.getValidator(validator.trim()), new Object[0]);
                    }
                }
                if (this.getChildById(name) == null) {
                    this.addUIFormInput((UIFormInput)uiMulti);
                }
            }
            valueList = new ArrayList<String>();
            boolean valueListIsSet = false;
            if (node != null && node.hasNode("jcr:content") && childNode == null) {
                Node jcrContentNode = node.getNode("jcr:content");
                if (jcrContentNode.hasProperty(propertyName)) {
                    Value[] values;
                    for (Value value : values = jcrContentNode.getProperty(propertyName).getValues()) {
                        valueList.add(value.getString());
                    }
                    uiMulti.setEditable(formTextField.isEditable());
                    uiMulti.setValue(valueList);
                    valueListIsSet = true;
                }
            } else if (childNode != null && childNode.hasProperty(propertyName)) {
                Value[] values;
                for (Value value : values = childNode.getProperty(propertyName).getValues()) {
                    valueList.add(value.getString());
                }
                uiMulti.setEditable(formTextField.isEditable());
                uiMulti.setValue(valueList);
                valueListIsSet = true;
            }
            if (!valueListIsSet && node != null && !this.isShowingComponent && !this.isRemovePreference && isFirstTimeRender) {
                String propertyPath = jcrPath.substring("/node/".length());
                if (node.hasProperty(propertyPath)) {
                    Value[] values = node.getProperty(propertyPath).getValues();
                    if (node.getProperty(propertyPath).getType() == 9) {
                        for (Value vl : values) {
                            if (vl == null) continue;
                            String strUUID = vl.getString();
                            try {
                                String strReferenceableNodePath = node.getSession().getNodeByUUID(strUUID).getPath();
                                if (strReferenceableNodePath.length() > 1) {
                                    strReferenceableNodePath = strReferenceableNodePath.substring(1);
                                }
                                valueList.add(strReferenceableNodePath);
                            }
                            catch (ItemNotFoundException infEx) {
                                valueList.add(formTextField.getDefaultValue());
                            }
                            catch (RepositoryException repoEx) {
                                valueList.add(formTextField.getDefaultValue());
                            }
                        }
                    } else {
                        for (Value vl : values) {
                            if (vl == null) continue;
                            valueList.add(vl.getString());
                        }
                    }
                }
                uiMulti.setValue(valueList);
            }
            if (this.isResetMultiField) {
                uiMulti.setValue(new ArrayList());
            }
            uiMulti.setEditable(formTextField.isEditable());
            this.renderField(name);
            return;
        }
        UIFormStringInput uiInput = (UIFormStringInput)this.findComponentById(name);
        if (uiInput == null) {
            isFirstTimeRender = true;
            uiInput = (UIFormStringInput)formTextField.createUIFormInput();
            this.addUIFormInput((UIFormInput)uiInput);
        }
        uiInput.setEditable(formTextField.isEditable());
        if (uiInput.getValue() == null) {
            uiInput.setValue((Object)formTextField.getDefaultValue());
        } else {
            uiInput.setEditable(true);
        }
        if (!(node == null || this.isShowingComponent || this.isRemovePreference || !jcrPath.equals("/node") || formTextField.isEditable() && !formTextField.isEditableIfNull())) {
            uiInput.setEditable(false);
        }
        if (node != null && !this.isShowingComponent && !this.isRemovePreference && isFirstTimeRender) {
            if (jcrPath.equals("/node") && (!formTextField.isEditable() || formTextField.isEditableIfNull())) {
                String value = (String)uiInput.getValue();
                if (this.i18nNodePath != null) {
                    uiInput.setValue((Object)this.i18nNodePath.substring(this.i18nNodePath.lastIndexOf("/") + 1));
                } else {
                    String nameValue = node.getPath().substring(node.getPath().lastIndexOf("/") + 1);
                    uiInput.setValue((Object)Text.unescapeIllegalJcrChars((String)nameValue));
                }
            } else if (node.hasProperty(propertyName)) {
                uiInput.setValue((Object)node.getProperty(propertyName).getValue().getString());
            }
        }
        if (this.isNotEditNode && !this.isShowingComponent && !this.isRemovePreference) {
            if (childNode != null && childNode.hasProperty(propertyName)) {
                if (childNode.hasProperty(propertyName)) {
                    uiInput.setValue((Object)childNode.getProperty(propertyName).getValue().getString());
                }
            } else if (childNode == null && jcrPath.equals("/node") && node != null) {
                uiInput.setValue((Object)node.getName());
            } else if (this.i18nNodePath != null && jcrPath.equals("/node")) {
                uiInput.setValue((Object)this.i18nNodePath.substring(this.i18nNodePath.lastIndexOf("/") + 1));
            } else {
                uiInput.setValue((Object)formTextField.getDefaultValue());
            }
        }
        this.renderField(name);
    }

    public void addTextField(String name, String[] arguments) throws Exception {
        this.addTextField(name, null, arguments);
    }

    public void addUploadField(String name, String label, String[] arguments) throws Exception {
        UIFormUploadField formUploadField = new UIFormUploadField(name, label, arguments);
        String mimeTypes = formUploadField.getMimeTypes();
        String jcrPath = formUploadField.getJcrPath();
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, inputProperty);
        this.setMultiPart(true);
        if (formUploadField.isMultiValues()) {
            UIFormMultiValueInputSet multiValueField = this.renderMultiValuesInput(UIFormUploadInput.class, name, label);
            if (mimeTypes != null) {
                multiValueField.addValidator(UploadFileMimeTypesValidator.class, new Object[]{mimeTypes});
            }
            return;
        }
        UIFormUploadInput uiInputUpload = (UIFormUploadInput)this.findComponentById(name);
        if (uiInputUpload == null) {
            uiInputUpload = (UIFormUploadInput)formUploadField.createUIFormInput();
            if (mimeTypes != null) {
                uiInputUpload.addValidator(UploadFileMimeTypesValidator.class, new Object[]{mimeTypes});
            }
            this.addUIFormInput((UIFormInput)uiInputUpload);
        }
        String propertyName = this.getPropertyName(jcrPath);
        this.propertiesName.put(name, propertyName);
        this.fieldNames.put(propertyName, name);
        this.renderField(name);
    }

    public void addUploadField(String name, String[] arguments) throws Exception {
        this.addUploadField(name, null, arguments);
    }

    public void addWYSIWYGField(String name, String label, String[] arguments) throws Exception {
        UIFormWYSIWYGField formWYSIWYGField = new UIFormWYSIWYGField(name, label, arguments);
        String jcrPath = formWYSIWYGField.getJcrPath();
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, inputProperty);
        String propertyName = this.getPropertyName(jcrPath);
        this.propertiesName.put(name, propertyName);
        this.fieldNames.put(propertyName, name);
        List<UIFormInputBase<String>> wysiwygList = this.getUIFormInputList(name, formWYSIWYGField, false);
        if (formWYSIWYGField.isMultiValues()) {
            UIFormMultiValueInputSet uiMulti = (UIFormMultiValueInputSet)this.findComponentById(name);
            if (uiMulti == null) {
                uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, WYSIWYG_MULTI_ID, null);
                this.uiMultiValueParam.put(name, arguments);
                uiMulti.setId(name);
                uiMulti.setName(name);
                uiMulti.setType(UIFormWYSIWYGInput.class);
                for (int i = 0; i < wysiwygList.size(); ++i) {
                    uiMulti.addChild((UIComponent)wysiwygList.get(i));
                    wysiwygList.get(i).setId(name + i);
                    wysiwygList.get(i).setName(name + i);
                }
                this.addUIFormInput((UIFormInput)uiMulti);
                if (label != null) {
                    uiMulti.setLabel(label);
                }
            }
        } else if (wysiwygList.size() > 0) {
            this.addUIFormInput((UIFormInput)wysiwygList.get(0));
        }
        this.renderField(name);
    }

    private List<UIFormInputBase<String>> getUIFormInputList(String name, DialogFormField formField, boolean isCreateNew) throws Exception {
        String jcrPath = formField.getJcrPath();
        String propertyName = this.getPropertyName(jcrPath);
        ArrayList<UIFormInputBase<String>> ret = new ArrayList<UIFormInputBase<String>>();
        Object formInput = formField.isMultiValues() ? null : (UIFormInputBase)this.findComponentById(name);
        boolean isFirstTimeRender = false;
        if (formInput == null) {
            isFirstTimeRender = true;
            formInput = formField.createUIFormInput();
        }
        FCKEditorConfig config = new FCKEditorConfig();
        FCKEditorContext editorContext = new FCKEditorContext();
        if (this.repositoryName != null) {
            config.put((Object)"repositoryName", (Object)this.repositoryName);
            editorContext.setRepository(this.repositoryName);
        }
        if (this.workspaceName != null) {
            config.put((Object)"workspaceName", (Object)this.workspaceName);
            editorContext.setWorkspace(this.workspaceName);
        }
        if (this.nodePath != null) {
            config.put((Object)"jcrPath", (Object)this.nodePath);
            editorContext.setCurrentNodePath(this.nodePath);
        } else {
            config.put((Object)"jcrPath", (Object)this.storedPath);
            editorContext.setCurrentNodePath(this.storedPath);
        }
        FCKConfigService fckConfigService = (FCKConfigService)this.getApplicationComponent(FCKConfigService.class);
        editorContext.setPortalName(Util.getUIPortal().getName());
        editorContext.setSkinName(Util.getUIPortalApplication().getSkin());
        fckConfigService.processFCKEditorConfig(config, editorContext);
        if (formInput instanceof UIFormWYSIWYGInput) {
            ((UIFormWYSIWYGInput)formInput).setFCKConfig(config);
        }
        if (formInput.getValue() == null) {
            formInput.setValue((Object)formField.getDefaultValue());
        }
        Node node = this.getNode();
        if (isCreateNew) {
            ret.add((UIFormInputBase<String>)formInput);
            return ret;
        }
        if (!formField.isMultiValues() && isFirstTimeRender) {
            if (!this.isShowingComponent && !this.isRemovePreference) {
                if (node != null && (node.isNodeType("nt:file") || this.isNTFile)) {
                    Node jcrContentNode = node.getNode("jcr:content");
                    formInput.setValue((Object)jcrContentNode.getProperty("jcr:data").getValue().getString());
                } else if (node != null && node.hasProperty(propertyName)) {
                    formInput.setValue((Object)node.getProperty(propertyName).getValue().getString());
                }
            }
            if (this.isNotEditNode && !this.isShowingComponent && !this.isRemovePreference && isFirstTimeRender) {
                Node childNode = this.getChildNode();
                if (node != null && node.hasNode("jcr:content") && childNode != null) {
                    Node jcrContentNode = node.getNode("jcr:content");
                    formInput.setValue((Object)jcrContentNode.getProperty("jcr:data").getValue().getString());
                } else if (childNode != null) {
                    formInput.setValue((Object)propertyName);
                } else if (childNode == null && jcrPath.equals("/node") && node != null) {
                    formInput.setValue((Object)node.getName());
                } else {
                    formInput.setValue(null);
                }
            }
            ret.add((UIFormInputBase<String>)formInput);
            return ret;
        }
        Value[] values = null;
        if (!this.isShowingComponent && !this.isRemovePreference && isFirstTimeRender && node != null && node.hasProperty(propertyName)) {
            values = node.getProperty(propertyName).getValues();
        }
        if (this.isNotEditNode && !this.isShowingComponent && !this.isRemovePreference && isFirstTimeRender) {
            Node childNode = this.getChildNode();
            values = childNode != null ? new Value[]{node.getSession().getValueFactory().createValue(propertyName)} : (childNode == null && jcrPath.equals("/node") && node != null ? new Value[]{node.getSession().getValueFactory().createValue(node.getName())} : new Value[]{node.getSession().getValueFactory().createValue("")});
        }
        if (values != null && isFirstTimeRender) {
            for (Value v : values) {
                Object uiFormInput = formField.createUIFormInput();
                if (uiFormInput instanceof UIFormWYSIWYGInput) {
                    ((UIFormWYSIWYGInput)uiFormInput).setFCKConfig((FCKEditorConfig)config.clone());
                }
                if (v == null || v.getString() == null) {
                    uiFormInput.setValue((Object)formField.getDefaultValue());
                } else {
                    uiFormInput.setValue((Object)v.getString());
                }
                ret.add((UIFormInputBase<String>)uiFormInput);
            }
        } else {
            ret.add((UIFormInputBase<String>)formInput);
        }
        return ret;
    }

    public void addWYSIWYGField(String name, String[] arguments) throws Exception {
        this.addWYSIWYGField(name, null, arguments);
    }

    public void addRichtextField(String name, String label, String[] arguments) throws Exception {
        UIFormRichtextField richtextField = new UIFormRichtextField(name, label, arguments);
        String jcrPath = richtextField.getJcrPath();
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, inputProperty);
        String propertyName = this.getPropertyName(jcrPath);
        this.propertiesName.put(name, propertyName);
        this.fieldNames.put(propertyName, name);
        List<UIFormInputBase<String>> richtextList = this.getUIFormInputList(name, richtextField, false);
        if (richtextField.isMultiValues()) {
            UIFormMultiValueInputSet uiMulti = (UIFormMultiValueInputSet)this.findComponentById(name);
            if (uiMulti == null) {
                uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, WYSIWYG_MULTI_ID, null);
                this.uiMultiValueParam.put(name, arguments);
                uiMulti.setId(name);
                uiMulti.setName(name);
                uiMulti.setType(UIFormRichtextInput.class);
                for (int i = 0; i < richtextList.size(); ++i) {
                    uiMulti.addChild((UIComponent)richtextList.get(i));
                    richtextList.get(i).setId(name + i);
                    richtextList.get(i).setName(name + i);
                }
                this.addUIFormInput((UIFormInput)uiMulti);
                if (label != null) {
                    uiMulti.setLabel(label);
                }
            }
        } else if (this.getChildById(name) == null && richtextList.size() > 0) {
            this.addUIFormInput((UIFormInput)richtextList.get(0));
        }
        this.renderField(name);
    }

    public void addRichtextField(String name, String[] arguments) throws Exception {
        this.addRichtextField(name, null, arguments);
    }

    public Node getChildNode() throws Exception {
        if (this.childPath == null) {
            return null;
        }
        return (Node)this.getSession().getItem(this.childPath);
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, JcrInputProperty> getInputProperties() {
        return this.properties;
    }

    public JcrInputProperty getInputProperty(String name) {
        return this.properties.get(name);
    }

    public JCRResourceResolver getJCRResourceResolver() {
        return this.resourceResolver;
    }

    public Node getNode() throws Exception {
        if (this.nodePath == null) {
            return null;
        }
        try {
            return (Node)this.getSession().getItem(this.nodePath);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getPropertyName(String jcrPath) {
        return jcrPath.substring(jcrPath.lastIndexOf("/") + 1);
    }

    public String getSelectBoxFieldValue(String name) {
        UIFormSelectBox uiSelectBox = (UIFormSelectBox)this.findComponentById(name);
        if (uiSelectBox != null) {
            return (String)uiSelectBox.getValue();
        }
        return null;
    }

    public List<String> getSelectedBoxFieldValue(String name) {
        UIFormSelectBox uiSelectBox = (UIFormSelectBox)this.findComponentById(name);
        if (uiSelectBox != null) {
            return Arrays.asList(uiSelectBox.getSelectedValues());
        }
        return null;
    }

    public Session getSession() throws Exception {
        return WCMCoreUtils.getUserSessionProvider().getSession(this.workspaceName, this.getRepository());
    }

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            return templateService.getTemplatePathByUser(true, this.contentType, userName);
        }
        catch (Exception e) {
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{this.contentType};
            uiApp.addMessage(new ApplicationMessage("UIDialogForm.msg.not-support-contenttype", arg, 0));
            return null;
        }
    }

    public boolean isResetForm() {
        return this.isResetForm;
    }

    public void onchange(Event<?> event) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processAction(WebuiRequestContext context) throws Exception {
        String action = context.getRequestParameter("formOp");
        boolean clearInterceptor = false;
        if (SAVE_ACTION.equalsIgnoreCase(action)) {
            try {
                if (this.executePreSaveEventInterceptor()) {
                    super.processAction(context);
                    String nodePath_ = (String)context.getAttribute("nodePath");
                    if (nodePath_ == null) return;
                    this.executePostSaveEventInterceptor(nodePath_);
                    clearInterceptor = true;
                    return;
                }
                context.setProcessRender(true);
                super.processAction(context);
                return;
            }
            finally {
                if (clearInterceptor) {
                    this.prevScriptInterceptor.clear();
                    this.postScriptInterceptor.clear();
                }
            }
        } else {
            super.processAction(context);
        }
    }

    public void removeComponent(String name) {
        if (!this.properties.isEmpty() && this.properties.containsKey(name)) {
            this.properties.remove(name);
            String jcrPath = this.propertiesName.get(name);
            this.propertiesName.remove(name);
            this.fieldNames.remove(jcrPath);
            this.removeChildById(name);
        }
    }

    private String getResourceBundle(WebuiRequestContext context, String key) {
        try {
            ResourceBundle rs = context.getApplicationResourceBundle();
            return rs.getString(key);
        }
        catch (MissingResourceException e) {
            if (LOG.isDebugEnabled()) {
                LOG.warn((Object)("Missing resource " + key));
            }
            key = key.contains(".") ? key.substring(key.lastIndexOf(".") + 1) : key;
            return key;
        }
    }

    public void renderField(String name) throws Exception {
        UIComponent uiInput = this.findComponentById(name);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Writer w = context.getWriter();
        if (this.componentSelectors.get(name) != null && name.equals(this.componentSelectors.get(name).get("returnField"))) {
            w.write("<table style=\"width: auto;\">");
            w.write("<tr>");
            w.write("<td>");
            uiInput.processRender(context);
            w.write("</td>");
        } else {
            uiInput.processRender(context);
        }
        if (this.componentSelectors.get(name) != null) {
            Map<String, String> fieldPropertiesMap = this.componentSelectors.get(name);
            String fieldName = fieldPropertiesMap.get("returnField");
            String iconClass = "Add16x16Icon";
            if (fieldPropertiesMap.get("selectorIcon") != null) {
                iconClass = fieldPropertiesMap.get("selectorIcon");
            }
            ResourceBundle rs = context.getApplicationResourceBundle();
            String showComponent = this.getResourceBundle(context, this.getId().concat(".title.ShowComponent"));
            String removeReference = this.getResourceBundle(context, this.getId().concat(".title.removeReference"));
            if (name.equals(fieldName)) {
                w.write("<td class=\"MultiValueContainerShow\">");
                w.write("<a style=\"cursor:pointer;\" title=\"" + showComponent + "\"" + "onclick=\"javascript:eXo.webui.UIForm.submitEvent('" + "" + this.getId() + "','ShowComponent','&objectId=" + fieldName + "' )\"><img class='ActionIcon " + iconClass + "' src=\"/eXoResources/skin/DefaultSkin/background/Blank.gif\" /></a>");
                if (!UIFormMultiValueInputSet.class.isInstance(uiInput)) {
                    w.write("<a style=\"cursor:pointer;\" title=\"" + removeReference + "\"" + "onclick=\"javascript:eXo.webui.UIForm.submitEvent('" + "" + this.getId() + "','RemoveReference','&objectId=" + fieldName + "' )\"><img class='ActionIcon Remove16x16Icon' src=\"/eXoResources/skin/DefaultSkin/background/Blank.gif\" />" + "</a>");
                }
                w.write("</td>");
                w.write("</tr>");
                w.write("</table>");
            }
        }
    }

    public String getImage(Node node, String nodeTypeName) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode(nodeTypeName);
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    @Deprecated
    public boolean dataRemoved() {
        return this.dataRemoved_;
    }

    @Deprecated
    public void setDataRemoved(boolean dataRemoved) {
        this.dataRemoved_ = dataRemoved;
    }

    public void resetProperties() {
        this.properties.clear();
    }

    public void resetInterceptors() {
        this.prevScriptInterceptor.clear();
        this.postScriptInterceptor.clear();
    }

    public void setChildPath(String childPath) {
        this.childPath = childPath;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void setInputProperty(String name, JcrInputProperty value) {
        this.properties.put(name, value);
    }

    public void setIsNotEditNode(boolean isNotEditNode) {
        this.isNotEditNode = isNotEditNode;
    }

    public void setIsNTFile(boolean isNTFile) {
        this.isNTFile = isNTFile;
    }

    public void setIsOnchange(boolean isOnchange) {
        this.isOnchange = isOnchange;
    }

    public void setIsResetForm(boolean isResetForm) {
        this.isResetForm = isResetForm;
    }

    public void setIsResetMultiField(boolean isResetMultiField) {
        this.isResetMultiField = isResetMultiField;
    }

    public void setIsUpdateSelect(boolean isUpdateSelect) {
        this.isUpdateSelect = isUpdateSelect;
    }

    public void setJCRResourceResolver(JCRResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public void setNodePath(String nodePath) {
        this.nodePath = nodePath;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void setStoredPath(String storedPath) {
        this.storedPath = storedPath;
    }

    public String getStoredPath() {
        return this.storedPath;
    }

    public void setWorkspace(String workspace) {
        this.workspaceName = workspace;
    }

    public String getLastModifiedDate() throws Exception {
        return this.getLastModifiedDate(this.getNode());
    }

    public String getLastModifiedDate(Node node) throws Exception {
        String d = "";
        try {
            if (node.hasProperty("exo:dateModified")) {
                Locale locale = Util.getPortalRequestContext().getLocale();
                DateFormat dateFormater = SimpleDateFormat.getDateTimeInstance(2, 2, locale);
                Calendar calendar = node.getProperty("exo:dateModified").getValue().getDate();
                d = dateFormater.format(calendar.getTime());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    private void executePostSaveEventInterceptor(String nodePath_) throws Exception {
        if (this.postScriptInterceptor.size() > 0) {
            String path = nodePath_ + "&workspaceName=" + this.workspaceName + "&repository=" + this.repositoryName;
            for (String interceptor : this.postScriptInterceptor) {
                this.executeScript(interceptor, path, null, true);
            }
        }
    }

    private boolean executePreSaveEventInterceptor() throws Exception {
        if (!this.prevScriptInterceptor.isEmpty()) {
            Map<String, JcrInputProperty> maps = DialogFormUtil.prepareMap(this.getChildren(), this.getInputProperties());
            for (String interceptor : this.prevScriptInterceptor) {
                if (this.executeScript(interceptor, maps, null, false)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean executeScript(String script, Object o, String[] params, boolean printException) throws Exception {
        ScriptService scriptService = (ScriptService)this.getApplicationComponent(ScriptService.class);
        try {
            CmsScript dialogScript = scriptService.getScript(script);
            if (params != null) {
                dialogScript.setParams(params);
            }
            dialogScript.execute(o);
            return true;
        }
        catch (Exception e) {
            if (printException) {
                LOG.warn((Object)"An unexpected error occurs", (Throwable)e);
            } else {
                UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
                if (e instanceof DialogFormException) {
                    for (ApplicationMessage message : ((DialogFormException)e).getMessages()) {
                        uiApp.addMessage(message);
                    }
                } else {
                    JCRExceptionManager.process(uiApp, e);
                }
            }
            return false;
        }
    }

    private String getNodePathByUUID(String uuid) throws Exception {
        String[] workspaces = this.getRepository().getWorkspaceNames();
        Node node = null;
        for (String ws : workspaces) {
            try {
                node = WCMCoreUtils.getSystemSessionProvider().getSession(ws, this.getRepository()).getNodeByUUID(uuid);
                return ws + ":" + node.getPath();
            }
            catch (ItemNotFoundException e) {
            }
        }
        LOG.error((Object)("No node with uuid ='" + uuid + "' can be found"));
        return null;
    }

    private ManageableRepository getRepository() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return repositoryService.getCurrentRepository();
    }

    private UIFormMultiValueInputSet renderMultiValuesInput(Class type, String name, String label) throws Exception {
        UIFormMultiValueInputSet ret = this.addMultiValuesInput(type, name, label);
        this.renderField(name);
        return ret;
    }

    private UIFormMultiValueInputSet addMultiValuesInput(Class type, String name, String label) throws Exception {
        UIFormMultiValueInputSet uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
        uiMulti.setId(name);
        uiMulti.setName(name);
        uiMulti.setType(type);
        this.addUIFormInput((UIFormInput)uiMulti);
        if (label != null) {
            uiMulti.setLabel(label);
        }
        return uiMulti;
    }

    public boolean isOnchange() {
        return this.isOnchange;
    }

    public void processRenderAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Writer writer = context.getWriter();
        writer.append("<div class=\"UIAction\">");
        String[] listAction = this.getActions();
        ResourceBundle res = context.getApplicationResourceBundle();
        for (String action : listAction) {
            String actionLabel;
            try {
                actionLabel = res.getString(this.getName() + ".action." + action);
            }
            catch (MissingResourceException e) {
                actionLabel = action;
            }
            String link = this.event(action);
            writer.append("<a class=\"ActionButton LightBlueStyle\" onclick =\"").append(link).append("\"  href=\"javascript:void(0);\">").append(actionLabel).append("</a>");
        }
        writer.append("</div>");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIFormMultiValueInputSet> {
        public void execute(Event<UIFormMultiValueInputSet> event) throws Exception {
            List children;
            UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)event.getSource();
            String id = event.getRequestContext().getRequestParameter("objectId");
            if (uiSet.getId().equals(id) && (children = uiSet.getChildren()).size() > 0) {
                UIFormInputBase uiInput = (UIFormInputBase)children.get(children.size() - 1);
                String index = uiInput.getId();
                int maxIndex = Integer.parseInt(index.replaceAll(id, ""));
                UIDialogForm uiDialogForm = (UIDialogForm)uiSet.getAncestorOfType(UIDialogForm.class);
                String[] arguments = uiDialogForm.uiMultiValueParam.get(uiSet.getName());
                UIFormInputBase newUIInput = null;
                newUIInput = uiInput instanceof UIFormWYSIWYGInput ? (UIFormInputBase)uiDialogForm.getUIFormInputList(uiSet.getName(), new UIFormWYSIWYGField(uiSet.getName(), null, arguments), true).get(0) : (UIFormInputBase)uiDialogForm.getUIFormInputList(uiSet.getName(), new UIFormRichtextField(uiSet.getName(), null, arguments), true).get(0);
                uiSet.addChild((UIComponent)newUIInput);
                newUIInput.setId(uiSet.getName() + (maxIndex + 1));
                newUIInput.setName(uiSet.getName() + (maxIndex + 1));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OnchangeActionListener
    extends EventListener<UIDialogForm> {
        public void execute(Event<UIDialogForm> event) throws Exception {
            ((UIDialogForm)((Object)event.getSource())).isOnchange = true;
            ((UIDialogForm)((Object)event.getSource())).onchange(event);
        }
    }
}

