/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.InvalidEntityReferenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReferenceEntityReferenceResolver
implements EntityReferenceResolver<EntityReference> {
    private Map<EntityType, List<EntityType>> nextAllowedEntityTypes = new HashMap<EntityType, List<EntityType>>(){
        {
            this.put(EntityType.ATTACHMENT, Arrays.asList(EntityType.DOCUMENT));
            this.put(EntityType.DOCUMENT, Arrays.asList(EntityType.SPACE));
            this.put(EntityType.SPACE, Arrays.asList(EntityType.WIKI, EntityType.SPACE));
            this.put(EntityType.WIKI, Collections.emptyList());
            this.put(EntityType.OBJECT, Arrays.asList(EntityType.DOCUMENT));
            this.put(EntityType.OBJECT_PROPERTY, Arrays.asList(EntityType.OBJECT));
        }
    };

    protected abstract String getDefaultValue(EntityType var1, Object ... var2);

    @Override
    public EntityReference resolve(EntityReference referenceToResolve, EntityType type, Object ... parameters) {
        EntityReference normalizedReference = referenceToResolve == null ? new EntityReference(this.resolveDefaultValue(type, parameters), type) : (type.ordinal() > referenceToResolve.getType().ordinal() ? new EntityReference(this.resolveDefaultValue(type, parameters), type, referenceToResolve.clone()) : referenceToResolve.clone());
        for (EntityReference reference = normalizedReference; reference != null; reference = reference.getParent()) {
            EntityReference newReference;
            List<EntityType> types = this.nextAllowedEntityTypes.get((Object)reference.getType());
            if (reference.getParent() != null && !types.isEmpty() && !types.contains((Object)reference.getParent().getType())) {
                newReference = new EntityReference(this.resolveDefaultValue(types.get(0), parameters), types.get(0), reference.getParent());
                reference.setParent(newReference);
                continue;
            }
            if (reference.getParent() == null && !types.isEmpty()) {
                newReference = new EntityReference(this.resolveDefaultValue(types.get(0), parameters), types.get(0));
                reference.setParent(newReference);
                continue;
            }
            if (reference.getParent() == null || !types.isEmpty()) continue;
            throw new InvalidEntityReferenceException("Invalid reference [" + referenceToResolve + "]");
        }
        if (referenceToResolve != null && type.ordinal() < referenceToResolve.getType().ordinal()) {
            normalizedReference = normalizedReference.extractReference(type);
        }
        return normalizedReference;
    }

    private String resolveDefaultValue(EntityType type, Object ... parameters) {
        EntityReference referenceParameter;
        EntityReference extractedReference;
        String resolvedDefaultValue = null;
        if (parameters.length > 0 && parameters[0] instanceof EntityReference && (extractedReference = (referenceParameter = (EntityReference)parameters[0]).extractReference(type)) != null) {
            resolvedDefaultValue = extractedReference.getName();
        }
        if (resolvedDefaultValue == null) {
            resolvedDefaultValue = this.getDefaultValue(type, parameters);
        }
        return resolvedDefaultValue;
    }
}

