/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

public class ForumDataInitialize
extends SpaceListenerPlugin {
    private static final Log log = ExoLogger.getLogger(ForumDataInitialize.class);
    private final InitParams params;

    public ForumDataInitialize(InitParams params) {
        this.params = params;
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent event) {
        String portletName = "";
        try {
            portletName = this.params.getValueParam("portletName").getValue();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!portletName.equals(event.getSource())) {
            return;
        }
        Space space = event.getSpace();
        Category category = new Category();
        category.setId(Utils.CATEGORY + space.getId());
        category.setCategoryName("/spaces".split("/")[1]);
        category.setOwner("manager:" + space.getGroupId());
        category.setUserPrivate(new String[]{space.getGroupId()});
        category.setDescription("");
        Forum forum = new Forum();
        forum.setOwner("manager:" + space.getGroupId());
        forum.setId(Utils.FORUM_SPACE_ID_PREFIX + space.getId());
        forum.setForumName(space.getPrettyName());
        forum.setDescription(space.getDescription());
        forum.setModerators(new String[]{"manager:" + space.getGroupId()});
        ForumService fServie = (ForumService)PortalContainer.getInstance().getComponentInstanceOfType(ForumService.class);
        try {
            if (fServie.getCategory(category.getId()) == null) {
                fServie.saveCategory(category, true);
            }
            if (fServie.getForum(category.getId(), forum.getId()) == null) {
                fServie.saveForum(category.getId(), forum, true);
            }
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage());
        }
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }
}

