/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ks.ext.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumEventListener;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Post;
import org.exoplatform.forum.service.Topic;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.ks.bbcode.core.ExtendedBBCodeProvider;
import org.exoplatform.ks.ext.impl.ForumTransformHTML;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumSpaceActivityPublisher
extends ForumEventListener {
    public static final String FORUM_APP_ID = "ks-forum:spaces";
    public static final String FORUM_ID_KEY = "ForumId";
    public static final String CATE_ID_KEY = "CateId";
    public static final String ACTIVITY_TYPE_KEY = "ActivityType";
    public static final String POST_ID_KEY = "PostId";
    public static final String POST_OWNER_KEY = "PostOwner";
    public static final String POST_LINK_KEY = "PostLink";
    public static final String POST_NAME_KEY = "PostName";
    public static final String TOPIC_ID_KEY = "TopicId";
    public static final String TOPIC_OWNER_KEY = "TopicOwner";
    public static final String TOPIC_LINK_KEY = "TopicLink";
    public static final String TOPIC_NAME_KEY = "TopicName";
    private static final int TYPE_PRIVATE = 2;
    private static Log LOG = ExoLogger.getExoLogger(ForumSpaceActivityPublisher.class);

    public void saveCategory(Category category) {
    }

    public void saveForum(Forum forum) {
    }

    private void saveActivity(String categoryId, String forumId, ACTIVITYTYPE type, Topic topic, Post post) throws Exception {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        IdentityManager identityM = (IdentityManager)exoContainer.getComponentInstanceOfType(IdentityManager.class);
        ActivityManager activityM = (ActivityManager)exoContainer.getComponentInstanceOfType(ActivityManager.class);
        SpaceService spaceS = (SpaceService)exoContainer.getComponentInstanceOfType(SpaceService.class);
        Identity userIdentity = identityM.getOrCreateIdentity("organization", post.getOwner(), false);
        String spaceId = forumId.split(Utils.FORUM_SPACE_ID_PREFIX)[1];
        Space space = spaceS.getSpaceById(spaceId);
        Identity spaceIdentity = identityM.getOrCreateIdentity("space", space.getPrettyName(), false);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        String body = ForumTransformHTML.getTitleInHTMLCode(post.getMessage(), new ArrayList<String>(new ExtendedBBCodeProvider().getSupportedBBCodes()));
        activity.setUserId(userIdentity.getId());
        activity.setTitle(post.getOwner());
        activity.setBody(body);
        activity.setType(FORUM_APP_ID);
        HashMap<String, String> templateParams = new HashMap<String, String>();
        templateParams.put(FORUM_ID_KEY, forumId);
        templateParams.put(CATE_ID_KEY, categoryId);
        templateParams.put(TOPIC_ID_KEY, topic.getId());
        templateParams.put(ACTIVITY_TYPE_KEY, type.toString());
        activity.setTemplateParams(this.createActivity(templateParams, topic, post, type));
        activityM.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
    }

    private Map<String, String> createActivity(Map<String, String> templateParams, Topic topic, Post post, ACTIVITYTYPE type) throws Exception {
        if (type.toString().indexOf("Post") > 0) {
            templateParams.put(POST_ID_KEY, post.getId());
            templateParams.put(POST_LINK_KEY, post.getLink());
            templateParams.put(POST_NAME_KEY, post.getName());
            templateParams.put(POST_OWNER_KEY, post.getOwner());
        } else {
            templateParams.put(TOPIC_LINK_KEY, topic.getLink());
            templateParams.put(TOPIC_NAME_KEY, topic.getTopicName());
            templateParams.put(TOPIC_OWNER_KEY, topic.getOwner());
        }
        return templateParams;
    }

    private Post convertTopicToPost(Topic topic) {
        Post post = new Post();
        post.setOwner(topic.getOwner());
        post.setMessage(topic.getDescription());
        return post;
    }

    private Topic getTopicIfPublic(Post post, Topic topic, String categoryId, String forumId, String topicId) {
        if (topic == null && post == null) {
            return null;
        }
        try {
            if (topic == null) {
                ForumService forumService = (ForumService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ForumService.class);
                topic = forumService.getTopic(categoryId, forumId, topicId, "");
            }
            if (topic == null || !topic.getIsActive() || !topic.getIsApproved() || topic.getIsWaiting() || topic.getIsClosed() || !Utils.isEmpty((String[])topic.getCanView())) {
                return null;
            }
            if (!(post == null || post.getUserPrivate().length != 2 && !post.getIsHidden() && post.getIsActiveByTopic() && post.getIsApproved())) {
                return null;
            }
            return topic;
        }
        catch (Exception e) {
            LOG.debug((Object)"Failed to check public", (Throwable)e);
            return null;
        }
    }

    private boolean hasSocial() throws Exception {
        try {
            Class.forName("org.exoplatform.social.core.manager.IdentityManager");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOG.debug((Object)("Please check the integrated project does the social deploy? " + e.getMessage()));
            return false;
        }
    }

    private boolean hasSpace(String forumId) throws Exception {
        return this.hasSocial() && !Utils.isEmpty((String)forumId) && forumId.indexOf(Utils.FORUM_SPACE_ID_PREFIX) >= 0;
    }

    private void saveActivityForPost(Post post, String categoryId, String forumId, String topicId, ACTIVITYTYPE type) {
        try {
            Topic topic;
            if (this.hasSpace(forumId) && (topic = this.getTopicIfPublic(post, null, categoryId, forumId, topicId)) != null) {
                this.saveActivity(categoryId, forumId, type, topic, post);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Can not record Activity for space when post ", (Throwable)e);
        }
    }

    private void saveActivityForTopic(Topic topic, String categoryId, String forumId, ACTIVITYTYPE type) {
        try {
            if (this.hasSpace(forumId) && (topic = this.getTopicIfPublic(null, topic, categoryId, forumId, topic.getId())) != null) {
                this.saveActivity(categoryId, forumId, type, topic, this.convertTopicToPost(topic));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Can not record Activity for space when add topic " + e.getMessage()));
        }
    }

    public void addPost(Post post, String categoryId, String forumId, String topicId) {
        this.saveActivityForPost(post, categoryId, forumId, topicId, ACTIVITYTYPE.AddPost);
    }

    public void addTopic(Topic topic, String categoryId, String forumId) {
        this.saveActivityForTopic(topic, categoryId, forumId, ACTIVITYTYPE.AddTopic);
    }

    public void updatePost(Post post, String categoryId, String forumId, String topicId) {
        this.saveActivityForPost(post, categoryId, forumId, topicId, ACTIVITYTYPE.UpdatePost);
    }

    public void updateTopic(Topic topic, String categoryId, String forumId) {
        this.saveActivityForTopic(topic, categoryId, forumId, ACTIVITYTYPE.UpdateTopic);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ACTIVITYTYPE {
        AddPost,
        AddTopic,
        UpdatePost,
        UpdateTopic;

    }
}

