/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.backup.rdbms;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.naming.NamingException;
import org.exoplatform.services.database.utils.ExceptionManagementHelper;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.rdbms.DBRestore;
import org.exoplatform.services.jcr.impl.backup.rdbms.RestoreTableRule;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SybaseDBRestore
extends DBRestore {
    private String restoreConstraint = null;

    public SybaseDBRestore(File storageDir, Connection jdbcConn, Map<String, RestoreTableRule> tables, WorkspaceEntry wsConfig, FileCleaner fileCleaner) throws NamingException, SQLException, RepositoryConfigurationException {
        super(storageDir, jdbcConn, tables, wsConfig, fileCleaner);
    }

    /*
     * Loose catch block
     */
    @Override
    public void clean() throws BackupException {
        block8: {
            this.jdbcConn.setAutoCommit(true);
            for (Map.Entry entry : this.tables.entrySet()) {
                String tableName = (String)entry.getKey();
                RestoreTableRule restoreRule = (RestoreTableRule)entry.getValue();
                super.preRestoreTable(tableName, restoreRule);
            }
            Object var6_6 = null;
            try {
                this.jdbcConn.setAutoCommit(false);
            }
            catch (SQLException e) {
                LOG.warn((Object)"Can't set auto commit to \"false\"", (Throwable)e);
            }
            break block8;
            {
                catch (SQLException e) {
                    throw new BackupException(ExceptionManagementHelper.getFullSQLExceptionMessage((SQLException)e), e);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    this.jdbcConn.setAutoCommit(false);
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Can't set auto commit to \"false\"", (Throwable)e);
                }
                throw throwable;
            }
        }
        super.clean();
    }

    @Override
    public void commit() throws BackupException {
        super.commit();
        this.restoreConstraint();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rollback() throws BackupException {
        BackupException rollbackException = null;
        try {
            try {
                super.rollback();
            }
            catch (BackupException e) {
                rollbackException = e;
                throw rollbackException;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                this.restoreConstraint();
                throw throwable;
            }
            catch (BackupException e) {
                if (rollbackException == null) throw e;
                LOG.error((Object)"Can not restore constraint", (Throwable)e);
                throw rollbackException;
            }
        }
        try {}
        catch (BackupException e) {
            if (rollbackException == null) throw e;
            LOG.error((Object)"Can not restore constraint", (Throwable)e);
            throw rollbackException;
        }
        this.restoreConstraint();
    }

    /*
     * Loose catch block
     */
    private void restoreConstraint() throws BackupException {
        block8: {
            this.jdbcConn.setAutoCommit(true);
            for (Map.Entry entry : this.tables.entrySet()) {
                String tableName = (String)entry.getKey();
                RestoreTableRule restoreRule = (RestoreTableRule)entry.getValue();
                super.postRestoreTable(tableName, restoreRule);
            }
            Object var6_6 = null;
            try {
                this.jdbcConn.setAutoCommit(false);
            }
            catch (SQLException e) {
                LOG.warn((Object)"Can't set auto commit to \"false\"", (Throwable)e);
            }
            break block8;
            {
                catch (SQLException e) {
                    throw new BackupException(e);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                try {
                    this.jdbcConn.setAutoCommit(false);
                }
                catch (SQLException e) {
                    LOG.warn((Object)"Can't set auto commit to \"false\"", (Throwable)e);
                }
                throw throwable;
            }
        }
    }

    @Override
    public void preRestoreTable(String tableName, RestoreTableRule restoreRule) throws SQLException {
    }

    @Override
    public void postRestoreTable(String tableName, RestoreTableRule restoreRule) throws SQLException {
    }
}

