/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.ArrayList;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.exoplatform.services.jcr.core.NamespaceAccessor;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.JcrTermQuery;
import org.exoplatform.services.jcr.impl.core.query.lucene.NodeTypeVirtualTableResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneVirtualTableResolver
extends NodeTypeVirtualTableResolver<Query> {
    private final LocationFactory locationFactory;
    private final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.LuceneVirtualTableResolver");
    private final String mixinTypesField;
    private final String primaryTypeField;

    public LuceneVirtualTableResolver(NodeTypeDataManager nodeTypeDataManager, NamespaceAccessor namespaceAccessor) throws RepositoryException {
        super(nodeTypeDataManager);
        this.locationFactory = new LocationFactory(namespaceAccessor);
        this.mixinTypesField = this.locationFactory.createJCRName(Constants.JCR_MIXINTYPES).getAsString();
        this.primaryTypeField = this.locationFactory.createJCRName(Constants.JCR_PRIMARYTYPE).getAsString();
    }

    @Override
    public Query resolve(InternalQName tableName, boolean includeInheritedTables) throws InvalidQueryException, RepositoryException {
        ArrayList<Term> terms = new ArrayList<Term>();
        Object query = null;
        try {
            Term t;
            String nodeTypeStringName = this.locationFactory.createJCRName(tableName).getAsString();
            if (this.isMixin(tableName)) {
                t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(this.mixinTypesField, nodeTypeStringName));
                terms.add(t);
            } else {
                t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(this.primaryTypeField, nodeTypeStringName));
                terms.add(t);
            }
            if (includeInheritedTables) {
                Set<InternalQName> allTypes = this.getSubTypes(tableName);
                for (InternalQName descendantNt : allTypes) {
                    String ntName = this.locationFactory.createJCRName(descendantNt).getAsString();
                    Term t2 = this.isMixin(descendantNt) ? new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(this.mixinTypesField, ntName)) : new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(this.primaryTypeField, ntName));
                    terms.add(t2);
                }
            }
        }
        catch (NoSuchNodeTypeException e) {
            throw new InvalidQueryException(e.getMessage(), (Throwable)e);
        }
        if (terms.size() == 0) {
            query = new BooleanQuery();
        } else if (terms.size() == 1) {
            query = new JcrTermQuery((Term)terms.get(0));
        } else {
            BooleanQuery b = new BooleanQuery();
            for (Term element : terms) {
                b.add((Query)new JcrTermQuery(element), BooleanClause.Occur.SHOULD);
            }
            query = b;
        }
        return query;
    }
}

