/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Similarity;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingQueue;
import org.exoplatform.services.jcr.impl.core.query.lucene.PersistentIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.DirectoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfflinePersistentIndex
extends PersistentIndex {
    public static final String NAME = "offline";
    private List<String> processedIDs = new ArrayList<String>();

    OfflinePersistentIndex(Analyzer analyzer, Similarity similarity, DocNumberCache cache, IndexingQueue indexingQueue, DirectoryManager directoryManager) throws IOException {
        super(NAME, analyzer, similarity, cache, indexingQueue, directoryManager);
    }

    @Override
    int getNumDocuments() throws IOException {
        return super.getNumDocuments();
    }

    @Override
    int removeDocument(Term idTerm) throws IOException {
        int count = super.removeDocument(idTerm);
        this.processedIDs.add(idTerm.text());
        return count;
    }

    @Override
    void addDocuments(Document[] docs) throws IOException {
        super.addDocuments(docs);
        for (Document doc : docs) {
            this.processedIDs.add(doc.get(FieldNames.UUID));
        }
    }

    @Override
    synchronized void close() {
        this.processedIDs.clear();
        super.close();
    }

    public List<String> getProcessedIDs() {
        return Collections.unmodifiableList(this.processedIDs);
    }
}

