/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.Serializable;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.RepositoryException;
import javax.transaction.TransactionManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.MandatoryItemsPersistenceListener;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCache;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCacheListener;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.NullItemData;
import org.exoplatform.services.jcr.datamodel.NullNodeData;
import org.exoplatform.services.jcr.datamodel.NullPropertyData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.backup.ResumeException;
import org.exoplatform.services.jcr.impl.backup.SuspendException;
import org.exoplatform.services.jcr.impl.backup.Suspendable;
import org.exoplatform.services.jcr.impl.core.itemfilters.QPathEntryFilter;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ACLHolder;
import org.exoplatform.services.jcr.impl.dataflow.persistent.BloomFilter;
import org.exoplatform.services.jcr.impl.dataflow.persistent.FilePersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManager;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManagerListener;
import org.exoplatform.services.jcr.impl.storage.SystemDataContainerHolder;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.rpc.RPCException;
import org.exoplatform.services.rpc.RPCService;
import org.exoplatform.services.rpc.RemoteCommand;
import org.exoplatform.services.rpc.TopologyChangeEvent;
import org.exoplatform.services.rpc.TopologyChangeListener;
import org.exoplatform.services.transaction.TransactionService;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheableWorkspaceDataManager
extends WorkspacePersistentDataManager
implements Suspendable,
TopologyChangeListener,
Startable,
WorkspaceStorageCacheListener {
    private static final double ACL_BF_FALSE_PROPBABILITY_DEFAULT = 0.1;
    private static final int ACL_BF_ELEMENTS_NUMBER_DEFAULT = 1000000;
    protected final WorkspaceStorageCache cache;
    protected final ConcurrentMap<Integer, DataRequest> requestCache;
    private final TransactionableResourceManager txResourceManager;
    private final AtomicBoolean filtersEnabled = new AtomicBoolean();
    private final double bfProbability;
    private final int bfElementNumber;
    private volatile BloomFilter<String> filterPermissions;
    private volatile BloomFilter<String> filterOwner;
    private TransactionManager transactionManager;
    protected final RPCService rpcService;
    protected AtomicInteger workingThreads = new AtomicInteger();
    protected boolean isSuspended = false;
    protected CountDownLatch latcher = null;
    protected Boolean isResponsibleForResuming = false;
    private RemoteCommand requestForResponsibleForResuming;
    private RemoteCommand suspend;
    private RemoteCommand resume;

    public CacheableWorkspaceDataManager(WorkspaceEntry wsConfig, WorkspaceDataContainer dataContainer, WorkspaceStorageCache cache, SystemDataContainerHolder systemDataContainerHolder, TransactionableResourceManager txResourceManager, TransactionService transactionService, RPCService rpcService) {
        super(dataContainer, systemDataContainerHolder, txResourceManager);
        this.bfProbability = wsConfig.getContainer().getParameterDouble("acl-bloomfilter-false-positive-probability", 0.1);
        if (this.bfProbability < 0.0 || this.bfProbability > 1.0) {
            throw new IllegalArgumentException("Parameter acl-bloomfilter-false-positive-probability is invalid, must be between 0 and 1.");
        }
        this.bfElementNumber = wsConfig.getContainer().getParameterInteger("acl-bloomfilter-elements-number", 1000000);
        if (this.bfElementNumber <= 0) {
            throw new IllegalArgumentException("Parameter acl-bloomfilter-elements-number is invalid, can not be less then 1.");
        }
        this.cache = cache;
        this.requestCache = new ConcurrentHashMap<Integer, DataRequest>();
        this.addItemPersistenceListener(new CacheItemsPersistenceListener());
        this.transactionManager = transactionService.getTransactionManager();
        this.rpcService = rpcService;
        this.txResourceManager = txResourceManager;
        this.doInitRemoteCommands();
    }

    public CacheableWorkspaceDataManager(WorkspaceEntry wsConfig, WorkspaceDataContainer dataContainer, WorkspaceStorageCache cache, SystemDataContainerHolder systemDataContainerHolder, TransactionableResourceManager txResourceManager, TransactionService transactionService) {
        this(wsConfig, dataContainer, cache, systemDataContainerHolder, txResourceManager, transactionService, null);
    }

    public CacheableWorkspaceDataManager(WorkspaceEntry wsConfig, WorkspaceDataContainer dataContainer, WorkspaceStorageCache cache, SystemDataContainerHolder systemDataContainerHolder, TransactionableResourceManager txResourceManager, RPCService rpcService) {
        super(dataContainer, systemDataContainerHolder, txResourceManager);
        this.bfProbability = wsConfig.getContainer().getParameterDouble("acl-bloomfilter-false-positive-probability", 0.1);
        if (this.bfProbability < 0.0 || this.bfProbability > 1.0) {
            throw new IllegalArgumentException("Parameter acl-bloomfilter-false-positive-probability is invalid, must be between 0 and 1.");
        }
        this.bfElementNumber = wsConfig.getContainer().getParameterInteger("acl-bloomfilter-elements-number", 1000000);
        if (this.bfElementNumber <= 0) {
            throw new IllegalArgumentException("Parameter acl-bloomfilter-elements-number is invalid, can not be less then 1.");
        }
        this.cache = cache;
        this.requestCache = new ConcurrentHashMap<Integer, DataRequest>();
        this.addItemPersistenceListener(new CacheItemsPersistenceListener());
        try {
            this.transactionManager = (TransactionManager)cache.getClass().getMethod("getTransactionManager", null).invoke(null, null);
        }
        catch (Exception e) {
            LOG.debug((Object)"Could not get the transaction manager from the cache", (Throwable)e);
            this.transactionManager = null;
        }
        this.rpcService = rpcService;
        this.txResourceManager = txResourceManager;
        this.doInitRemoteCommands();
    }

    public CacheableWorkspaceDataManager(WorkspaceEntry wsConfig, WorkspaceDataContainer dataContainer, WorkspaceStorageCache cache, SystemDataContainerHolder systemDataContainerHolder, TransactionableResourceManager txResourceManager) {
        this(wsConfig, dataContainer, cache, systemDataContainerHolder, txResourceManager, (RPCService)null);
    }

    public CacheableWorkspaceDataManager(WorkspaceEntry wsConfig, WorkspaceDataContainer dataContainer, WorkspaceStorageCache cache, SystemDataContainerHolder systemDataContainerHolder) {
        this(wsConfig, dataContainer, cache, systemDataContainerHolder, null, (RPCService)null);
    }

    public WorkspaceStorageCache getCache() {
        return this.cache;
    }

    @Override
    public int getChildNodesCount(final NodeData parent) throws RepositoryException {
        int childCount;
        if (this.cache.isEnabled() && (childCount = this.cache.getChildNodesCount(parent)) >= 0) {
            return childCount;
        }
        return this.executeAction(new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws RepositoryException {
                return CacheableWorkspaceDataManager.super.getChildNodesCount(parent);
            }
        });
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData nodeData) throws RepositoryException {
        return this.getChildNodesData(nodeData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getChildNodesDataByPage(final NodeData nodeData, final int fromOrderNum, final int limit, final List<NodeData> childs) throws RepositoryException {
        DataRequest request;
        block8: {
            List<NodeData> childNodes;
            block9: {
                if (!this.cache.isChildNodesByPageSupported()) {
                    childs.addAll(this.getChildNodesData(nodeData));
                    return false;
                }
                childNodes = null;
                if (this.cache.isEnabled()) {
                    childNodes = this.cache.getChildNodes(nodeData);
                    if (childNodes != null) {
                        childs.addAll(childNodes);
                        return false;
                    }
                    childNodes = this.cache.getChildNodesByPage(nodeData, fromOrderNum);
                    if (childNodes != null) {
                        childs.addAll(childNodes);
                        return true;
                    }
                }
                request = new DataRequest(nodeData.getIdentifier(), 1);
                try {
                    request.start();
                    if (!this.cache.isEnabled()) break block8;
                    childNodes = this.cache.getChildNodes(nodeData);
                    if (childNodes == null) break block9;
                    childs.addAll(childNodes);
                    boolean bl = false;
                    Object var9_10 = null;
                    request.done();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    request.done();
                    throw throwable;
                }
            }
            childNodes = this.cache.getChildNodesByPage(nodeData, fromOrderNum);
            if (childNodes == null) break block8;
            childs.addAll(childNodes);
            boolean bl = true;
            Object var9_11 = null;
            request.done();
            return bl;
        }
        boolean bl = this.executeAction(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public Boolean run() throws RepositoryException {
                boolean hasNext = CacheableWorkspaceDataManager.super.getChildNodesDataByPage(nodeData, fromOrderNum, limit, childs);
                if (CacheableWorkspaceDataManager.this.cache.isEnabled()) {
                    CacheableWorkspaceDataManager.this.cache.addChildNodesByPage(nodeData, childs, fromOrderNum);
                }
                return hasNext;
            }
        });
        Object var9_12 = null;
        request.done();
        return bl;
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData parentData, List<QPathEntryFilter> patternFilters) throws RepositoryException {
        return this.getChildNodesDataByPattern(parentData, patternFilters);
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData nodeData) throws RepositoryException {
        List<PropertyData> childs = this.getChildPropertiesData(nodeData, false);
        for (PropertyData prop : childs) {
            this.fixPropertyValues(prop);
        }
        return childs;
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData nodeData, List<QPathEntryFilter> itemDataFilters) throws RepositoryException {
        List<PropertyData> childs = this.getChildPropertiesDataByPattern(nodeData, itemDataFilters);
        for (PropertyData prop : childs) {
            this.fixPropertyValues(prop);
        }
        return childs;
    }

    @Override
    public ItemData getItemData(NodeData parentData, QPathEntry name) throws RepositoryException {
        return this.getItemData(parentData, name, ItemType.UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ItemData getItemData(final NodeData parentData, final QPathEntry name, final ItemType itemType) throws RepositoryException {
        if (this.cache.isEnabled()) {
            ItemData data = this.getCachedItemData(parentData, name, itemType);
            if (data == null) {
                DataRequest request = new DataRequest(parentData.getIdentifier(), name);
                try {
                    request.start();
                    data = this.getCachedItemData(parentData, name, itemType);
                    if (data == null) {
                        data = this.executeAction(new PrivilegedExceptionAction<ItemData>(){

                            @Override
                            public ItemData run() throws RepositoryException {
                                return CacheableWorkspaceDataManager.this.getPersistedItemData(parentData, name, itemType);
                            }
                        });
                    }
                    Object var7_6 = null;
                    request.done();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    request.done();
                    throw throwable;
                }
            }
            if (data instanceof NullItemData) {
                return null;
            }
            if (data != null && !data.isNode()) {
                this.fixPropertyValues((PropertyData)data);
            }
            return data;
        }
        return this.executeAction(new PrivilegedExceptionAction<ItemData>(){

            @Override
            public ItemData run() throws RepositoryException {
                ItemData item = CacheableWorkspaceDataManager.super.getItemData(parentData, name, itemType);
                return item != null && item.isNode() ? CacheableWorkspaceDataManager.this.initACL(parentData, (NodeData)item) : item;
            }
        });
    }

    @Override
    public ItemData getItemData(String identifier) throws RepositoryException {
        return this.getItemData(identifier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemData getItemData(final String identifier, final boolean doInitACL) throws RepositoryException {
        if (this.cache.isEnabled()) {
            ItemData data = this.getCachedItemData(identifier);
            if (data == null) {
                DataRequest request = new DataRequest(identifier);
                try {
                    request.start();
                    data = this.getCachedItemData(identifier);
                    if (data == null) {
                        data = this.executeAction(new PrivilegedExceptionAction<ItemData>(){

                            @Override
                            public ItemData run() throws RepositoryException {
                                return CacheableWorkspaceDataManager.this.getPersistedItemData(identifier);
                            }
                        });
                    }
                    Object var6_5 = null;
                    request.done();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    request.done();
                    throw throwable;
                }
            }
            if (data instanceof NullItemData) {
                return null;
            }
            if (data != null && !data.isNode()) {
                this.fixPropertyValues((PropertyData)data);
            }
            return data;
        }
        return this.executeAction(new PrivilegedExceptionAction<ItemData>(){

            @Override
            public ItemData run() throws RepositoryException {
                ItemData item = CacheableWorkspaceDataManager.super.getItemData(identifier);
                if (item != null && item.isNode() && doInitACL) {
                    return CacheableWorkspaceDataManager.this.initACL(null, (NodeData)item);
                }
                return item;
            }
        });
    }

    @Override
    public List<PropertyData> getReferencesData(String identifier, boolean skipVersionStorage) throws RepositoryException {
        List<PropertyData> props = this.getReferencedPropertiesData(identifier);
        if (skipVersionStorage) {
            ArrayList<PropertyData> result = new ArrayList<PropertyData>();
            int length = props.size();
            for (int i = 0; i < length; ++i) {
                PropertyData prop = props.get(i);
                if (prop.getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH)) continue;
                result.add(prop);
            }
            return result;
        }
        return props;
    }

    @Override
    public List<PropertyData> listChildPropertiesData(NodeData nodeData) throws RepositoryException {
        return this.listChildPropertiesData(nodeData, false);
    }

    @Override
    public void save(final ItemStateChangesLog changesLog) throws RepositoryException {
        if (this.isSuspended) {
            try {
                this.latcher.await();
            }
            catch (InterruptedException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        this.workingThreads.incrementAndGet();
        try {
            try {
                SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        CacheableWorkspaceDataManager.this.doSave(changesLog);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RepositoryException) {
                    throw (RepositoryException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
            Object var5_4 = null;
            this.workingThreads.decrementAndGet();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.workingThreads.decrementAndGet();
            throw throwable;
        }
    }

    private void doSave(ItemStateChangesLog changesLog) throws RepositoryException {
        WorkspacePersistentDataManager.ChangesLogWrapper logWrapper = new WorkspacePersistentDataManager.ChangesLogWrapper(this, changesLog);
        if (this.isTxAware()) {
            if (this.txResourceManager != null && this.txResourceManager.isGlobalTxActive()) {
                super.save(logWrapper);
                this.registerListener(logWrapper);
            } else {
                this.doBegin();
                try {
                    super.save(logWrapper);
                }
                catch (Exception e) {
                    this.doRollback();
                    if (e instanceof RepositoryException) {
                        throw (RepositoryException)((Object)e);
                    }
                    throw new RepositoryException("Could not save the changes", (Throwable)e);
                }
                this.doCommit();
                this.notifySaveItems(logWrapper.getChangesLog(), false);
            }
        } else {
            super.save(logWrapper);
            this.notifySaveItems(logWrapper.getChangesLog(), false);
        }
    }

    private void doCommit() throws RepositoryException {
        try {
            this.transactionManager.commit();
        }
        catch (Exception e) {
            throw new RepositoryException("Could not commit the changes", (Throwable)e);
        }
    }

    private void doBegin() throws RepositoryException {
        try {
            this.transactionManager.begin();
        }
        catch (Exception e) {
            throw new RepositoryException("Could not create a new Tx", (Throwable)e);
        }
    }

    private void doRollback() {
        try {
            this.transactionManager.rollback();
        }
        catch (Exception e) {
            LOG.error((Object)"Rollback error ", (Throwable)e);
        }
    }

    private void registerListener(final WorkspacePersistentDataManager.ChangesLogWrapper logWrapper) throws RepositoryException {
        try {
            this.txResourceManager.addListener(new TransactionableResourceManagerListener(){

                public void onCommit(boolean onePhase) throws Exception {
                }

                public void onAfterCompletion(int status) throws Exception {
                    if (status == 3) {
                        CacheableWorkspaceDataManager.this.transactionManager.suspend();
                        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

                            @Override
                            public Void run() {
                                CacheableWorkspaceDataManager.this.notifySaveItems(logWrapper.getChangesLog(), false);
                                return null;
                            }
                        });
                    }
                }

                public void onAbort() throws Exception {
                }
            });
        }
        catch (Exception e) {
            throw new RepositoryException("The listener for the components not tx aware could not be added", (Throwable)e);
        }
    }

    protected ItemData getCachedItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException {
        return this.cache.isEnabled() ? this.cache.get(parentData.getIdentifier(), name, itemType) : null;
    }

    protected ItemData getCachedItemData(String identifier) throws RepositoryException {
        return this.cache.isEnabled() ? this.cache.get(identifier) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<NodeData> getChildNodesData(final NodeData nodeData, boolean forcePersistentRead) throws RepositoryException {
        DataRequest request;
        block4: {
            List<NodeData> childNodes = null;
            if (!forcePersistentRead && this.cache.isEnabled() && (childNodes = this.cache.getChildNodes(nodeData)) != null) {
                return childNodes;
            }
            request = new DataRequest(nodeData.getIdentifier(), 1);
            try {
                request.start();
                if (forcePersistentRead || !this.cache.isEnabled() || (childNodes = this.cache.getChildNodes(nodeData)) == null) break block4;
                List<NodeData> list = childNodes;
                Object var7_7 = null;
                request.done();
                return list;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                request.done();
                throw throwable;
            }
        }
        List<NodeData> list = this.executeAction(new PrivilegedExceptionAction<List<NodeData>>(){

            @Override
            public List<NodeData> run() throws RepositoryException {
                List childNodes = CacheableWorkspaceDataManager.super.getChildNodesData(nodeData);
                if (CacheableWorkspaceDataManager.this.cache.isEnabled()) {
                    CacheableWorkspaceDataManager.this.cache.addChildNodes(nodeData, childNodes);
                }
                return childNodes;
            }
        });
        Object var7_8 = null;
        request.done();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<NodeData> getChildNodesDataByPattern(final NodeData parentData, final List<QPathEntryFilter> patternFilters) throws RepositoryException {
        if (!this.cache.isEnabled()) {
            return this.executeAction(new PrivilegedExceptionAction<List<NodeData>>(){

                @Override
                public List<NodeData> run() throws RepositoryException {
                    List childNodes = CacheableWorkspaceDataManager.super.getChildNodesData(parentData, patternFilters);
                    for (int i = 0; i < childNodes.size(); ++i) {
                        childNodes.set(i, (NodeData)CacheableWorkspaceDataManager.this.initACL(parentData, (NodeData)childNodes.get(i)));
                    }
                    return childNodes;
                }
            });
        }
        if (!this.cache.isPatternSupported()) {
            return this.getChildNodesData(parentData);
        }
        List<NodeData> childNodesList = this.cache.getChildNodes(parentData);
        if (childNodesList != null) {
            return childNodesList;
        }
        final HashMap<String, NodeData> childNodesMap = new HashMap<String, NodeData>();
        final HashSet<QPathEntryFilter> uncachedPatterns = new HashSet<QPathEntryFilter>();
        for (int i = 0; i < patternFilters.size(); ++i) {
            if (patternFilters.get(i).isExactName()) {
                ItemData data = this.getCachedItemData(parentData, patternFilters.get(i).getQPathEntry(), ItemType.NODE);
                if (data != null) {
                    if (data instanceof NullItemData) continue;
                    childNodesMap.put(data.getIdentifier(), (NodeData)data);
                    continue;
                }
                uncachedPatterns.add(patternFilters.get(i));
                continue;
            }
            List<NodeData> cachedItemList = this.cache.getChildNodes(parentData, patternFilters.get(i));
            if (cachedItemList != null) {
                int length = cachedItemList.size();
                for (int j = 0; j < length; ++j) {
                    childNodesMap.put(cachedItemList.get(j).getIdentifier(), cachedItemList.get(j));
                }
                continue;
            }
            uncachedPatterns.add(patternFilters.get(i));
        }
        if (!uncachedPatterns.isEmpty()) {
            ArrayList<DataRequest> requests;
            block20: {
                requests = new ArrayList<DataRequest>();
                DataRequest request = new DataRequest(parentData.getIdentifier(), 1);
                request.start();
                requests.add(request);
                childNodesList = this.cache.getChildNodes(parentData);
                if (childNodesList == null) break block20;
                List<NodeData> j = childNodesList;
                Object var14_14 = null;
                for (DataRequest rq : requests) {
                    rq.done();
                }
                requests.clear();
                return j;
            }
            try {
                Iterator patternIterator = uncachedPatterns.iterator();
                while (patternIterator.hasNext()) {
                    QPathEntryFilter pattern = (QPathEntryFilter)patternIterator.next();
                    if (pattern.isExactName()) {
                        DataRequest exactNameRequest = new DataRequest(parentData.getIdentifier(), pattern.getQPathEntry());
                        exactNameRequest.start();
                        requests.add(exactNameRequest);
                        ItemData data = this.getCachedItemData(parentData, pattern.getQPathEntry(), ItemType.NODE);
                        if (data == null) continue;
                        if (!(data instanceof NullItemData)) {
                            childNodesMap.put(data.getIdentifier(), (NodeData)data);
                        }
                        patternIterator.remove();
                        continue;
                    }
                    List<NodeData> cachedItemList = this.cache.getChildNodes(parentData, pattern);
                    if (cachedItemList == null) continue;
                    int length = cachedItemList.size();
                    for (int j = 0; j < length; ++j) {
                        childNodesMap.put(cachedItemList.get(j).getIdentifier(), cachedItemList.get(j));
                    }
                    patternIterator.remove();
                }
                patternIterator = null;
                if (!uncachedPatterns.isEmpty()) {
                    this.executeAction(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws RepositoryException {
                            NodeData parent;
                            List persistedItemList = CacheableWorkspaceDataManager.super.getChildNodesData(parentData, new ArrayList(uncachedPatterns));
                            if (persistedItemList.size() > 0 && (parent = (NodeData)CacheableWorkspaceDataManager.this.getItemData(parentData.getIdentifier())) != null) {
                                for (QPathEntryFilter pattern : uncachedPatterns) {
                                    List<? extends ItemData> persistedNodeData = pattern.accept(persistedItemList);
                                    if (pattern.isExactName()) {
                                        if (persistedNodeData.isEmpty()) {
                                            CacheableWorkspaceDataManager.this.cache.put(new NullNodeData(parentData, pattern.getQPathEntry()));
                                        } else {
                                            CacheableWorkspaceDataManager.this.cache.put(persistedNodeData.get(0));
                                        }
                                    } else {
                                        CacheableWorkspaceDataManager.this.cache.addChildNodes(parent, pattern, persistedNodeData);
                                    }
                                    for (NodeData node : persistedItemList) {
                                        childNodesMap.put(node.getIdentifier(), node);
                                    }
                                }
                            }
                            return null;
                        }
                    });
                }
                Object var14_15 = null;
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                for (DataRequest rq : requests) {
                    rq.done();
                }
                requests.clear();
                throw throwable;
            }
            for (DataRequest rq : requests) {
                rq.done();
            }
            requests.clear();
            {
            }
        }
        return new ArrayList<NodeData>(childNodesMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyData> getReferencedPropertiesData(final String identifier) throws RepositoryException {
        DataRequest request;
        block4: {
            List<PropertyData> refProps = null;
            if (this.cache.isEnabled() && (refProps = this.cache.getReferencedProperties(identifier)) != null) {
                return refProps;
            }
            request = new DataRequest(identifier, 6);
            try {
                request.start();
                if (!this.cache.isEnabled() || (refProps = this.cache.getReferencedProperties(identifier)) == null) break block4;
                List<PropertyData> list = refProps;
                Object var6_6 = null;
                request.done();
                return list;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                request.done();
                throw throwable;
            }
        }
        List<PropertyData> list = this.executeAction(new PrivilegedExceptionAction<List<PropertyData>>(){

            @Override
            public List<PropertyData> run() throws RepositoryException {
                List refProps = CacheableWorkspaceDataManager.super.getReferencesData(identifier, false);
                if (CacheableWorkspaceDataManager.this.cache.isEnabled()) {
                    CacheableWorkspaceDataManager.this.cache.addReferencedProperties(identifier, refProps);
                }
                return refProps;
            }
        });
        Object var6_7 = null;
        request.done();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyData> getChildPropertiesData(final NodeData nodeData, boolean forcePersistentRead) throws RepositoryException {
        DataRequest request;
        block4: {
            List<PropertyData> childProperties = null;
            if (!forcePersistentRead && this.cache.isEnabled() && (childProperties = this.cache.getChildProperties(nodeData)) != null) {
                return childProperties;
            }
            request = new DataRequest(nodeData.getIdentifier(), 2);
            try {
                request.start();
                if (forcePersistentRead || !this.cache.isEnabled() || (childProperties = this.cache.getChildProperties(nodeData)) == null) break block4;
                List<PropertyData> list = childProperties;
                Object var7_7 = null;
                request.done();
                return list;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                request.done();
                throw throwable;
            }
        }
        List<PropertyData> list = this.executeAction(new PrivilegedExceptionAction<List<PropertyData>>(){

            @Override
            public List<PropertyData> run() throws RepositoryException {
                List childProperties = CacheableWorkspaceDataManager.super.getChildPropertiesData(nodeData);
                if (childProperties.size() > 0 && CacheableWorkspaceDataManager.this.cache.isEnabled()) {
                    CacheableWorkspaceDataManager.this.cache.addChildProperties(nodeData, childProperties);
                }
                return childProperties;
            }
        });
        Object var7_8 = null;
        request.done();
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyData> getChildPropertiesDataByPattern(final NodeData nodeData, final List<QPathEntryFilter> patternFilters) throws RepositoryException {
        if (!this.cache.isEnabled()) {
            return this.executeAction(new PrivilegedExceptionAction<List<PropertyData>>(){

                @Override
                public List<PropertyData> run() throws RepositoryException {
                    return CacheableWorkspaceDataManager.super.getChildPropertiesData(nodeData, patternFilters);
                }
            });
        }
        if (!this.cache.isPatternSupported()) {
            return this.getChildPropertiesData(nodeData);
        }
        List<PropertyData> childPropsList = this.cache.getChildProperties(nodeData);
        if (childPropsList != null) {
            return childPropsList;
        }
        final HashMap<String, PropertyData> childPropsMap = new HashMap<String, PropertyData>();
        final HashSet<QPathEntryFilter> uncachedPatterns = new HashSet<QPathEntryFilter>();
        for (int i = 0; i < patternFilters.size(); ++i) {
            if (patternFilters.get(i).isExactName()) {
                ItemData data = this.getCachedItemData(nodeData, patternFilters.get(i).getQPathEntry(), ItemType.PROPERTY);
                if (data != null) {
                    if (data instanceof NullPropertyData) continue;
                    childPropsMap.put(data.getIdentifier(), (PropertyData)data);
                    continue;
                }
                uncachedPatterns.add(patternFilters.get(i));
                continue;
            }
            List<PropertyData> cachedItemList = this.cache.getChildProperties(nodeData, patternFilters.get(i));
            if (cachedItemList != null) {
                int length = cachedItemList.size();
                for (int j = 0; j < length; ++j) {
                    childPropsMap.put(cachedItemList.get(j).getIdentifier(), cachedItemList.get(j));
                }
                continue;
            }
            uncachedPatterns.add(patternFilters.get(i));
        }
        if (!uncachedPatterns.isEmpty()) {
            ArrayList<DataRequest> requests;
            block20: {
                requests = new ArrayList<DataRequest>();
                DataRequest request = new DataRequest(nodeData.getIdentifier(), 2);
                request.start();
                requests.add(request);
                childPropsList = this.cache.getChildProperties(nodeData);
                if (childPropsList == null) break block20;
                List<PropertyData> j = childPropsList;
                Object var14_14 = null;
                for (DataRequest rq : requests) {
                    rq.done();
                }
                requests.clear();
                return j;
            }
            try {
                Iterator patternIterator = uncachedPatterns.iterator();
                while (patternIterator.hasNext()) {
                    QPathEntryFilter pattern = (QPathEntryFilter)patternIterator.next();
                    if (pattern.isExactName()) {
                        DataRequest exactNameRequest = new DataRequest(nodeData.getIdentifier(), pattern.getQPathEntry());
                        exactNameRequest.start();
                        requests.add(exactNameRequest);
                        ItemData data = this.getCachedItemData(nodeData, pattern.getQPathEntry(), ItemType.PROPERTY);
                        if (data == null) continue;
                        if (!(data instanceof NullPropertyData)) {
                            childPropsMap.put(data.getIdentifier(), (PropertyData)data);
                        }
                        patternIterator.remove();
                        continue;
                    }
                    List<PropertyData> cachedItemList = this.cache.getChildProperties(nodeData, pattern);
                    if (cachedItemList == null) continue;
                    int length = cachedItemList.size();
                    for (int j = 0; j < length; ++j) {
                        childPropsMap.put(cachedItemList.get(j).getIdentifier(), cachedItemList.get(j));
                    }
                    patternIterator.remove();
                }
                patternIterator = null;
                if (!uncachedPatterns.isEmpty()) {
                    this.executeAction(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws RepositoryException {
                            NodeData parent;
                            List persistedItemList = CacheableWorkspaceDataManager.super.getChildPropertiesData(nodeData, new ArrayList(uncachedPatterns));
                            if (persistedItemList.size() > 0 && (parent = (NodeData)CacheableWorkspaceDataManager.this.getItemData(nodeData.getIdentifier())) != null) {
                                for (QPathEntryFilter pattern : uncachedPatterns) {
                                    List<? extends ItemData> persistedPropData = pattern.accept(persistedItemList);
                                    if (pattern.isExactName()) {
                                        if (persistedPropData.isEmpty()) {
                                            CacheableWorkspaceDataManager.this.cache.put(new NullPropertyData(parent, pattern.getQPathEntry()));
                                        } else {
                                            CacheableWorkspaceDataManager.this.cache.put(persistedPropData.get(0));
                                        }
                                    } else {
                                        CacheableWorkspaceDataManager.this.cache.addChildProperties(parent, pattern, persistedPropData);
                                    }
                                    for (PropertyData node : persistedItemList) {
                                        childPropsMap.put(node.getIdentifier(), node);
                                    }
                                }
                            }
                            return null;
                        }
                    });
                }
                Object var14_15 = null;
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                for (DataRequest rq : requests) {
                    rq.done();
                }
                requests.clear();
                throw throwable;
            }
            for (DataRequest rq : requests) {
                rq.done();
            }
            requests.clear();
            {
            }
        }
        return new ArrayList<PropertyData>(childPropsMap.values());
    }

    protected ItemData getPersistedItemData(NodeData parentData, QPathEntry name, ItemType itemType) throws RepositoryException {
        ItemData data = super.getItemData(parentData, name, itemType);
        if (this.cache.isEnabled()) {
            if (data == null) {
                if (itemType == ItemType.NODE || itemType == ItemType.UNKNOWN) {
                    this.cache.put(new NullNodeData(parentData, name));
                } else {
                    this.cache.put(new NullPropertyData(parentData, name));
                }
            } else {
                this.cache.put(data);
            }
        }
        return data;
    }

    protected ItemData getPersistedItemData(String identifier) throws RepositoryException {
        ItemData data = super.getItemData(identifier);
        if (data != null && data.isNode()) {
            data = this.initACL(null, (NodeData)data);
        }
        if (this.cache.isEnabled()) {
            if (data != null) {
                this.cache.put(data);
            } else if (identifier != null) {
                this.cache.put(new NullNodeData(identifier));
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyData> listChildPropertiesData(final NodeData nodeData, boolean forcePersistentRead) throws RepositoryException {
        DataRequest request;
        block4: {
            List<PropertyData> propertiesList;
            if (!forcePersistentRead && this.cache.isEnabled() && (propertiesList = this.cache.listChildProperties(nodeData)) != null) {
                return propertiesList;
            }
            request = new DataRequest(nodeData.getIdentifier(), 5);
            try {
                request.start();
                if (forcePersistentRead || !this.cache.isEnabled() || (propertiesList = this.cache.listChildProperties(nodeData)) == null) break block4;
                List<PropertyData> list = propertiesList;
                Object var7_7 = null;
                request.done();
                return list;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                request.done();
                throw throwable;
            }
        }
        List<PropertyData> list = this.executeAction(new PrivilegedExceptionAction<List<PropertyData>>(){

            @Override
            public List<PropertyData> run() throws RepositoryException {
                List propertiesList = CacheableWorkspaceDataManager.super.listChildPropertiesData(nodeData);
                if (propertiesList.size() > 0 && CacheableWorkspaceDataManager.this.cache.isEnabled()) {
                    CacheableWorkspaceDataManager.this.cache.addChildPropertiesList(nodeData, propertiesList);
                }
                return propertiesList;
            }
        });
        Object var7_8 = null;
        request.done();
        return list;
    }

    protected boolean isTxAware() {
        return this.transactionManager != null;
    }

    protected void fixPropertyValues(PropertyData prop) throws RepositoryException {
        List<ValueData> vals = prop.getValues();
        for (int i = 0; i < vals.size(); ++i) {
            FilePersistedValueData fpvd;
            ValueData vd = vals.get(i);
            if (vd.isByteArray() || (fpvd = (FilePersistedValueData)vd).getFile() != null) continue;
            ValueData svd = this.getPropertyValue(prop.getIdentifier(), vd.getOrderNumber(), prop.getPersistedVersion());
            if (svd == null) {
                throw new RepositoryException("Value cannot be found in storage for cached Property " + prop.getQPath().getAsString() + ", orderNumb:" + vd.getOrderNumber() + ", pversion:" + prop.getPersistedVersion());
            }
            vals.set(i, svd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueData getPropertyValue(String propertyId, int orderNumb, int persistedVersion) throws IllegalStateException, RepositoryException {
        ValueData valueData;
        WorkspaceStorageConnection con = this.dataContainer.openConnection();
        try {
            valueData = con.getValue(propertyId, orderNumb, persistedVersion);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            con.close();
            throw throwable;
        }
        con.close();
        return valueData;
    }

    @Override
    public void suspend() throws SuspendException {
        this.isResponsibleForResuming = true;
        if (this.rpcService != null) {
            try {
                this.rpcService.executeCommandOnAllNodes(this.suspend, true, new Serializable[0]);
            }
            catch (SecurityException e) {
                throw new SuspendException(e);
            }
            catch (RPCException e) {
                throw new SuspendException(e);
            }
        } else {
            this.suspendLocally();
        }
    }

    @Override
    public void resume() throws ResumeException {
        if (this.rpcService != null) {
            try {
                this.rpcService.executeCommandOnAllNodes(this.resume, true, new Serializable[0]);
            }
            catch (SecurityException e) {
                throw new ResumeException(e);
            }
            catch (RPCException e) {
                throw new ResumeException(e);
            }
        } else {
            this.resumeLocally();
        }
        this.isResponsibleForResuming = false;
    }

    @Override
    public boolean isSuspended() {
        return this.isSuspended;
    }

    private void suspendLocally() throws SuspendException {
        if (this.isSuspended) {
            throw new SuspendException("Component already suspended.");
        }
        this.latcher = new CountDownLatch(1);
        this.isSuspended = true;
        while (this.workingThreads.get() != 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new SuspendException(e);
            }
        }
    }

    private void resumeLocally() throws ResumeException {
        if (!this.isSuspended) {
            throw new ResumeException("Component is not suspended.");
        }
        this.latcher.countDown();
        this.isSuspended = false;
    }

    public void onChange(TopologyChangeEvent event) {
        if (this.isSuspended) {
            new Thread(){

                public synchronized void run() {
                    try {
                        List results = CacheableWorkspaceDataManager.this.rpcService.executeCommandOnAllNodes(CacheableWorkspaceDataManager.this.requestForResponsibleForResuming, true, new Serializable[0]);
                        for (Object result : results) {
                            if (!((Boolean)result).booleanValue()) continue;
                            return;
                        }
                        try {
                            CacheableWorkspaceDataManager.this.resumeLocally();
                        }
                        catch (ResumeException e) {
                            WorkspacePersistentDataManager.LOG.error((Object)"Can not resume component", (Throwable)e);
                        }
                    }
                    catch (SecurityException e1) {
                        WorkspacePersistentDataManager.LOG.error((Object)"You haven't privileges to execute remote command", (Throwable)e1);
                    }
                    catch (RPCException e1) {
                        WorkspacePersistentDataManager.LOG.error((Object)"Exception during command execution", (Throwable)e1);
                    }
                }
            }.start();
        }
    }

    private void doInitRemoteCommands() {
        if (this.rpcService != null) {
            this.suspend = this.rpcService.registerCommand(new RemoteCommand(){

                public String getId() {
                    return "org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager-suspend-" + CacheableWorkspaceDataManager.this.dataContainer.getUniqueName();
                }

                public Serializable execute(Serializable[] args) throws Throwable {
                    CacheableWorkspaceDataManager.this.suspendLocally();
                    return null;
                }
            });
            this.resume = this.rpcService.registerCommand(new RemoteCommand(){

                public String getId() {
                    return "org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager-resume-" + CacheableWorkspaceDataManager.this.dataContainer.getUniqueName();
                }

                public Serializable execute(Serializable[] args) throws Throwable {
                    CacheableWorkspaceDataManager.this.resumeLocally();
                    return null;
                }
            });
            this.requestForResponsibleForResuming = this.rpcService.registerCommand(new RemoteCommand(){

                public String getId() {
                    return "org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager-requestForResponsibilityForResuming-" + CacheableWorkspaceDataManager.this.dataContainer.getUniqueName();
                }

                public Serializable execute(Serializable[] args) throws Throwable {
                    return CacheableWorkspaceDataManager.this.isResponsibleForResuming;
                }
            });
            this.rpcService.registerTopologyChangeListener((TopologyChangeListener)this);
        }
    }

    private <T> T executeAction(PrivilegedExceptionAction<T> action) throws RepositoryException {
        try {
            return (T)SecurityHelper.doPrivilegedExceptionAction(action);
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause instanceof RepositoryException) {
                throw (RepositoryException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private ItemData initACL(NodeData parent, NodeData node) throws RepositoryException {
        return this.initACL(parent, node, null);
    }

    private NodeData initACL(NodeData parent, NodeData node, ACLSearch search) throws RepositoryException {
        if (node != null) {
            AccessControlList acl = node.getACL();
            if (acl == null) {
                if (parent != null) {
                    node = new TransientNodeData(node.getQPath(), node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), parent.getACL());
                } else {
                    if (search == null) {
                        search = new ACLSearch(null, null);
                    }
                    node = new TransientNodeData(node.getQPath(), node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), this.getNearestACAncestorAcl(node, search));
                }
            } else if (!acl.hasPermissions()) {
                if (search == null) {
                    search = new ACLSearch(acl.getOwner(), null);
                } else {
                    search.setOwner(acl.getOwner());
                    if (search.found()) {
                        return new TransientNodeData(node.getQPath(), node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), new AccessControlList(acl.getOwner(), null));
                    }
                }
                AccessControlList ancestorAcl = parent != null && parent.getACL() != null && parent.getACL().hasPermissions() ? parent.getACL() : this.getNearestACAncestorAcl(node, search);
                node = new TransientNodeData(node.getQPath(), node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), new AccessControlList(acl.getOwner(), ancestorAcl.getPermissionEntries()));
            } else if (!acl.hasOwner()) {
                if (search == null) {
                    search = new ACLSearch(null, acl.getPermissionEntries());
                } else {
                    search.setPermissions(acl.getPermissionEntries());
                    if (search.found()) {
                        return new TransientNodeData(node.getQPath(), node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), new AccessControlList(null, acl.getPermissionEntries()));
                    }
                }
                AccessControlList ancestorAcl = parent != null && parent.getACL() != null && parent.getACL().hasOwner() ? parent.getACL() : this.getNearestACAncestorAcl(node, search);
                node = new TransientNodeData(node.getQPath(), node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), new AccessControlList(ancestorAcl.getOwner(), acl.getPermissionEntries()));
            }
        }
        return node;
    }

    private AccessControlList getNearestACAncestorAcl(NodeData node, ACLSearch search) throws RepositoryException {
        String id = node.getParentIdentifier();
        if (id != null) {
            NodeData parent;
            boolean filtersEnabled = this.filtersEnabled.get();
            BloomFilter<String> filterPermissions = this.filterPermissions;
            BloomFilter<String> filterOwner = this.filterOwner;
            if (filtersEnabled && filterOwner != null && filterPermissions != null) {
                QPathEntry entry;
                String currentId;
                QPathEntry[] entries = node.getQPath().getEntries();
                for (int i = entries.length - 2; i >= 0 && (currentId = (entry = entries[i]).getId()) != null; --i) {
                    if (!search.hasOwner() && filterOwner.contains(currentId) || !search.hasPermissions() && filterPermissions.contains(currentId)) {
                        id = currentId;
                        break;
                    }
                    id = currentId;
                }
            }
            if ((parent = this.getACL(id, search)) != null && parent.getACL() != null) {
                return parent.getACL();
            }
        }
        return new AccessControlList();
    }

    private NodeData getACL(String identifier, ACLSearch search) throws RepositoryException {
        ItemData item = this.getItemData(identifier, false);
        return item != null && item.isNode() ? this.initACL(null, (NodeData)item, search) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ACLHolder> getACLHolders() throws RepositoryException {
        List<ACLHolder> list;
        WorkspaceStorageConnection conn = this.dataContainer.openConnection();
        try {
            list = conn.getACLHolders();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            conn.close();
            throw throwable;
        }
        conn.close();
        return list;
    }

    @Managed
    @ManagedDescription(value="Reloads the bloom filters used to efficiently manage the ACLs")
    public boolean reloadFilters() {
        return this.loadFilters(false);
    }

    protected void clear() {
        this.filterPermissions = null;
        this.filterOwner = null;
    }

    public void start() {
        try {
            this.cache.addListener(this);
        }
        catch (UnsupportedOperationException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The bloom filters are disabled as they are not supported by the cache implementation " + this.cache.getClass().getName()));
            }
            return;
        }
        this.loadFilters(true);
    }

    protected boolean loadFilters(boolean cleanOnFail) {
        this.filtersEnabled.set(false);
        this.filterPermissions = new BloomFilter(this.bfProbability, this.bfElementNumber);
        this.filterOwner = new BloomFilter(this.bfProbability, this.bfElementNumber);
        boolean fails = true;
        List<ACLHolder> holders = null;
        try {
            LOG.info((Object)"Getting all the ACL Holders from the persistence layer");
            holders = this.getACLHolders();
            fails = false;
        }
        catch (UnsupportedOperationException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The method getACLHolders is not supported", (Throwable)e);
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Could not load all the ACL loaders", (Throwable)e);
        }
        if (fails) {
            if (cleanOnFail) {
                this.clear();
                this.cache.removeListener(this);
            }
            return false;
        }
        if (holders != null && !holders.isEmpty()) {
            LOG.info((Object)"Adding all the ACL Holders found into the BloomFilters");
            int length = holders.size();
            for (int i = 0; i < length; ++i) {
                ACLHolder holder = holders.get(i);
                if (holder.hasOwner()) {
                    this.filterOwner.add(holder.getId());
                }
                if (!holder.hasPermissions()) continue;
                this.filterPermissions.add(holder.getId());
            }
        }
        this.filtersEnabled.set(true);
        return true;
    }

    public void stop() {
    }

    @Override
    public void onCacheEntryAdded(ItemData data) {
        this.onCacheEntryUpdated(data);
    }

    @Override
    public void onCacheEntryUpdated(ItemData data) {
        if (data instanceof NodeData) {
            NodeData node = (NodeData)data;
            AccessControlList acl = node.getACL();
            if (acl == null) {
                return;
            }
            if (acl.hasOwner()) {
                this.filterOwner.add(node.getIdentifier());
            }
            if (acl.hasPermissions()) {
                this.filterPermissions.add(node.getIdentifier());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ACLSearch {
        private String owner;
        private List<AccessControlEntry> permissions;

        ACLSearch(String owner, List<AccessControlEntry> permissions) {
            this.owner = owner;
            this.permissions = permissions;
        }

        public boolean found() {
            return this.owner != null && this.permissions != null;
        }

        public void setOwner(String owner) {
            if (this.owner == null) {
                this.owner = owner;
            }
        }

        public void setPermissions(List<AccessControlEntry> permissions) {
            if (this.permissions == null) {
                this.permissions = permissions;
            }
        }

        public boolean hasOwner() {
            return this.owner != null;
        }

        public boolean hasPermissions() {
            return this.permissions != null;
        }
    }

    private class CacheItemsPersistenceListener
    implements MandatoryItemsPersistenceListener {
        private CacheItemsPersistenceListener() {
        }

        public boolean isTXAware() {
            return CacheableWorkspaceDataManager.this.cache.isTXAware();
        }

        public void onSaveItems(ItemStateChangesLog itemStates) {
            if (CacheableWorkspaceDataManager.this.cache.isEnabled()) {
                CacheableWorkspaceDataManager.this.cache.onSaveItems(itemStates);
            }
        }
    }

    protected class DataRequest {
        public static final int GET_NODES = 1;
        public static final int GET_PROPERTIES = 2;
        private static final int GET_ITEM_ID = 3;
        private static final int GET_ITEM_NAME = 4;
        private static final int GET_LIST_PROPERTIES = 5;
        public static final int GET_REFERENCES = 6;
        protected final int type;
        protected final String parentId;
        protected final String id;
        protected final QPathEntry name;
        protected final int hcode;
        protected CountDownLatch ready = new CountDownLatch(1);

        DataRequest(String parentId, int type) {
            this.parentId = parentId;
            this.name = null;
            this.id = null;
            this.type = type;
            this.hcode = 31 * (31 + this.type) + this.parentId.hashCode();
        }

        DataRequest(String parentId, QPathEntry name) {
            this.parentId = parentId;
            this.name = name;
            this.id = null;
            this.type = 4;
            int hc = 31 * (31 + this.type) + this.parentId.hashCode();
            this.hcode = 31 * hc + this.name.hashCode();
        }

        DataRequest(String id) {
            this.parentId = null;
            this.name = null;
            this.id = id;
            this.type = 3;
            this.hcode = 31 * (31 + this.type) + (this.id == null ? 0 : this.id.hashCode());
        }

        void start() {
            DataRequest request = CacheableWorkspaceDataManager.this.requestCache.putIfAbsent(this.hashCode(), this);
            if (request != null) {
                request.await();
            }
        }

        void done() {
            this.ready.countDown();
            CacheableWorkspaceDataManager.this.requestCache.remove(this.hashCode(), this);
        }

        void await() {
            try {
                this.ready.await();
            }
            catch (InterruptedException e) {
                WorkspacePersistentDataManager.LOG.warn((Object)("Can't wait for same request process. " + e), (Throwable)e);
            }
        }

        public boolean equals(Object obj) {
            return this.hcode == obj.hashCode();
        }

        public int hashCode() {
            return this.hcode;
        }
    }
}

