/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache.BufferedJBossCache;
import org.exoplatform.services.jcr.impl.dataflow.persistent.jbosscache.JBossCacheWorkspaceStorageCache;
import org.jboss.cache.Fqn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompressedChangesBuffer {
    private int historyIndex = 0;
    List<BufferedJBossCache.ChangesContainer> changes = new ArrayList<BufferedJBossCache.ChangesContainer>();
    Map<String, List<BufferedJBossCache.ChangesContainer>> childNodesMap = new HashMap<String, List<BufferedJBossCache.ChangesContainer>>();
    Map<String, List<BufferedJBossCache.ChangesContainer>> childPropertyMap = new HashMap<String, List<BufferedJBossCache.ChangesContainer>>();

    public void add(BufferedJBossCache.ChangesContainer container) {
        String parentCacheNode = (String)container.getFqn().get(0);
        if (JBossCacheWorkspaceStorageCache.CHILD_NODES.equals(parentCacheNode) && container.getFqn().size() > 1) {
            this.optimize(this.childNodesMap, container);
        } else if (JBossCacheWorkspaceStorageCache.CHILD_PROPS.equals(parentCacheNode) && container.getFqn().size() > 1) {
            this.optimize(this.childPropertyMap, container);
        } else {
            this.changes.add(container);
        }
    }

    public int getHistoryIndex() {
        ++this.historyIndex;
        return this.historyIndex;
    }

    public List<BufferedJBossCache.ChangesContainer> getSortedList() {
        List<BufferedJBossCache.ChangesContainer> changesContainers = this.listMap(this.childNodesMap);
        changesContainers.addAll(this.listMap(this.childPropertyMap));
        changesContainers.addAll(this.changes);
        Collections.sort(changesContainers);
        return changesContainers;
    }

    private void addToList(Map<String, List<BufferedJBossCache.ChangesContainer>> childMap, String parent, BufferedJBossCache.ChangesContainer container) {
        List<BufferedJBossCache.ChangesContainer> changesContainers = childMap.get(parent);
        if (changesContainers == null) {
            changesContainers = new ArrayList<BufferedJBossCache.ChangesContainer>();
        }
        changesContainers.add(container);
        childMap.put(parent, changesContainers);
    }

    private List<BufferedJBossCache.ChangesContainer> listMap(Map<String, List<BufferedJBossCache.ChangesContainer>> childMap) {
        ArrayList<BufferedJBossCache.ChangesContainer> containers = new ArrayList<BufferedJBossCache.ChangesContainer>();
        for (List<BufferedJBossCache.ChangesContainer> container : childMap.values()) {
            containers.addAll(container);
        }
        return containers;
    }

    private void optimize(Map<String, List<BufferedJBossCache.ChangesContainer>> childMap, BufferedJBossCache.ChangesContainer container) {
        Fqn fqn = container.getFqn();
        String parent = (String)fqn.get(1);
        if (fqn.size() == 2 && container.getChangesType() == BufferedJBossCache.ChangesType.REMOVE) {
            childMap.remove(parent);
        }
        this.addToList(childMap, parent, container);
    }
}

