/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.search.ExcludeIncludeDataTypePlugin;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.search.base.NodeSearchFilter;
import org.exoplatform.services.wcm.search.base.PageListFactory;
import org.exoplatform.services.wcm.search.base.SearchDataCreator;
import org.exoplatform.services.wcm.utils.AbstractQueryBuilder;
import org.exoplatform.services.wcm.utils.SQLQueryBuilder;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteSearchServiceImpl
implements SiteSearchService {
    private static final String IS_ENABLED_FUZZY_SEARCH = "isEnabledFuzzySearch";
    private static final String FUZZY_SEARCH_INDEX = "fuzzySearchIndex";
    private LivePortalManagerService livePortalManagerService;
    private TemplateService templateService;
    private WCMConfigurationService configurationService;
    private RepositoryService repositoryService;
    private CopyOnWriteArraySet<String> excludeNodeTypes = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<String> includeNodeTypes = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<String> excludeMimeTypes = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<String> includeMimeTypes = new CopyOnWriteArraySet();
    private boolean isEnabledFuzzySearch = true;
    private double fuzzySearchIndex = 0.8;
    private static Log log = ExoLogger.getLogger(SiteSearchServiceImpl.class);

    public SiteSearchServiceImpl(LivePortalManagerService portalManagerService, TemplateService templateService, WCMConfigurationService configurationService, RepositoryService repositoryService, InitParams initParams) throws Exception {
        this.livePortalManagerService = portalManagerService;
        this.templateService = templateService;
        this.repositoryService = repositoryService;
        this.configurationService = configurationService;
        if (initParams != null) {
            ValueParam enabledFuzzySearchValue;
            ValueParam isEnabledFuzzySearchValue = initParams.getValueParam(IS_ENABLED_FUZZY_SEARCH);
            if (isEnabledFuzzySearchValue != null) {
                this.isEnabledFuzzySearch = Boolean.parseBoolean(isEnabledFuzzySearchValue.getValue());
            }
            if ((enabledFuzzySearchValue = initParams.getValueParam(FUZZY_SEARCH_INDEX)) != null) {
                try {
                    this.fuzzySearchIndex = Double.parseDouble(enabledFuzzySearchValue.getValue());
                }
                catch (NumberFormatException e) {
                    this.fuzzySearchIndex = 0.8;
                }
            }
            if (this.fuzzySearchIndex < 0.0 || this.fuzzySearchIndex >= 1.0) {
                this.fuzzySearchIndex = 0.8;
            }
        }
    }

    @Override
    public void addExcludeIncludeDataTypePlugin(ExcludeIncludeDataTypePlugin plugin) {
        this.excludeNodeTypes.addAll(plugin.getExcludeNodeTypes());
        this.excludeMimeTypes.addAll(plugin.getExcludeMimeTypes());
        this.includeMimeTypes.addAll(plugin.getIncludeMimeTypes());
        this.includeNodeTypes.addAll(plugin.getIncludeNodeTypes());
    }

    @Override
    public AbstractPageList<ResultNode> searchSiteContents(SessionProvider sessionProvider, QueryCriteria queryCriteria, int pageSize, boolean isSearchContent) throws Exception {
        ManageableRepository currentRepository = this.repositoryService.getCurrentRepository();
        NodeLocation location = this.configurationService.getLivePortalsLocation(currentRepository.getConfiguration().getName());
        Session session = sessionProvider.getSession(location.getWorkspace(), currentRepository);
        if (queryCriteria.isSearchWebpage()) {
            session = sessionProvider.getSession("portal-system", WCMCoreUtils.getRepository());
        }
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        long startTime = System.currentTimeMillis();
        Query query = this.createQuery(queryCriteria, queryManager);
        String suggestion = this.getSpellSuggestion(queryCriteria.getKeyword(), currentRepository);
        AbstractPageList<ResultNode> pageList = null;
        log.debug((Object)("execute query: " + query.getStatement().toLowerCase()));
        pageList = PageListFactory.createPageList(query.getStatement(), session.getWorkspace().getName(), query.getLanguage(), IdentityConstants.SYSTEM.equals(session.getUserID()), new NodeFilter(isSearchContent, queryCriteria), new DataCreator(), pageSize, 0);
        long queryTime = System.currentTimeMillis() - startTime;
        pageList.setQueryTime(queryTime);
        pageList.setSpellSuggestion(suggestion);
        return pageList;
    }

    @Override
    public AbstractPageList<ResultNode> searchPageContents(SessionProvider sessionProvider, QueryCriteria queryCriteria, int pageSize, boolean isSearchContent) throws Exception {
        ManageableRepository currentRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession("portal-system", currentRepository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        long startTime = System.currentTimeMillis();
        Query query = this.createSearchPageQuery(queryCriteria, queryManager);
        String suggestion = this.getSpellSuggestion(queryCriteria.getKeyword(), currentRepository);
        log.debug((Object)("execute query: " + query.getStatement().toLowerCase()));
        AbstractPageList<ResultNode> pageList = PageListFactory.createPageList(query.getStatement(), session.getWorkspace().getName(), query.getLanguage(), true, new PageNodeFilter(), new PageDataCreator(), pageSize, 0);
        long queryTime = System.currentTimeMillis() - startTime;
        pageList.setQueryTime(queryTime);
        pageList.setSpellSuggestion(suggestion);
        return pageList;
    }

    private Query createSearchPageQuery(QueryCriteria queryCriteria, QueryManager queryManager) throws Exception {
        SQLQueryBuilder queryBuilder = new SQLQueryBuilder();
        List<String> mopPages = this.searchPageByTitle(queryCriteria.getSiteName(), queryCriteria.getKeyword());
        ArrayList<QueryCriteria.QueryProperty> queryProps = new ArrayList<QueryCriteria.QueryProperty>();
        for (String page : mopPages) {
            QueryCriteria.QueryProperty prop = new QueryCriteria.QueryProperty(queryCriteria);
            prop.setName("mop:page");
            prop.setValue(page);
            queryProps.add(prop);
        }
        QueryCriteria.QueryProperty prop = new QueryCriteria.QueryProperty(queryCriteria);
        prop.setName("exo:name");
        prop.setValue("mop:" + queryCriteria.getKeyword().toLowerCase());
        queryProps.add(prop);
        queryCriteria.setQueryMetadatas(queryProps.toArray(new QueryCriteria.QueryProperty[queryProps.size()]));
        this.mapQueryTypes(queryCriteria, queryBuilder);
        if (queryCriteria.isFulltextSearch()) {
            this.mapQueryPath(queryCriteria, queryBuilder);
            this.mapFulltextQueryTearm(queryCriteria, queryBuilder, AbstractQueryBuilder.LOGICAL.OR);
        } else {
            this.searchByNodeName(queryCriteria, queryBuilder);
        }
        this.mapCategoriesCondition(queryCriteria, queryBuilder);
        this.mapDatetimeRangeSelected(queryCriteria, queryBuilder);
        this.mapMetadataProperties(queryCriteria, queryBuilder, AbstractQueryBuilder.LOGICAL.OR);
        this.orderBy(queryCriteria, queryBuilder);
        String queryStatement = queryBuilder.createQueryStatement();
        Query query = queryManager.createQuery(queryStatement, "sql");
        return query;
    }

    private List<String> searchPageByTitle(String siteName, String keyword) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        ManageableRepository currentRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession("portal-system", currentRepository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.setSiteName(siteName);
        queryCriteria.setKeyword(keyword);
        queryCriteria.setSearchWebpage(true);
        Query query = this.createSearchPageByTitleQuery(queryCriteria, queryManager);
        log.debug((Object)("execute query: " + query.getStatement().toLowerCase()));
        List<String> pageList = PageListFactory.createPageList(query.getStatement(), session.getWorkspace().getName(), query.getLanguage(), true, new PageTitleDataCreator());
        return pageList;
    }

    private Query createSearchPageByTitleQuery(QueryCriteria queryCriteria, QueryManager queryManager) throws Exception {
        SQLQueryBuilder queryBuilder = new SQLQueryBuilder();
        queryBuilder.selectTypes(null);
        queryBuilder.fromNodeTypes(new String[]{"mop:page"});
        this.mapQueryPath(queryCriteria, queryBuilder);
        queryCriteria.setFulltextSearchProperty(new String[]{"gtn:name"});
        this.mapFulltextQueryTearm(queryCriteria, queryBuilder, AbstractQueryBuilder.LOGICAL.OR);
        String queryStatement = queryBuilder.createQueryStatement();
        Query query = queryManager.createQuery(queryStatement, "sql");
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSpellSuggestion(String checkingWord, ManageableRepository manageableRepository) throws Exception {
        String suggestion = null;
        Session session = null;
        try {
            session = manageableRepository.getSystemSession(manageableRepository.getConfiguration().getDefaultWorkspaceName());
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery("SELECT rep:spellcheck() FROM nt:base WHERE jcr:path like '/' AND SPELLCHECK('" + checkingWord + "')", "sql");
            RowIterator rows = query.execute().getRows();
            Value value = rows.nextRow().getValue("rep:spellcheck()");
            if (value != null) {
                suggestion = value.getString();
            }
        }
        catch (Exception e) {
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return suggestion;
    }

    private Query createQuery(QueryCriteria queryCriteria, QueryManager queryManager) throws Exception {
        SQLQueryBuilder queryBuilder = new SQLQueryBuilder();
        this.mapQueryTypes(queryCriteria, queryBuilder);
        if (queryCriteria.isFulltextSearch()) {
            this.mapQueryPath(queryCriteria, queryBuilder);
            this.mapFulltextQueryTearm(queryCriteria, queryBuilder, AbstractQueryBuilder.LOGICAL.OR);
        } else {
            this.searchByNodeName(queryCriteria, queryBuilder);
        }
        this.mapCategoriesCondition(queryCriteria, queryBuilder);
        this.mapDatetimeRangeSelected(queryCriteria, queryBuilder);
        this.mapMetadataProperties(queryCriteria, queryBuilder, AbstractQueryBuilder.LOGICAL.AND);
        this.orderBy(queryCriteria, queryBuilder);
        String queryStatement = queryBuilder.createQueryStatement();
        Query query = queryManager.createQuery(queryStatement, "sql");
        return query;
    }

    private void mapQueryPath(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) throws Exception {
        queryBuilder.setQueryPath(this.getSitePath(queryCriteria), AbstractQueryBuilder.PATH_TYPE.DECENDANTS);
    }

    private String getSitePath(QueryCriteria queryCriteria) throws Exception {
        String siteName = queryCriteria.getSiteName();
        if (queryCriteria.isSearchWebpage()) {
            if ("all".equals(siteName) || siteName == null || siteName.trim().length() == 0) {
                return "/production/mop:workspace/mop:portalsites";
            }
            return "/production/mop:workspace/mop:portalsites/mop:" + siteName;
        }
        String sitePath = null;
        if (siteName != null) {
            sitePath = this.livePortalManagerService.getPortalPathByName(siteName);
        } else {
            String repository = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            sitePath = this.configurationService.getLivePortalsLocation(repository).getPath();
        }
        return sitePath;
    }

    private void mapFulltextQueryTearm(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder, AbstractQueryBuilder.LOGICAL condition) {
        String keyword = queryCriteria.getKeyword();
        if (keyword == null || keyword.length() == 0) {
            return;
        }
        AbstractQueryBuilder.QueryTermHelper queryTermHelper = new AbstractQueryBuilder.QueryTermHelper();
        String queryTerm = null;
        keyword = keyword.replaceAll("'", "''");
        if (this.isEnabledFuzzySearch) {
            queryTerm = keyword.contains("*") || keyword.contains("?") || keyword.contains("~") ? queryTermHelper.contains(keyword).buildTerm() : queryTermHelper.contains(keyword).allowFuzzySearch(this.fuzzySearchIndex).buildTerm();
        } else {
            keyword = keyword.replace("~", "\\~");
            keyword = keyword.replace("*", "\\*");
            keyword = keyword.replace("?", "\\?");
            queryTerm = queryTermHelper.contains(keyword).buildTerm();
        }
        String[] props = queryCriteria.getFulltextSearchProperty();
        if (props == null || props.length == 0 || ".".equals(props[0])) {
            queryBuilder.contains(null, queryTerm, AbstractQueryBuilder.LOGICAL.NULL);
        } else {
            queryBuilder.contains(props[0], queryTerm, AbstractQueryBuilder.LOGICAL.NULL);
            for (int i = 1; i < props.length; ++i) {
                queryBuilder.contains(props[i], queryTerm, condition);
            }
        }
    }

    private void searchByNodeName(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) throws Exception {
        queryBuilder.queryByNodeName(this.getSitePath(queryCriteria), queryCriteria.getKeyword());
    }

    private void mapDatetimeRangeSelected(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) {
        QueryCriteria.DATE_RANGE_SELECTED selectedDateRange = queryCriteria.getDateRangeSelected();
        if (selectedDateRange == null) {
            return;
        }
        if (QueryCriteria.DATE_RANGE_SELECTED.CREATED == selectedDateRange) {
            QueryCriteria.DatetimeRange createdDateRange = queryCriteria.getCreatedDateRange();
            queryBuilder.betweenDates("exo:dateCreated", createdDateRange.getFromDate(), createdDateRange.getToDate(), AbstractQueryBuilder.LOGICAL.AND);
        } else if (QueryCriteria.DATE_RANGE_SELECTED.MODIFIDED == selectedDateRange) {
            QueryCriteria.DatetimeRange modifiedDateRange = queryCriteria.getLastModifiedDateRange();
            queryBuilder.betweenDates("exo:dateModified", modifiedDateRange.getFromDate(), modifiedDateRange.getToDate(), AbstractQueryBuilder.LOGICAL.AND);
        } else {
            if (QueryCriteria.DATE_RANGE_SELECTED.START_PUBLICATION == selectedDateRange) {
                throw new UnsupportedOperationException();
            }
            if (QueryCriteria.DATE_RANGE_SELECTED.END_PUBLICATION == selectedDateRange) {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void mapCategoriesCondition(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) {
        String[] categoryUUIDs = queryCriteria.getCategoryUUIDs();
        if (categoryUUIDs == null) {
            return;
        }
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND);
        queryBuilder.like("exo:category", categoryUUIDs[0], AbstractQueryBuilder.LOGICAL.NULL);
        if (categoryUUIDs.length > 1) {
            for (int i = 1; i < categoryUUIDs.length; ++i) {
                queryBuilder.like("exo:category", categoryUUIDs[i], AbstractQueryBuilder.LOGICAL.OR);
            }
        }
        queryBuilder.closeGroup();
    }

    private void mapMetadataProperties(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder, AbstractQueryBuilder.LOGICAL condition) {
        QueryCriteria.QueryProperty[] queryProperty = queryCriteria.getQueryMetadatas();
        if (queryProperty == null || queryProperty.length == 0) {
            return;
        }
        queryBuilder.openGroup(condition);
        queryBuilder.like(queryProperty[0].getName(), queryProperty[0].getValue(), AbstractQueryBuilder.LOGICAL.NULL);
        if (queryProperty.length > 1) {
            for (int i = 1; i < queryProperty.length; ++i) {
                queryBuilder.like(queryProperty[i].getName(), queryProperty[i].getValue(), AbstractQueryBuilder.LOGICAL.OR);
            }
        }
        queryBuilder.closeGroup();
    }

    private void mapQuerySpecificNodeTypes(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder, NodeTypeManager nodeTypeManager) throws Exception {
        String[] contentTypes = queryCriteria.getContentTypes();
        NodeType fistType = nodeTypeManager.getNodeType(contentTypes[0]);
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND);
        if (fistType.isMixin()) {
            queryBuilder.like("jcr:mixinTypes", contentTypes[0], AbstractQueryBuilder.LOGICAL.NULL);
        } else {
            queryBuilder.equal("jcr:primaryType", contentTypes[0], AbstractQueryBuilder.LOGICAL.NULL);
        }
        if (contentTypes.length > 1) {
            for (int i = 1; i < contentTypes.length; ++i) {
                String type = contentTypes[i];
                NodeType nodetype = nodeTypeManager.getNodeType(type);
                if (nodetype.isMixin()) {
                    queryBuilder.like("jcr:mixinTypes", type, AbstractQueryBuilder.LOGICAL.OR);
                    continue;
                }
                queryBuilder.equal("jcr:primaryType", type, AbstractQueryBuilder.LOGICAL.OR);
            }
        }
        queryBuilder.closeGroup();
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND_NOT);
        queryBuilder.like("jcr:mixinTypes", "exo:cssFile", AbstractQueryBuilder.LOGICAL.NULL);
        queryBuilder.like("jcr:mixinTypes", "exo:jsFile", AbstractQueryBuilder.LOGICAL.OR);
        queryBuilder.closeGroup();
    }

    private void mapQueryTypes(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) throws Exception {
        queryBuilder.selectTypes(null);
        queryBuilder.fromNodeTypes(queryCriteria.getNodeTypes());
        ManageableRepository currentRepository = this.repositoryService.getCurrentRepository();
        ExtendedNodeTypeManager manager = currentRepository.getNodeTypeManager();
        String[] contentTypes = queryCriteria.getContentTypes();
        if (contentTypes != null && contentTypes.length > 0 && queryCriteria.getKeyword() == null || queryCriteria.isSearchWebpage()) {
            this.mapQuerySpecificNodeTypes(queryCriteria, queryBuilder, (NodeTypeManager)manager);
            return;
        }
        List selectedNodeTypes = this.templateService.getDocumentTemplates();
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND);
        queryBuilder.equal("jcr:primaryType", "nt:resource", AbstractQueryBuilder.LOGICAL.NULL);
        queryBuilder.equal("jcr:mixinTypes", "exo:rss-enable", AbstractQueryBuilder.LOGICAL.OR);
        ArrayList<String> publicatioTypes = new ArrayList<String>(4);
        NodeTypeIterator iterator = manager.getAllNodeTypes();
        while (iterator.hasNext()) {
            NodeType nodeType = iterator.nextNodeType();
            if (nodeType.isNodeType("publication:webpagesPublication")) {
                publicatioTypes.add(nodeType.getName());
                continue;
            }
            if (!nodeType.isNodeType("exo:metadata")) continue;
            if (nodeType.isMixin()) {
                queryBuilder.equal("jcr:mixinTypes", nodeType.getName(), AbstractQueryBuilder.LOGICAL.OR);
                continue;
            }
            queryBuilder.equal("jcr:primaryType", nodeType.getName(), AbstractQueryBuilder.LOGICAL.OR);
        }
        for (String type : selectedNodeTypes) {
            NodeType nodetype = manager.getNodeType(type);
            if (nodetype.isMixin()) {
                queryBuilder.like("jcr:mixinTypes", type, AbstractQueryBuilder.LOGICAL.OR);
                continue;
            }
            queryBuilder.equal("jcr:primaryType", type, AbstractQueryBuilder.LOGICAL.OR);
        }
        queryBuilder.closeGroup();
        if (this.excludeMimeTypes.size() < 1) {
            return;
        }
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND_NOT);
        String[] mimetypes = this.excludeMimeTypes.toArray(new String[0]);
        queryBuilder.equal("jcr:mimeType", mimetypes[0], AbstractQueryBuilder.LOGICAL.NULL);
        for (int i = 1; i < mimetypes.length; ++i) {
            queryBuilder.equal("jcr:mimeType", mimetypes[i], AbstractQueryBuilder.LOGICAL.OR);
        }
        queryBuilder.closeGroup();
        queryBuilder.openGroup(AbstractQueryBuilder.LOGICAL.AND_NOT);
        queryBuilder.like("jcr:mixinTypes", "exo:cssFile", AbstractQueryBuilder.LOGICAL.NULL);
        queryBuilder.like("jcr:mixinTypes", "exo:jsFile", AbstractQueryBuilder.LOGICAL.OR);
        queryBuilder.closeGroup();
    }

    private void orderBy(QueryCriteria queryCriteria, SQLQueryBuilder queryBuilder) {
        queryBuilder.orderBy("jcr:score", AbstractQueryBuilder.ORDERBY.DESC);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PageTitleDataCreator
    implements SearchDataCreator<String> {
        @Override
        public String createData(Node node, Row row) {
            try {
                return node.getPath();
            }
            catch (RepositoryException e) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PageDataCreator
    implements SearchDataCreator<ResultNode> {
        private static HashSet<String> userNavigationUriList;

        public PageDataCreator() {
            userNavigationUriList = new HashSet();
        }

        @Override
        public ResultNode createData(Node node, Row row) {
            try {
                String userNaviUri;
                PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
                PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
                PortletRequest portletRequest = portletRequestContext.getRequest();
                String baseURI = portletRequest.getScheme() + "://" + portletRequest.getServerName() + ":" + String.format("%s", portletRequest.getServerPort()) + portalRequestContext.getPortalContextPath();
                if (node.isNodeType("mop:pagelink")) {
                    node = node.getParent();
                }
                if (node.isNodeType("gtn:language")) {
                    node = node.getParent().getParent();
                }
                if (userNavigationUriList.contains(userNaviUri = baseURI + "/" + PageDataCreator.getUserNavigationURI(node).toString())) {
                    return null;
                }
                userNavigationUriList.add(userNaviUri);
                return new ResultNode(node, row, userNaviUri);
            }
            catch (Exception e) {
                return null;
            }
        }

        public static StringBuilder getUserNavigationURI(Node node) throws RepositoryException {
            if (!node.isNodeType("mop:portalsites")) {
                StringBuilder builder = PageDataCreator.getUserNavigationURI(node.getParent());
                String name = node.getName();
                if ("mop:children".equals(name) || "mop:default".equals(name) || "mop:rootnavigation".equals(name)) {
                    return builder.append("");
                }
                if (builder.length() > 0) {
                    builder.append("/");
                }
                return builder.append(node.getName().replaceFirst("mop:", ""));
            }
            return new StringBuilder();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataCreator
    implements SearchDataCreator<ResultNode> {
        @Override
        public ResultNode createData(Node node, Row row) {
            try {
                return new ResultNode(node, row);
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static class PageNodeFilter
    implements NodeSearchFilter {
        public Node filterNodeToDisplay(Node node) {
            try {
                if (!(node.isNodeType("mop:navigation") || node.isNodeType("mop:pagelink") || node.isNodeType("gtn:language"))) {
                    return null;
                }
                return node;
            }
            catch (RepositoryException e) {
                return null;
            }
        }
    }

    public static class NodeFilter
    implements NodeSearchFilter {
        private boolean isSearchContent;
        private QueryCriteria queryCriteria;

        public NodeFilter(boolean isSearchContent, QueryCriteria queryCriteria) {
            this.isSearchContent = isSearchContent;
            this.queryCriteria = queryCriteria;
        }

        public Node filterNodeToDisplay(Node node) {
            try {
                Node displayNode = this.getNodeToCheckState(node);
                if (displayNode == null) {
                    return null;
                }
                if (this.isSearchContent) {
                    return displayNode;
                }
                NodeLocation nodeLocation = NodeLocation.getNodeLocationByNode((Node)displayNode);
                WCMComposer wcmComposer = (WCMComposer)WCMCoreUtils.getService(WCMComposer.class);
                HashMap<String, String> filters = new HashMap<String, String>();
                filters.put("filter-mode", this.queryCriteria.isLiveMode() ? "Live" : "Edit");
                return wcmComposer.getContent(nodeLocation.getWorkspace(), nodeLocation.getPath(), filters, WCMCoreUtils.getSystemSessionProvider());
            }
            catch (Exception e) {
                return null;
            }
        }

        protected Node getNodeToCheckState(Node node) throws Exception {
            String primaryNodeType;
            Node displayNode = node;
            if (node.getPath().contains("web contents/site artifacts")) {
                return null;
            }
            if (displayNode.isNodeType("nt:resource")) {
                displayNode = node.getParent();
            }
            if (displayNode.isNodeType("exo:htmlFile")) {
                Node parent = displayNode.getParent();
                if (this.queryCriteria.isSearchWebContent()) {
                    if (parent.isNodeType("exo:webContent")) {
                        return parent;
                    }
                    return null;
                }
                if (parent.isNodeType("exo:webContent")) {
                    return null;
                }
                return displayNode;
            }
            Object[] contentTypes = this.queryCriteria.getContentTypes();
            if (contentTypes != null && contentTypes.length > 0 && !ArrayUtils.contains((Object[])contentTypes, (Object)(primaryNodeType = displayNode.getPrimaryNodeType().getName()))) {
                return null;
            }
            return displayNode;
        }
    }
}

