/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.i18n;

import java.io.IOException;
import java.util.Locale;
import org.gatein.common.i18n.LocaleFormat;
import org.gatein.common.io.UndeclaredIOException;
import org.gatein.common.text.CharBuffer;
import org.gatein.common.text.CharWriter;
import org.gatein.common.util.ConversionException;
import org.gatein.common.util.NullConversionException;

public abstract class AbstractLocaleFormat
implements LocaleFormat {
    public Locale getLocale(String value) throws ConversionException {
        if (value == null) {
            throw new NullConversionException("No null locale value accepted");
        }
        return this.internalGetLocale(value);
    }

    public String toString(Locale locale) throws ConversionException {
        if (locale == null) {
            throw new NullConversionException("No null locale accepted");
        }
        return this.internalToString(locale);
    }

    public void write(Locale locale, CharWriter writer) throws IOException, ConversionException {
        if (locale == null) {
            throw new NullConversionException("No null locale accepted");
        }
        if (writer == null) {
            throw new IllegalArgumentException("No null writer accepted");
        }
        this.internalWrite(locale, writer);
    }

    protected abstract Locale internalGetLocale(String var1) throws ConversionException;

    protected String internalToString(Locale locale) throws ConversionException {
        try {
            CharBuffer buffer = new CharBuffer();
            this.internalWrite(locale, buffer);
            return buffer.asString();
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    protected abstract void internalWrite(Locale var1, CharWriter var2) throws IOException, ConversionException;
}

