/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.component.organization;

import org.exoplatform.platform.component.organization.EventType;
import org.exoplatform.platform.component.organization.OrganizationIntegrationService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirstLoginListener
extends Listener<ConversationRegistry, ConversationState> {
    private static final Log LOG = ExoLogger.getLogger(FirstLoginListener.class);
    private OrganizationIntegrationService organizationIntegrationService;

    public FirstLoginListener(OrganizationIntegrationService organizationIntegrationService) throws Exception {
        this.organizationIntegrationService = organizationIntegrationService;
    }

    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        String userId = ((ConversationState)event.getData()).getIdentity().getUserId();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Apply listeners for user" + userId));
        }
        this.organizationIntegrationService.syncUser(userId, EventType.ADDED.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("User listeners applied for " + userId));
        }
    }
}

