/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.chars;

import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import org.exoplatform.services.chars.CharsetSD;
import org.exoplatform.services.chars.StringDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharsDecoder {
    private static ThreadLocal<SoftReference<StringDecoder>> decoder = new ThreadLocal();

    private static StringDecoder deref(ThreadLocal<SoftReference<StringDecoder>> tl) {
        SoftReference<StringDecoder> sr = tl.get();
        if (sr == null) {
            return null;
        }
        return sr.get();
    }

    private static void set(ThreadLocal<SoftReference<StringDecoder>> tl, StringDecoder ob) {
        tl.set(new SoftReference<StringDecoder>(ob));
    }

    public static char[] decode(String charsetName, byte[] ba, int off, int len) throws Exception {
        String csn;
        StringDecoder sd = CharsDecoder.deref(decoder);
        String string = csn = charsetName == null ? "UTF-8" : charsetName;
        if (sd == null || !csn.equals(sd.requestedCharsetName()) && !csn.equals(sd.charsetName())) {
            sd = null;
            try {
                Charset cs = CharsDecoder.lookupCharset(csn);
                sd = cs != null ? new CharsetSD(cs, csn) : null;
            }
            catch (IllegalCharsetNameException x) {
                // empty catch block
            }
            CharsDecoder.set(decoder, sd);
        }
        return sd.decode(ba, off, len);
    }

    private static Charset lookupCharset(String csn) {
        if (Charset.isSupported(csn)) {
            try {
                return Charset.forName(csn);
            }
            catch (Exception x) {
                throw new Error(x);
            }
        }
        return null;
    }
}

