/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.opt;

import com.google.caja.ancillary.opt.ScopeInfo;
import com.google.caja.ancillary.opt.Use;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.WithStmt;
import com.google.caja.parser.js.scope.ScopeType;
import com.google.caja.parser.quasiliteral.Scope;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.Iterators;
import com.google.caja.util.SafeIdentifierMaker;
import com.google.caja.util.Sets;
import com.google.caja.util.SyntheticAttributeKey;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalVarRenamer {
    private final MessageQueue mq;
    private static final SyntheticAttributeKey<ScopeInfo> SCOPE = new SyntheticAttributeKey<ScopeInfo>(ScopeInfo.class, "scope");

    public LocalVarRenamer(MessageQueue mq) {
        this.mq = mq;
    }

    public Block optimize(Block program) {
        program = (Block)program.clone();
        LocalVarRenamer.attachScopes(AncestorChain.instance(program), new ScopeInfo(program, this.mq));
        LocalVarRenamer.assignNames(program.getAttributes().get(LocalVarRenamer.SCOPE).parent);
        LocalVarRenamer.rename(program);
        return program;
    }

    private static boolean attachScopes(AncestorChain<?> ac, ScopeInfo scope) {
        boolean infected = false;
        Object n = ac.node;
        n.getAttributes().set(SCOPE, scope);
        if (n instanceof FunctionConstructor) {
            FunctionConstructor fc = (FunctionConstructor)n;
            scope = new ScopeInfo(scope, Scope.fromFunctionConstructor(scope.s, fc));
            if (fc.getIdentifierName() != null) {
                scope.fns.add(ac.cast(FunctionConstructor.class));
            }
            n.getAttributes().set(SCOPE, scope);
        } else {
            if (n instanceof CatchStmt) {
                CatchStmt cs = (CatchStmt)n;
                scope = new ScopeInfo(scope, Scope.fromCatchStmt(scope.s, cs));
                scope.decls.add(AncestorChain.instance(ac, cs.getException()));
                cs.getException().getAttributes().set(SCOPE, scope);
                LocalVarRenamer.attachScopes(AncestorChain.instance(ac, cs.getBody()), scope);
                return false;
            }
            if (n instanceof Reference) {
                Reference r = (Reference)n;
                String string = r.getIdentifierName();
                Scope definingScope = scope.s.thatDefines(string);
                assert (definingScope != null || scope.s.isOuter(string)) : string;
                scope.uses.add(new Use(scope.withScope(definingScope), string));
                if ("eval".equals(string)) {
                    infected = true;
                }
                infected = infected || "eval".equals(string);
            } else if (n instanceof Declaration) {
                ScopeInfo declaring = scope;
                while (declaring.s.getType() == ScopeType.CATCH) {
                    declaring = declaring.parent;
                }
                declaring.decls.add(ac.cast(Declaration.class));
            } else if (n instanceof WithStmt) {
                infected = true;
            } else if (Operation.is(n, Operator.MEMBER_ACCESS)) {
                LocalVarRenamer.attachScopes(AncestorChain.instance(ac, n.children().get(0)), scope);
                return false;
            }
        }
        for (ParseTreeNode parseTreeNode : n.children()) {
            infected |= LocalVarRenamer.attachScopes(AncestorChain.instance(ac, parseTreeNode), scope);
        }
        if (infected) {
            scope.setDynamicUsePossible();
        }
        return infected;
    }

    private static void assignNames(ScopeInfo scope) {
        Set<Use> outerUses = Sets.newHashSet();
        LocalVarRenamer.addUsedOuters(scope, scope.depth, outerUses);
        Set<String> alreadyUsed = Sets.newHashSet(scope.mapping.values());
        for (Use u : outerUses) {
            String name;
            String string = name = u.definingScope != null ? u.definingScope.mapping.get(u.origName) : null;
            if (name == null) {
                name = u.origName;
            }
            alreadyUsed.add(name != null ? name : u.origName);
        }
        Iterator<String> namer = Iterators.filter(new SafeIdentifierMaker(), alreadyUsed);
        for (AncestorChain<Declaration> d : scope.decls) {
            String dName = ((Declaration)d.node).getIdentifierName();
            if (scope.mapping.containsKey(dName)) continue;
            String newName = scope.isDynamicUsePossible() ? dName : namer.next();
            scope.mapping.put(dName, newName);
        }
        for (ScopeInfo inner : scope.inners) {
            for (AncestorChain<FunctionConstructor> f : inner.fns) {
                FunctionConstructor fc = (FunctionConstructor)f.node;
                String fnName = fc.getIdentifierName();
                assert (fnName != null);
                if (inner.mapping.containsKey(fnName)) continue;
                String newName = f.parent.node instanceof FunctionDeclaration ? scope.mapping.get(fnName) : (inner.isDynamicUsePossible() ? fnName : namer.next());
                inner.mapping.put(fnName, newName);
            }
            if (!inner.isDynamicUsePossible()) {
                LocalVarRenamer.allocateExceptionNames(inner, namer);
            }
            LocalVarRenamer.assignNames(inner);
        }
    }

    private static void allocateExceptionNames(ScopeInfo scope, Iterator<String> namer) {
        if (scope.s.getType() == ScopeType.CATCH) {
            for (AncestorChain<Declaration> d : scope.decls) {
                String name = ((Declaration)d.node).getIdentifierName();
                if (scope.mapping.containsKey(name)) continue;
                scope.mapping.put(name, namer.next());
            }
            for (ScopeInfo inner : scope.inners) {
                LocalVarRenamer.allocateExceptionNames(inner, namer);
            }
        }
    }

    private static void addUsedOuters(ScopeInfo scope, int depth, Set<Use> used) {
        for (Use u : scope.uses) {
            if (u.definingScope != null && u.definingScope.depth >= depth) continue;
            used.add(u);
        }
        for (ScopeInfo c : scope.inners) {
            LocalVarRenamer.addUsedOuters(c, depth, used);
        }
    }

    private static void rename(ParseTreeNode n) {
        n.acceptPostOrder(new Visitor(){

            @Override
            public boolean visit(AncestorChain<?> ac) {
                Object n = ac.node;
                if (n instanceof Reference) {
                    if (!Operation.is(ac.parent.node, Operator.MEMBER_ACCESS) || n != ac.parent.node.children().get(1)) {
                        LocalVarRenamer.renameOne((Reference)n);
                    }
                } else if (n instanceof FunctionConstructor) {
                    FunctionConstructor fc = (FunctionConstructor)n;
                    if (fc.getIdentifierName() != null) {
                        LocalVarRenamer.renameOne(fc);
                    }
                } else if (n instanceof Declaration) {
                    LocalVarRenamer.renameOne((Declaration)n);
                }
                return true;
            }
        }, null);
    }

    private static void renameOne(MutableParseTreeNode n) {
        String newName;
        Scope s;
        Identifier id = (Identifier)n.children().get(0);
        String origName = id.getName();
        ScopeInfo u = n.getAttributes().get(SCOPE);
        Scope scope = s = n instanceof FunctionConstructor ? u.s : u.s.thatDefines(origName);
        if (s != null && !(newName = u.withScope((Scope)s).mapping.get(origName)).equals(origName)) {
            n.replaceChild(new Identifier(id.getFilePosition(), newName), id);
        }
    }
}

