/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.servlet.Content;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.util.Lists;
import com.google.caja.util.Pair;
import java.util.List;

final class Result {
    final int status;
    final Content content;
    final MessageQueue mq;
    final List<Pair<String, String>> headers = Lists.newArrayList();

    Result(int status, Content content, MessageQueue mq) {
        if (content == null) {
            throw new NullPointerException();
        }
        this.status = status;
        this.content = content;
        this.mq = mq;
        if (content.type != null) {
            this.headers.add(Pair.pair("Content-type", this.getContentType()));
        }
    }

    String getContentType() {
        if (this.content.type == null) {
            return null;
        }
        String contentType = this.content.type.mimeType;
        return this.content.type.isText ? contentType + "; charset=UTF-8" : contentType;
    }
}

