/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.InputElementSplitter;
import com.google.caja.lexer.JsTokenType;
import com.google.caja.lexer.Keyword;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Punctuation;
import com.google.caja.lexer.PunctuationTrie;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenStream;
import java.util.TreeMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsLexer
implements TokenStream<JsTokenType> {
    private TokenStream<JsTokenType> ts;
    private static PunctuationTrie<?> JAVASCRIPT_PUNCTUATOR;
    private static final Pattern TOKEN_BEFORE_REGEXP_LITERAL_RE;
    private static Pattern INTEGER_LITERAL_RE;

    public JsLexer(CharProducer producer) {
        this(producer, false);
    }

    public JsLexer(CharProducer producer, boolean isQuasiliteral) {
        this.ts = new WordClassifier(new InputElementSplitter(producer, JAVASCRIPT_PUNCTUATOR, isQuasiliteral));
    }

    @Override
    public boolean hasNext() throws ParseException {
        return this.ts.hasNext();
    }

    @Override
    public Token<JsTokenType> next() throws ParseException {
        return this.ts.next();
    }

    static boolean isRegexp(String previous) {
        if (TOKEN_BEFORE_REGEXP_LITERAL_RE.matcher(previous).find()) {
            char secondToLast;
            return previous.length() < 2 || !previous.endsWith(".") || (secondToLast = previous.charAt(previous.length() - 2)) < '0' || secondToLast > '9';
        }
        return false;
    }

    public static boolean isJsSpace(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '\u00a0': 
            case '\u2000': 
            case '\u2001': 
            case '\u2002': 
            case '\u2003': 
            case '\u2004': 
            case '\u2005': 
            case '\u2006': 
            case '\u2007': 
            case '\u2008': 
            case '\u2009': 
            case '\u200a': 
            case '\u200b': 
            case '\u3000': 
            case '\ufeff': {
                return true;
            }
        }
        return false;
    }

    public static boolean isJsLineSeparator(char ch) {
        switch (ch) {
            case '\n': 
            case '\r': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return false;
    }

    public static PunctuationTrie<?> getPunctuationTrie() {
        return JAVASCRIPT_PUNCTUATOR;
    }

    static {
        TreeMap<String, Object> javascriptPunctuation = new TreeMap<String, Object>();
        for (Punctuation p : Punctuation.values()) {
            javascriptPunctuation.put(p.toString(), null);
        }
        JAVASCRIPT_PUNCTUATOR = new PunctuationTrie(javascriptPunctuation);
        StringBuilder sb = new StringBuilder();
        String[] validPreceders = new String[]{"!", "!=", "!==", "#", "%", "%=", "&", "&&", "&&=", "&=", "(", "*", "*=", "+", "+=", ",", "-", "-=", ".", "...", "/", "/=", ":", "::", ";", "<", "<<", "<<=", "<=", "=", "==", "===", ">", ">=", ">>", ">>=", ">>>", ">>>=", "?", "[", "^", "^=", "{", "|", "|=", "||", "||=", "~", "abstract", "break", "case", "catch", "class", "const", "continue", "debugger", "default", "delete", "do", "else", "enum", "export", "extends", "final", "finally", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "native", "new", "package", "return", "static", "switch", "synchronized", "throw", "throws", "transient", "try", "typeof", "var", "void", "volatile", "while", "with"};
        sb.append("^(?:");
        for (int i = 0; i < validPreceders.length; ++i) {
            if (i != 0) {
                sb.append('|');
            }
            sb.append("(?:");
            sb.append(Pattern.quote(validPreceders[i]));
            sb.append(')');
        }
        sb.append(")$");
        TOKEN_BEFORE_REGEXP_LITERAL_RE = Pattern.compile(sb.toString());
        INTEGER_LITERAL_RE = Pattern.compile("^[+-]?((?:0[xX][0-9a-fA-F]*)|(?:0[0-7]*)|(?:[1-9][0-9]*))$");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WordClassifier
    implements TokenStream<JsTokenType> {
        private TokenStream<JsTokenType> stream;

        public WordClassifier(TokenStream<JsTokenType> stream) {
            this.stream = stream;
        }

        @Override
        public boolean hasNext() throws ParseException {
            return this.stream.hasNext();
        }

        @Override
        public Token<JsTokenType> next() throws ParseException {
            Token<JsTokenType> tok = this.stream.next();
            if (tok.type == JsTokenType.WORD) {
                char ch;
                JsTokenType type = JsTokenType.WORD;
                if (null != Keyword.fromString(tok.text)) {
                    type = JsTokenType.KEYWORD;
                } else if (0 < tok.text.length() && ((ch = tok.text.charAt(0)) >= '0' && ch <= '9' || '-' == ch || '+' == ch || '.' == ch)) {
                    if (INTEGER_LITERAL_RE.matcher(tok.text).matches()) {
                        type = JsTokenType.INTEGER;
                    } else {
                        String text = tok.text;
                        try {
                            Double.parseDouble(text);
                            type = JsTokenType.FLOAT;
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                }
                if (JsTokenType.WORD != type) {
                    tok = Token.instance(tok.text, type, tok.pos);
                }
            }
            return tok;
        }
    }
}

