/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.ParseTreeNode;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseTreeNodes {
    private static final Map<Class<? extends ParseTreeNode>, Constructor<?>> cloneCtorCache = Collections.synchronizedMap(new HashMap());

    public static <T extends ParseTreeNode> T newNodeInstance(Class<T> clazz, FilePosition pos, Object value, List<? extends ParseTreeNode> children) {
        Constructor<T> ctor = ParseTreeNodes.findCloneCtor(clazz);
        try {
            return (T)((ParseTreeNode)ctor.newInstance(pos, value, children));
        }
        catch (InstantiationException e) {
            throw new SomethingWidgyHappenedError(ParseTreeNodes.getCtorErrorMessage(ctor, value, children), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SomethingWidgyHappenedError(ParseTreeNodes.getCtorErrorMessage(ctor, value, children), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new SomethingWidgyHappenedError(ParseTreeNodes.getCtorErrorMessage(ctor, value, children), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new SomethingWidgyHappenedError(ParseTreeNodes.getCtorErrorMessage(ctor, value, children), (Throwable)e);
        }
    }

    public static boolean deepEquals(ParseTreeNode x, ParseTreeNode y) {
        if (x.getClass() == y.getClass() && (x.getValue() == null && y.getValue() == null || x.getValue() != null && x.getValue().equals(y.getValue())) && x.children().size() == y.children().size()) {
            for (int i = 0; i < x.children().size(); ++i) {
                if (ParseTreeNodes.deepEquals(x.children().get(i), y.children().get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static <T extends ParseTreeNode> Constructor<T> findCloneCtor(Class<T> clazz) {
        Constructor<T> ctor = ParseTreeNodes.fromCtorCache(clazz);
        if (ctor != null) {
            return ctor;
        }
        for (Constructor<T> ctor2 : ParseTreeNodes.declaredCtors(clazz)) {
            Class<?>[] parameterTypes = ctor2.getParameterTypes();
            if (parameterTypes.length != 3 || !FilePosition.class.equals(parameterTypes[0]) || !parameterTypes[2].isAssignableFrom(List.class) || !ParseTreeNodes.isReflectiveCtorAnnotated(ctor2)) continue;
            cloneCtorCache.put(clazz, ctor2);
            return ctor2;
        }
        throw new SomethingWidgyHappenedError("Cannot find clone ctor for node " + clazz);
    }

    private static final boolean isReflectiveCtorAnnotated(Constructor<?> ctor) {
        for (int i = 0; i < ctor.getDeclaredAnnotations().length; ++i) {
            if (!(ctor.getDeclaredAnnotations()[i] instanceof ParseTreeNode.ReflectiveCtor)) continue;
            return true;
        }
        return false;
    }

    private static <T extends ParseTreeNode> Constructor<T> fromCtorCache(Class<T> clazz) {
        return cloneCtorCache.get(clazz);
    }

    private static <T> List<Constructor<T>> declaredCtors(Class<T> clazz) {
        return Arrays.asList(clazz.getDeclaredConstructors());
    }

    private static String getCtorErrorMessage(Constructor<? extends ParseTreeNode> ctor, Object value, List<? extends ParseTreeNode> children) {
        return "Error calling ctor " + ctor.toString() + " with value = " + value + " (" + (value == null ? "" : value.getClass()) + ")" + " with children = " + children + " (" + (children == null ? "" : children.getClass()) + ")";
    }
}

