/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.parser.quasiliteral.QuasiNode;
import com.google.caja.util.Lists;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MultiPropertyQuasi
extends QuasiNode {
    private final String keyIdentifier;
    private final String valueIdentifier;

    MultiPropertyQuasi(String keyIdentifier, String valueIdentifier) {
        super(new QuasiNode[0]);
        this.keyIdentifier = keyIdentifier;
        this.valueIdentifier = valueIdentifier;
    }

    @Override
    protected boolean consumeSpecimens(List<ParseTreeNode> specimens, Map<String, ParseTreeNode> bindings) {
        List<StringLiteral> keyList = Lists.newArrayList();
        List<Expression> valueList = Lists.newArrayList();
        for (ParseTreeNode quasi : specimens) {
            if (!(quasi instanceof ValueProperty)) {
                return false;
            }
            ValueProperty prop = (ValueProperty)quasi;
            keyList.add(prop.getPropertyNameNode());
            valueList.add(prop.getValueExpr());
        }
        if (MultiPropertyQuasi.putIfDeepEquals(bindings, this.keyIdentifier, new ParseTreeNodeContainer(keyList)) && MultiPropertyQuasi.putIfDeepEquals(bindings, this.valueIdentifier, new ParseTreeNodeContainer(valueList))) {
            specimens.clear();
            return true;
        }
        return false;
    }

    @Override
    protected boolean createSubstitutes(List<ParseTreeNode> substitutes, Map<String, ParseTreeNode> bindings) {
        if (bindings.containsKey(this.keyIdentifier) && bindings.containsKey(this.valueIdentifier)) {
            ParseTreeNode keyNode = bindings.get(this.keyIdentifier);
            ParseTreeNode valueNode = bindings.get(this.valueIdentifier);
            assert (keyNode.children().size() == valueNode.children().size());
            List<ValueProperty> children = Lists.newArrayList();
            for (int i = 0; i < keyNode.children().size(); ++i) {
                children.add(new ValueProperty((StringLiteral)keyNode.children().get(i), (Expression)valueNode.children().get(i)));
            }
            substitutes.addAll(children);
            return true;
        }
        return false;
    }
}

