/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.css.CssParser;
import com.google.caja.parser.html.Dom;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.Parser;
import com.google.caja.plugin.Config;
import com.google.caja.plugin.DataUriFetcher;
import com.google.caja.plugin.FileSystemUriFetcher;
import com.google.caja.plugin.FileSystemUriPolicy;
import com.google.caja.plugin.PipelineMaker;
import com.google.caja.plugin.Planner;
import com.google.caja.plugin.PluginCompiler;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.plugin.UriToFile;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.render.SourceSnippetRenderer;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.caja.util.Callback;
import com.google.caja.util.CapturingReader;
import com.google.caja.util.Charsets;
import com.google.caja.util.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginCompilerMain {
    private final MessageQueue mq;
    private final MessageContext mc;
    private final Map<InputSource, CapturingReader> originalInputs = Maps.newHashMap();
    private final Config config = new Config(this.getClass(), System.err, "Cajoles HTML, CSS, and JS files to JS.");
    private final Callback<IOException> exHandler = new Callback<IOException>(){

        @Override
        public void handle(IOException ex) {
            PluginCompilerMain.this.mq.addMessage((MessageTypeInt)MessageType.IO_ERROR, MessagePart.Factory.valueOf(ex.toString()));
        }
    };

    private PluginCompilerMain() {
        this.mq = new SimpleMessageQueue();
        this.mc = new MessageContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(String[] argv) {
        if (!this.config.processArguments(argv)) {
            return -1;
        }
        boolean success = false;
        MessageContext mc = null;
        CajoledModule compiledJsOutput = null;
        Node compiledDomOutput = null;
        String compiledHtmlOutput = null;
        File fileLimitAncestor = this.config.getFetcherBase();
        File jsOutputDest = this.config.getOutputJsFile();
        File htmlOutputDest = this.config.getOutputHtmlFile();
        try {
            Set<String> fUrls;
            UriPolicy policy;
            UriFetcher fetcher;
            try {
                if (fileLimitAncestor != null) {
                    UriToFile u2f = new UriToFile(fileLimitAncestor);
                    fetcher = UriFetcher.ChainingUriFetcher.make(new DataUriFetcher(), new CachingUriFetcher(u2f));
                    policy = new FileSystemUriPolicy(u2f);
                } else {
                    fetcher = new DataUriFetcher();
                    policy = UriPolicy.DENY_ALL;
                }
            }
            catch (IOException e) {
                fetcher = new DataUriFetcher();
                policy = UriPolicy.DENY_ALL;
            }
            final Set<String> lUrls = this.config.getLinkableUris();
            if (!lUrls.isEmpty()) {
                final UriPolicy prePolicy = policy;
                policy = new UriPolicy(){

                    @Override
                    public String rewriteUri(ExternalReference u, UriPolicy.UriEffect effect, UriPolicy.LoaderType loader, Map<String, ?> hints) {
                        String uri = u.getUri().toString();
                        if (lUrls.contains(uri)) {
                            return uri;
                        }
                        return prePolicy.rewriteUri(u, effect, loader, hints);
                    }
                };
            }
            if (!(fUrls = this.config.getFetchableUris()).isEmpty()) {
                fetcher = UriFetcher.ChainingUriFetcher.make(fetcher, new UriFetcher(){

                    public FetchedData fetch(ExternalReference ref, String mimeType) throws UriFetcher.UriFetchException {
                        String uri = ref.getUri().toString();
                        if (!fUrls.contains(uri)) {
                            throw new UriFetcher.UriFetchException(ref, mimeType);
                        }
                        try {
                            return FetchedData.fromConnection(new URL(uri).openConnection());
                        }
                        catch (IOException ex) {
                            throw new UriFetcher.UriFetchException(ref, mimeType, ex);
                        }
                    }
                });
            }
            PluginMeta meta = new PluginMeta(fetcher, policy);
            meta.setIdClass(this.config.getIdClass());
            meta.setEnableES53(this.config.getES53());
            PluginCompiler compiler = new PluginCompiler(BuildInfo.getInstance(), meta, this.mq);
            Planner.PlanState preconds = compiler.getPreconditions();
            Planner.PlanState goals = htmlOutputDest == null ? compiler.getGoals().without(PipelineMaker.HTML_SAFE_STATIC).with(PipelineMaker.JS) : compiler.getGoals();
            compiler.setPreconditions(this.config.preconditions(preconds));
            compiler.setGoals(this.config.goals(goals));
            mc = compiler.getMessageContext();
            compiler.setCssSchema(this.config.getCssSchema(this.mq));
            compiler.setHtmlSchema(this.config.getHtmlSchema(this.mq));
            boolean bl = success = this.parseInputs(this.config.getInputUris(), compiler) && compiler.run();
            if (success) {
                compiledJsOutput = compiler.getJavascript();
                compiledDomOutput = compiler.getStaticHtml();
                String string = compiledHtmlOutput = compiledDomOutput != null ? Nodes.render(compiledDomOutput) : "";
            }
            if (mc == null) {
                mc = new MessageContext();
            }
        }
        catch (Throwable throwable) {
            MessageLevel maxMessageLevel;
            if (mc == null) {
                mc = new MessageContext();
            }
            success &= MessageLevel.ERROR.compareTo(maxMessageLevel = PluginCompilerMain.dumpMessages(this.mq, mc, System.err)) > 0;
            throw throwable;
        }
        MessageLevel maxMessageLevel = PluginCompilerMain.dumpMessages(this.mq, mc, System.err);
        boolean bl = MessageLevel.ERROR.compareTo(maxMessageLevel) > 0;
        if (success &= bl) {
            if (jsOutputDest != null) {
                this.writeFile(jsOutputDest, compiledJsOutput);
            } else {
                StringBuilder compiledJsOutputBuf = new StringBuilder();
                compiledJsOutputBuf.append("<script>");
                try {
                    this.writeFile(compiledJsOutputBuf, compiledJsOutput);
                }
                catch (IOException ex) {
                    throw new SomethingWidgyHappenedError(ex);
                }
                compiledJsOutputBuf.append("</script>");
                compiledHtmlOutput = compiledHtmlOutput + compiledJsOutputBuf;
            }
            if (htmlOutputDest != null) {
                this.writeFile(htmlOutputDest, compiledHtmlOutput);
            }
        } else {
            if (jsOutputDest != null) {
                jsOutputDest.delete();
            }
            if (htmlOutputDest != null) {
                htmlOutputDest.delete();
            }
        }
        return success ? 0 : -1;
    }

    private boolean parseInputs(Collection<URI> inputs, PluginCompiler pluginc) {
        boolean parsePassed = true;
        for (URI input : inputs) {
            try {
                ParseTreeNode parseTree = this.parseInput(input);
                if (null == parseTree) continue;
                pluginc.addInput(parseTree, input);
            }
            catch (ParseException ex) {
                ex.toMessageQueue(this.mq);
                parsePassed = false;
            }
            catch (IOException ex) {
                this.mq.addMessage((MessageTypeInt)MessageType.IO_ERROR, MessagePart.Factory.valueOf(ex.toString()));
                parsePassed = false;
            }
        }
        return parsePassed;
    }

    private ParseTreeNode parseInput(URI input) throws IOException, ParseException {
        InputSource is = new InputSource(input);
        this.mc.addInputSource(is);
        CharProducer cp = CharProducer.Factory.create(this.createReader(is, input.toURL().openStream()), is);
        return PluginCompilerMain.parseInput(is, cp, this.mq);
    }

    static ParseTreeNode parseInput(InputSource is, CharProducer cp, MessageQueue mq) throws ParseException {
        AbstractParseTreeNode input;
        String path = is.getUri().getPath();
        if (path.endsWith(".js")) {
            JsLexer lexer = new JsLexer(cp);
            JsTokenQueue tq = new JsTokenQueue(lexer, is);
            if (tq.isEmpty()) {
                return null;
            }
            Parser p = new Parser(tq, mq);
            input = p.parse();
            tq.expectEmpty();
        } else if (path.endsWith(".css")) {
            TokenQueue<CssTokenType> tq = CssParser.makeTokenQueue(cp, mq, false);
            if (tq.isEmpty()) {
                return null;
            }
            CssParser p = new CssParser(tq, mq, MessageLevel.WARNING);
            input = p.parseStyleSheet();
            tq.expectEmpty();
        } else if (path.endsWith(".html") || path.endsWith(".xhtml") || !cp.isEmpty() && cp.getBuffer()[cp.getOffset()] == '<') {
            DomParser p = new DomParser(new HtmlLexer(cp), false, is, mq);
            if (p.getTokenQueue().isEmpty()) {
                return null;
            }
            input = new Dom(p.parseFragment());
            p.getTokenQueue().expectEmpty();
        } else {
            throw new SomethingWidgyHappenedError("Can't classify input " + is);
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File outputHtmlFile, String compiledHtmlOutput) {
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputHtmlFile), Charsets.UTF_8);
            try {
                out.append(compiledHtmlOutput);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        catch (IOException ex) {
            this.exHandler.handle(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File f, CajoledModule module) {
        if (module == null) {
            return;
        }
        Writer out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(f), Charsets.UTF_8);
            this.writeFile(out, module);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void writeFile(Appendable out, CajoledModule module) throws IOException {
        if (this.config.renderer() == Config.SourceRenderMode.DEBUGGER) {
            this.writeFileWithDebug(out, module);
        } else {
            this.writeFileNonDebug(out, module);
        }
    }

    private void writeFileNonDebug(Appendable out, CajoledModule module) throws IOException {
        TokenConsumer tc;
        switch (this.config.renderer()) {
            case PRETTY: {
                tc = module.makeRenderer(out, this.exHandler);
                break;
            }
            case MINIFY: {
                tc = new JsMinimalPrinter(new Concatenator(out, this.exHandler));
                break;
            }
            case SIDEBYSIDE: {
                tc = new SourceSnippetRenderer(this.buildOriginalInputCharSequences(), this.mc, PluginCompilerMain.makeRenderContext(new Concatenator(out, this.exHandler)));
                break;
            }
            default: {
                throw new SomethingWidgyHappenedError("Unrecognized renderer: " + (Object)((Object)this.config.renderer()));
            }
        }
        RenderContext rc = PluginCompilerMain.makeRenderContext(tc);
        module.render(rc);
        tc.noMoreTokens();
        out.append('\n');
    }

    private void writeFileWithDebug(Appendable out, CajoledModule module) throws IOException {
        module.renderWithDebugSymbols(this.buildOriginalInputCharSequences(), PluginCompilerMain.makeRenderContext(new Concatenator(out, this.exHandler)));
    }

    private static RenderContext makeRenderContext(TokenConsumer tc) {
        return new RenderContext(tc).withAsciiOnly(true).withEmbeddable(true);
    }

    static MessageLevel dumpMessages(MessageQueue mq, MessageContext mc, Appendable out) {
        MessageLevel maxLevel = MessageLevel.values()[0];
        for (Message m : mq.getMessages()) {
            MessageLevel level = m.getMessageLevel();
            if (maxLevel.compareTo(level) >= 0) continue;
            maxLevel = level;
        }
        MessageLevel ignoreLevel = null;
        if (maxLevel.compareTo(MessageLevel.LINT) < 0) {
            ignoreLevel = MessageLevel.LOG;
        }
        try {
            for (Message m : mq.getMessages()) {
                MessageLevel level = m.getMessageLevel();
                if (ignoreLevel != null && level.compareTo(ignoreLevel) <= 0) continue;
                String levelName = level.name();
                out.append(levelName);
                if (levelName.length() < 7) {
                    out.append("       ".substring(levelName.length()));
                }
                out.append(": ");
                m.format(mc, out);
                out.append("\n");
                if (maxLevel.compareTo(level) >= 0) continue;
                maxLevel = level;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return maxLevel;
    }

    private Reader createReader(InputSource is, InputStream stream) {
        InputStreamReader isr = new InputStreamReader(stream, Charsets.UTF_8);
        if (this.config.renderer() == Config.SourceRenderMode.SIDEBYSIDE || this.config.renderer() == Config.SourceRenderMode.DEBUGGER) {
            CapturingReader cr = new CapturingReader(isr);
            this.originalInputs.put(is, cr);
            return cr;
        }
        return isr;
    }

    private Map<InputSource, CharSequence> buildOriginalInputCharSequences() throws IOException {
        Map<InputSource, CharSequence> results = Maps.newHashMap();
        for (InputSource is : this.originalInputs.keySet()) {
            results.put(is, this.originalInputs.get(is).getCapture());
        }
        return results;
    }

    public static void main(String[] args) {
        int exitCode;
        try {
            PluginCompilerMain main = new PluginCompilerMain();
            exitCode = main.run(args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            exitCode = -1;
        }
        try {
            System.exit(exitCode);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private class CachingUriFetcher
    extends FileSystemUriFetcher {
        public CachingUriFetcher(UriToFile u2f) {
            super(u2f);
        }

        protected Reader newReader(File f) throws FileNotFoundException {
            return PluginCompilerMain.this.createReader(new InputSource(f), new FileInputStream(f));
        }

        protected InputStream newInputStream(File f) throws FileNotFoundException {
            return new FileInputStream(f);
        }
    }
}

