/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.plugin.templates.JsConcatenator;
import com.google.caja.util.CajaTestCase;

public class JsConcatenatorTest
extends CajaTestCase {
    public final void testEmptyAppender() throws ParseException {
        this.assertConcatenate(" '' ", new String[0]);
    }

    public final void testLiterals() throws ParseException {
        this.assertConcatenate(" 'foo' ", " 'foo' ");
        this.assertConcatenate(" '3' ", "3");
        this.assertConcatenate(" '-1' ", "-1");
        this.assertConcatenate(" '100000000000000000000' ", "1e20");
        this.assertConcatenate(" '1e+21' ", "1e21");
        this.assertConcatenate(" '-1e+21' ", "-1e21");
        this.assertConcatenate(" '0' ", "0");
        this.assertConcatenate(" 'true' ", "true");
        this.assertConcatenate(" 'false' ", "false");
        this.assertConcatenate(" 'null' ", "null");
    }

    public final void testMoreSingleAppends() throws ParseException {
        this.assertConcatenate(" a ? 'foo' : 'bar' ", " a ? 'foo' : 'bar' ");
        this.assertConcatenate(" rnd() ? '' + new Date : '' ", "rnd() ? new Date : '' ");
        this.assertConcatenate(" '' + (x || 'foo') ", " x || 'foo' ");
        this.assertConcatenate(" '' + ['foo'] ", " ['foo'] ");
        this.assertConcatenate(" x = f(), '' + x * x ", " x = f(), x * x ");
        this.assertConcatenate(" x = f(), '' + x * x ", " x = f(), '' + x * x ");
    }

    public final void testDecomposing() throws ParseException {
        this.assertConcatenate(" a + 'b' + c ", "a", "'b'", "c");
        this.assertConcatenate(" a + 'b' + c ", "a + 'b'", "c");
        this.assertConcatenate(" a + 'b' + c ", "a", "'b' + c");
        this.assertConcatenate(" a + 'b' + c ", "a + ('b' + c)");
        this.assertConcatenate(" a + 'b' + c ", "(a + 'b') + c");
        this.assertConcatenate(" a + 'b' + c ", " '' + a + 'b' + c");
    }

    public final void testNumericAdditionUnchanged() throws ParseException {
        this.assertConcatenate(" '' + (a + b + c) ", " a + b + c ");
        this.assertConcatenate(" '' + a + b + c ", "a", "b", "c");
    }

    public final void testCollapsing() throws ParseException {
        this.assertConcatenate(" 'Hello, ' + world + '!' ", " 'Hello' ", " ', ' ", "world", " '!' ");
    }

    public final void testStringForcing() throws ParseException {
        this.assertConcatenate("(rand() ? a : 'b') + 'foo' + bar", " rand() ? a : 'b' ", " 'foo' ", "bar");
        this.assertConcatenate("(rand() ? '' + a : 'b') + foo + bar", " rand() ? a : 'b' ", "foo", "bar");
        this.assertConcatenate("new Date(year, month, day) + message", "new Date(year, month, day)", "message");
        this.assertConcatenate("'' + new Date(year, month, day)", "new Date(year, month, day)");
        this.assertConcatenate(" '' + (+(new Date)) ", "+(new Date)");
    }

    public final void testSideEffects() throws ParseException {
        this.assertConcatenate(" foo(), '' ", "void foo()");
        this.assertConcatenate(" y(), 'xz' ", " 'x' ", " void y() ", " 'z' ");
        this.assertConcatenate(" y(), w(), 'xz' ", " 'x' ", " void y() ", " 'z' ", " void w() ");
        this.assertConcatenate("(y(), 'x') + z() + (w(), '')", " 'x' ", " void y() ", " z() ", " void w() ");
        this.assertConcatenate(" x(), '' + y() ", "void x()", "y()");
        this.assertConcatenate(" x() + (y(), '') ", "x()", "void y()");
    }

    private void assertConcatenate(String goldenJs, String ... parts) throws ParseException {
        JsConcatenator concat = new JsConcatenator();
        for (String part : parts) {
            Expression e = this.jsExpr(this.fromString(part));
            if (Operation.is((ParseTreeNode)e, Operator.VOID)) {
                concat.forSideEffect(((Operation)e).children().get(0));
                continue;
            }
            concat.append(e);
        }
        JsConcatenatorTest.assertEquals((String)JsConcatenatorTest.render(this.jsExpr(this.fromString(goldenJs))), (String)JsConcatenatorTest.render(concat.toExpression(true)));
    }
}

