/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.CajoledModule;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.IntegerLiteral;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.parser.js.ValueProperty;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.RenderContext;
import com.google.caja.service.CajolingService;
import com.google.caja.service.ContentHandler;
import com.google.caja.service.ContentHandlerArgs;
import com.google.caja.service.ContentTypeCheck;
import com.google.caja.service.UnsupportedContentTypeException;
import com.google.caja.util.Callback;
import com.google.caja.util.Lists;
import com.google.caja.util.Pair;
import com.google.caja.util.Strings;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCajolingHandler
implements ContentHandler {
    protected final BuildInfo buildInfo;
    protected final UriFetcher uriFetcher;
    protected final String hostedService;

    public AbstractCajolingHandler(BuildInfo buildInfo, String hostedService, UriFetcher uriFetcher) {
        this.buildInfo = buildInfo;
        this.hostedService = hostedService;
        this.uriFetcher = uriFetcher != null ? uriFetcher : UriFetcher.NULL_NETWORK;
    }

    protected UriPolicy makeUriPolicy(final ContentHandlerArgs args) {
        return new UriPolicy(){

            @Override
            public String rewriteUri(ExternalReference u, UriPolicy.UriEffect effect, UriPolicy.LoaderType loader, Map<String, ?> hints) {
                String protocol;
                boolean sandboxLinksAndImages;
                URI uri = u.getUri();
                boolean bl = sandboxLinksAndImages = !"false".equals(args.get("sext"));
                if ((effect == UriPolicy.UriEffect.NEW_DOCUMENT && loader == UriPolicy.LoaderType.UNSANDBOXED || effect == UriPolicy.UriEffect.SAME_DOCUMENT && loader == UriPolicy.LoaderType.SANDBOXED) && !sandboxLinksAndImages && ("http".equals(protocol = Strings.toLowerCase(uri.getScheme())) || "https".equals(protocol))) {
                    return uri.toString();
                }
                if (AbstractCajolingHandler.this.hostedService != null) {
                    return AbstractCajolingHandler.this.hostedService + "?url=" + UriUtil.encode(uri.toString()) + "&effect=" + (Object)((Object)effect) + "&loader=" + (Object)((Object)loader) + "&sext=" + sandboxLinksAndImages;
                }
                return null;
            }
        };
    }

    @Override
    public abstract boolean canHandle(URI var1, CajolingService.Transform var2, List<CajolingService.Directive> var3, String var4, String var5, ContentTypeCheck var6);

    @Override
    public abstract Pair<String, String> apply(URI var1, CajolingService.Transform var2, List<CajolingService.Directive> var3, ContentHandlerArgs var4, String var5, String var6, ContentTypeCheck var7, FetchedData var8, OutputStream var9, MessageQueue var10) throws UnsupportedContentTypeException;

    protected void renderAsHtml(Document doc, Node staticHtml, CajoledModule javascript, Expression moduleCallback, Appendable output) throws IOException {
        if (staticHtml != null) {
            output.append(Nodes.render(staticHtml));
        }
        if (javascript != null) {
            String htmlNs = "http://www.w3.org/1999/xhtml";
            Element script = doc.createElementNS(htmlNs, "script");
            script.setAttributeNS(htmlNs, "type", "text/javascript");
            script.appendChild(doc.createTextNode(this.renderJavascript(javascript, moduleCallback)));
            output.append(Nodes.render(script));
        }
    }

    private static StringLiteral lit(String s) {
        return StringLiteral.valueOf(FilePosition.UNKNOWN, s);
    }

    private static IntegerLiteral lit(int i) {
        return new IntegerLiteral(FilePosition.UNKNOWN, i);
    }

    private static ArrayConstructor arr(List<? extends Expression> items) {
        return new ArrayConstructor(FilePosition.UNKNOWN, items);
    }

    private static ObjectConstructor obj(List<? extends ValueProperty> props) {
        return new ObjectConstructor(FilePosition.UNKNOWN, props);
    }

    private static ValueProperty prop(String key, Expression e) {
        return new ValueProperty(FilePosition.UNKNOWN, AbstractCajolingHandler.lit(key), e);
    }

    protected void renderAsJSON(Node staticHtml, CajoledModule javascript, Expression moduleCallback, MessageQueue mq, Appendable output) throws IOException {
        List<ValueProperty> props = Lists.newArrayList();
        if (staticHtml != null) {
            props.add(AbstractCajolingHandler.prop("html", AbstractCajolingHandler.lit(Nodes.render(staticHtml))));
        }
        if (javascript != null) {
            props.add(AbstractCajolingHandler.prop("js", AbstractCajolingHandler.lit(this.renderJavascript(javascript, moduleCallback))));
        }
        if (mq.hasMessageAtLevel(MessageLevel.LOG)) {
            List<ObjectConstructor> messages = Lists.newArrayList();
            for (Message m : mq.getMessages()) {
                messages.add(AbstractCajolingHandler.obj(Arrays.asList(AbstractCajolingHandler.prop("level", AbstractCajolingHandler.lit(m.getMessageLevel().ordinal())), AbstractCajolingHandler.prop("name", AbstractCajolingHandler.lit(m.getMessageLevel().name())), AbstractCajolingHandler.prop("type", AbstractCajolingHandler.lit(m.getMessageType().name())), AbstractCajolingHandler.prop("message", AbstractCajolingHandler.lit(m.toString())))));
            }
            props.add(AbstractCajolingHandler.prop("messages", AbstractCajolingHandler.arr(messages)));
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class IOCallback
        implements Callback<IOException> {
            IOException ex;

            IOCallback() {
            }

            @Override
            public void handle(IOException e) {
                if (this.ex != null) {
                    this.ex = e;
                }
            }
        }
        IOCallback callback = new IOCallback();
        RenderContext rc = new RenderContext(new JsMinimalPrinter(new Concatenator(output, callback))).withJson(true);
        AbstractCajolingHandler.obj(props).render(rc);
        rc.getOut().noMoreTokens();
        if (callback.ex != null) {
            throw callback.ex;
        }
    }

    protected void renderAsJavascript(CajoledModule javascript, Expression moduleCallback, Appendable output) throws IOException {
        if (null != javascript) {
            output.append(this.renderJavascript(javascript, moduleCallback));
        }
    }

    protected String renderJavascript(CajoledModule javascript, Expression moduleCallback) {
        StringBuilder jsOut = new StringBuilder();
        RenderContext rc = new RenderContext(new JsMinimalPrinter(new Concatenator(jsOut))).withEmbeddable(true);
        javascript.render(moduleCallback, rc);
        rc.getOut().noMoreTokens();
        return jsOut.toString();
    }
}

