/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.service;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.opensocial.DefaultGadgetRewriter;
import com.google.caja.opensocial.GadgetRewriteException;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.service.CajolingService;
import com.google.caja.service.ContentHandler;
import com.google.caja.service.ContentHandlerArgs;
import com.google.caja.service.ContentTypeCheck;
import com.google.caja.service.UnsupportedContentTypeException;
import com.google.caja.util.Charsets;
import com.google.caja.util.Pair;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetHandler
implements ContentHandler {
    private final BuildInfo buildInfo;
    private final UriFetcher uriFetcher;

    public GadgetHandler(BuildInfo buildInfo, UriFetcher uriFetcher) {
        this.buildInfo = buildInfo;
        this.uriFetcher = uriFetcher;
    }

    @Override
    public boolean canHandle(URI uri, CajolingService.Transform transform, List<CajolingService.Directive> directives, String inputContentType, String outputContentType, ContentTypeCheck checker) {
        return checker.check("application/xml", inputContentType) && checker.check(outputContentType, "text/javascript");
    }

    @Override
    public Pair<String, String> apply(URI uri, CajolingService.Transform trans, List<CajolingService.Directive> d, ContentHandlerArgs args, String inputContentType, String outputContentType, ContentTypeCheck checker, FetchedData input, OutputStream response, MessageQueue mq) throws UnsupportedContentTypeException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(response, Charsets.UTF_8);
            this.cajoleGadget(uri, input.getTextualContent(), writer, mq);
            writer.flush();
            return Pair.pair("text/javascript", Charsets.UTF_8.name());
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new UnsupportedContentTypeException();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new UnsupportedContentTypeException();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UnsupportedContentTypeException();
        }
        catch (GadgetRewriteException e) {
            e.printStackTrace();
            throw new UnsupportedContentTypeException();
        }
    }

    private void cajoleGadget(URI inputUri, CharProducer cajaInput, Appendable output, MessageQueue mq) throws ParseException, GadgetRewriteException, IOException {
        DefaultGadgetRewriter rewriter = new DefaultGadgetRewriter(this.buildInfo, mq);
        UriFetcher fetcher = this.uriFetcher;
        if (fetcher == null) {
            fetcher = UriFetcher.NULL_NETWORK;
        }
        UriPolicy policy = new UriPolicy(){

            @Override
            public String rewriteUri(ExternalReference u, UriPolicy.UriEffect effect, UriPolicy.LoaderType loader, Map<String, ?> hint) {
                return "http://localhost:8887/?url=" + UriUtil.encode(u.getUri().toString()) + "&effect=" + (Object)((Object)effect) + "&loader=" + (Object)((Object)loader);
            }
        };
        rewriter.rewrite(inputUri, cajaInput, fetcher, policy, "canvas", output);
    }
}

