/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Iterators {
    public static <T> Iterator<T> filter(final Iterator<T> underlying, final Set<T> forbidden) {
        return new Iterator<T>(){
            boolean hasNext;
            T next;

            @Override
            public boolean hasNext() {
                this.fetch();
                return this.hasNext;
            }

            @Override
            public T next() {
                this.fetch();
                if (!this.hasNext) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.hasNext = false;
                this.next = null;
                return result;
            }

            @Override
            public void remove() {
                underlying.remove();
            }

            private void fetch() {
                if (this.hasNext) {
                    return;
                }
                while (underlying.hasNext()) {
                    this.next = underlying.next();
                    if (forbidden.contains(this.next)) continue;
                    this.hasNext = true;
                    return;
                }
                this.next = null;
            }
        };
    }

    private Iterators() {
    }
}

