/*
 * Decompiled with CFR 0.152.
 */
package org.staxnav;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.staxnav.EnumElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Naming<N> {
    public abstract String getLocalPart(N var1);

    public abstract String getURI(N var1);

    public abstract String getPrefix(N var1);

    public abstract N getName(QName var1);

    public abstract N getName(String var1, String var2, String var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Enumerated<E extends Enum<E>>
    extends Naming<E> {
        protected final Class<E> enumType;
        protected final E noSuchElement;

        protected Enumerated(Class<E> enumType, E noSuchElement) {
            this.enumType = enumType;
            this.noSuchElement = noSuchElement;
        }

        @Override
        public E getName(QName name) {
            return (E)(name == null ? null : (Enum)this.getName(null, null, name.getLocalPart()));
        }

        @Override
        public String getURI(E name) {
            return null;
        }

        @Override
        public String getPrefix(E name) {
            return "";
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Mapped<E extends Enum<E>>
        extends Enumerated<E> {
            private final E[] all;

            public Mapped(Class<E> enumType, E noSuchElement) {
                super(enumType, noSuchElement);
                this.all = (Enum[])enumType.getEnumConstants();
            }

            @Override
            public String getLocalPart(E name) {
                return ((EnumElement)name).getLocalName();
            }

            @Override
            public E getName(String uri, String prefix, String localPart) {
                for (E e : this.all) {
                    if (!localPart.equals(((EnumElement)e).getLocalName())) continue;
                    return e;
                }
                return (E)this.noSuchElement;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Simple<E extends Enum<E>>
        extends Enumerated<E> {
            private final Map<String, E> toName;
            private final Map<E, String> toLocalPart;

            public Simple(Class<E> enumType, E noSuchElement) {
                super(enumType, noSuchElement);
                HashMap<String, E> toName = new HashMap<String, E>();
                EnumMap<E, String> toLocalPart = new EnumMap<E, String>(enumType);
                for (Enum value : (Enum[])enumType.getEnumConstants()) {
                    String localPart = value.name().toLowerCase().replace('_', '-');
                    toName.put(localPart, value);
                    toLocalPart.put(value, localPart);
                }
                this.toName = toName;
                this.toLocalPart = toLocalPart;
            }

            @Override
            public String getLocalPart(E name) {
                return this.toLocalPart.get(name);
            }

            @Override
            public E getName(String uri, String prefix, String localPart) {
                Enum name = (Enum)this.toName.get(localPart);
                return (E)(name != null ? name : this.noSuchElement);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Qualified
    extends Naming<QName> {
        @Override
        public QName getName(String uri, String prefix, String localPart) {
            return prefix != null ? new QName(uri, localPart, prefix) : new QName(uri, localPart);
        }

        @Override
        public QName getName(QName name) {
            return name;
        }

        @Override
        public String getURI(QName name) {
            return name != null ? name.getNamespaceURI() : null;
        }

        @Override
        public String getPrefix(QName name) {
            return name != null ? name.getPrefix() : null;
        }

        @Override
        public String getLocalPart(QName name) {
            return name != null ? name.getLocalPart() : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Local
    extends Naming<String> {
        @Override
        public String getName(String uri, String prefix, String localPart) {
            return localPart;
        }

        @Override
        public String getName(QName name) {
            return name == null ? null : name.getLocalPart();
        }

        @Override
        public String getPrefix(String name) {
            return "";
        }

        @Override
        public String getURI(String name) {
            return null;
        }

        @Override
        public String getLocalPart(String name) {
            return name;
        }
    }
}

