/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CommentToken;
import org.htmlcleaner.ContentToken;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.TagToken;
import org.htmlcleaner.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomSerializer {
    protected CleanerProperties props;
    protected boolean escapeXml = true;

    public DomSerializer(CleanerProperties cleanerProperties, boolean bl) {
        this.props = cleanerProperties;
        this.escapeXml = bl;
    }

    public DomSerializer(CleanerProperties cleanerProperties) {
        this(cleanerProperties, true);
    }

    public Document createDOM(TagNode tagNode) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        Element element = document.createElement(tagNode.getName());
        document.appendChild(element);
        this.createSubnodes(document, element, tagNode.getChildren());
        return document;
    }

    private void createSubnodes(Document document, Element element, List list) {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                Object object3;
                Object e = iterator.next();
                if (e instanceof CommentToken) {
                    object3 = (CommentToken)e;
                    object2 = document.createComment(((CommentToken)object3).getContent());
                    element.appendChild((Node)object2);
                    continue;
                }
                if (e instanceof ContentToken) {
                    boolean bl;
                    object3 = element.getNodeName();
                    object2 = (ContentToken)e;
                    object = ((ContentToken)object2).getContent();
                    boolean bl2 = bl = this.props.isUseCdataForScriptAndStyle() && ("script".equalsIgnoreCase((String)object3) || "style".equalsIgnoreCase((String)object3));
                    if (this.escapeXml && !bl) {
                        object = Utils.escapeXml((String)object, this.props, true);
                    }
                    element.appendChild(bl ? document.createCDATASection((String)object) : document.createTextNode((String)object));
                    continue;
                }
                if (e instanceof TagNode) {
                    object3 = (TagNode)e;
                    object2 = document.createElement(((TagToken)object3).getName());
                    object = ((TagNode)object3).getAttributes();
                    Iterator iterator2 = object.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry entry = iterator2.next();
                        String string = (String)entry.getKey();
                        String string2 = (String)entry.getValue();
                        if (this.escapeXml) {
                            string2 = Utils.escapeXml(string2, this.props, true);
                        }
                        object2.setAttribute(string, string2);
                    }
                    this.createSubnodes(document, (Element)object2, ((TagNode)object3).getChildren());
                    element.appendChild((Node)object2);
                    continue;
                }
                if (!(e instanceof List)) continue;
                object3 = (List)e;
                this.createSubnodes(document, element, (List)object3);
            }
        }
    }
}

