/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.DoctypeToken;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagInfo;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;

public abstract class XmlSerializer {
    protected CleanerProperties props;

    protected XmlSerializer(CleanerProperties cleanerProperties) {
        this.props = cleanerProperties;
    }

    public void writeXmlToStream(TagNode tagNode, OutputStream outputStream, String string) throws IOException {
        this.writeXml(tagNode, new OutputStreamWriter(outputStream, string), string);
    }

    public void writeXmlToStream(TagNode tagNode, OutputStream outputStream) throws IOException {
        this.writeXmlToStream(tagNode, outputStream, HtmlCleaner.DEFAULT_CHARSET);
    }

    public void writeXmlToFile(TagNode tagNode, String string, String string2) throws IOException {
        this.writeXmlToStream(tagNode, new FileOutputStream(string), string2);
    }

    public void writeXmlToFile(TagNode tagNode, String string) throws IOException {
        this.writeXmlToFile(tagNode, string, HtmlCleaner.DEFAULT_CHARSET);
    }

    public String getXmlAsString(TagNode tagNode, String string) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.writeXml(tagNode, stringWriter, string);
        return stringWriter.getBuffer().toString();
    }

    public String getXmlAsString(TagNode tagNode) throws IOException {
        return this.getXmlAsString(tagNode, HtmlCleaner.DEFAULT_CHARSET);
    }

    public void writeXml(TagNode tagNode, Writer writer, String string) throws IOException {
        Object object;
        writer = new BufferedWriter(writer);
        if (!this.props.isOmitXmlDeclaration()) {
            object = "<?xml version=\"1.0\"";
            if (string != null) {
                object = (String)object + " encoding=\"" + string + "\"";
            }
            object = (String)object + "?>";
            writer.write((String)object + "\n");
        }
        if (!this.props.isOmitDoctypeDeclaration() && (object = tagNode.getDocType()) != null) {
            ((DoctypeToken)object).serialize(this, writer);
        }
        this.serialize(tagNode, writer);
        writer.flush();
        writer.close();
    }

    protected String escapeXml(String string) {
        return Utils.escapeXml(string, this.props, false);
    }

    protected boolean dontEscape(TagNode tagNode) {
        String string = tagNode.getName();
        return this.props.isUseCdataForScriptAndStyle() && ("script".equalsIgnoreCase(string) || "style".equalsIgnoreCase(string));
    }

    protected boolean isScriptOrStyle(TagNode tagNode) {
        String string = tagNode.getName();
        return "script".equalsIgnoreCase(string) || "style".equalsIgnoreCase(string);
    }

    protected boolean isMinimizedTagSyntax(TagNode tagNode) {
        TagInfo tagInfo = this.props.getTagInfoProvider().getTagInfo(tagNode.getName());
        return tagNode.getChildren().size() == 0 && (this.props.isUseEmptyElementTags() || tagInfo != null && tagInfo.isEmptyTag());
    }

    protected void serializeOpenTag(TagNode tagNode, Writer writer, boolean bl) throws IOException {
        String string = tagNode.getName();
        Map map = tagNode.getAttributes();
        writer.write("<" + string);
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            if (!this.props.isNamespacesAware() && ("xmlns".equals(string2) || string2.startsWith("xmlns:"))) continue;
            writer.write(" " + string2 + "=\"" + this.escapeXml(string3) + "\"");
        }
        if (this.isMinimizedTagSyntax(tagNode)) {
            writer.write(" />");
            if (bl) {
                writer.write("\n");
            }
        } else if (this.dontEscape(tagNode)) {
            writer.write("><![CDATA[");
        } else {
            writer.write(">");
        }
    }

    protected void serializeOpenTag(TagNode tagNode, Writer writer) throws IOException {
        this.serializeOpenTag(tagNode, writer, true);
    }

    protected void serializeEndTag(TagNode tagNode, Writer writer, boolean bl) throws IOException {
        String string = tagNode.getName();
        if (this.dontEscape(tagNode)) {
            writer.write("]]>");
        }
        writer.write("</" + string + ">");
        if (bl) {
            writer.write("\n");
        }
    }

    protected void serializeEndTag(TagNode tagNode, Writer writer) throws IOException {
        this.serializeEndTag(tagNode, writer, true);
    }

    protected abstract void serialize(TagNode var1, Writer var2) throws IOException;
}

