/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.publishing;

import org.exoplatform.processes.publishing.ProcessUtil;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class BackupContentActionHandler
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private boolean executed = false;
    private static final Log LOG = ExoLogger.getLogger(BackupContentActionHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context) {
        try {
            if (this.executed) {
                return;
            }
            this.executed = true;
            this.backupContent(context);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
        finally {
            ProcessUtil.deleteTimer((ExecutionContext)context, (String)"backupTimer", (Token)context.getToken());
            context.getToken().signal("backup-done");
        }
    }

    protected void backupContent(ExecutionContext context) throws Exception {
        String[] currentLocation = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String currentWorkspace = currentLocation[1];
        String currentPath = currentLocation[2];
        String backupWorkspace = (String)context.getVariable("exo:backupWorkspace");
        String backupPath = (String)context.getVariable("exo:backupPath");
        String realBackupPath = ProcessUtil.computeDestinationPath((ExecutionContext)context, (String)currentPath, (String)backupPath);
        CmsService cmsService = (CmsService)ProcessUtil.getService((ExecutionContext)context, CmsService.class);
        cmsService.moveNode(currentPath, currentWorkspace, backupWorkspace, realBackupPath);
        ProcessUtil.setCurrentLocation((ExecutionContext)context, (String)backupWorkspace, (String)realBackupPath);
        ProcessUtil.backup((ExecutionContext)context);
    }
}

