/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem;

import java.util.Arrays;

public class WikiPageUtil {
    private static final char[] HTTP_RESERVED_SYMBOLS = new char[]{';', '/', '?', ':', '@', '&', '=', '+', '$', ','};
    private static final char[] HTTP_UNRESERVED_SYMBOLS = new char[]{'-', '_', '.', '!', '~', '*', '\'', '(', ')', '#'};

    public static String decodeHttpParams(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        char[] array = str.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            char ch = array[i];
            if (ch == '%') {
                if (i + 2 >= array.length) break;
                int val = array[++i] - 48;
                val <<= 4;
                ch = (char)(val |= array[++i] - 48);
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String encodeHttpParams(String str) {
        if (str == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        char[] array = str.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            char ch = array[i];
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || Character.isDigit(ch) || Arrays.binarySearch(HTTP_RESERVED_SYMBOLS, ch) >= 0 || Arrays.binarySearch(HTTP_UNRESERVED_SYMBOLS, ch) >= 0) {
                buf.append(array[i]);
                continue;
            }
            buf.append("%" + Integer.toHexString(array[i]));
        }
        return buf.toString();
    }

    public static String escapeXmlAttribute(String str) {
        return WikiPageUtil.escapeXmlString(str, true);
    }

    public static String escapeXmlString(String str) {
        return WikiPageUtil.escapeXmlString(str, false);
    }

    public static String escapeXmlString(String str, boolean escapeQuots) {
        if (str == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        char[] array = str.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == '>' || array[i] == '&' || array[i] == '<' || escapeQuots && (array[i] == '\'' || array[i] == '\"')) {
                buf.append("&#x" + Integer.toHexString(array[i]) + ";");
                continue;
            }
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String getCDATA(String text) {
        StringBuffer buf = new StringBuffer();
        buf.append("<![CDATA[");
        int startPos = 0;
        while (startPos >= 0 && startPos < text.length()) {
            int id = text.indexOf("]]>", startPos);
            if (id >= 0) {
                buf.append(text.substring(startPos, id));
                buf.append("]]]]><![CDATA[>");
                startPos += id + "]]>".length();
                continue;
            }
            buf.append(text.substring(startPos));
            startPos = -1;
        }
        buf.append("]]>");
        return buf.toString();
    }

    static {
        Arrays.sort(HTTP_RESERVED_SYMBOLS);
        Arrays.sort(HTTP_UNRESERVED_SYMBOLS);
    }
}

