/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.folksonomy;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.folksonomy.UITagManager;
import org.exoplatform.ecm.webui.component.admin.folksonomy.UITagStyleList;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={UpdateStyleActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UITagStyleForm
extends UIForm {
    public static final String STYLE_NAME = "styleName";
    public static final String DOCUMENT_RANGE = "documentRange";
    public static final String STYLE_HTML = "styleHTML";
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UITagStyleForm");
    private NodeLocation selectedTagStyle_;

    public UITagStyleForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(STYLE_NAME, STYLE_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(DOCUMENT_RANGE, DOCUMENT_RANGE, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(STYLE_HTML, STYLE_HTML, null).addValidator(MandatoryValidator.class, new Object[0]));
    }

    public Node getTagStyle() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.selectedTagStyle_);
    }

    public void setTagStyle(Node selectedTagStyle) throws Exception {
        this.selectedTagStyle_ = NodeLocation.getNodeLocationByNode((Node)selectedTagStyle);
        if (selectedTagStyle != null) {
            this.getUIStringInput(STYLE_NAME).setValue((Object)selectedTagStyle.getName());
            this.getUIStringInput(STYLE_NAME).setEditable(false);
            String range = selectedTagStyle.getProperty("exo:styleRange").getValue().getString();
            this.getUIStringInput(DOCUMENT_RANGE).setValue((Object)range);
            String htmlStyle = selectedTagStyle.getProperty("exo:htmlStyle").getValue().getString();
            this.getUIFormTextAreaInput(STYLE_HTML).setValue((Object)htmlStyle);
        }
    }

    private boolean validateRange(String range) {
        String[] vars = null;
        try {
            vars = StringUtils.split((String)range, (String)"..");
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return false;
        }
        if (vars == null || vars.length != 2) {
            return false;
        }
        String minRange = vars[0];
        String maxRange = vars[1];
        if (!StringUtils.isNumeric((String)minRange)) {
            return false;
        }
        try {
            int min = Integer.parseInt(vars[0]);
            if (min < 0) {
                return false;
            }
            if (!StringUtils.isNumeric((String)maxRange) ? !maxRange.equals("*") : Integer.parseInt(maxRange) <= 0) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UITagStyleForm> {
        public void execute(Event<UITagStyleForm> event) throws Exception {
            UITagStyleForm uiForm = (UITagStyleForm)((Object)event.getSource());
            UITagManager uiManager = (UITagManager)uiForm.getAncestorOfType(UITagManager.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiManager.getChild(UIPopupWindow.class);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UpdateStyleActionListener
    extends EventListener<UITagStyleForm> {
        public void execute(Event<UITagStyleForm> event) throws Exception {
            UITagStyleForm uiForm = (UITagStyleForm)((Object)event.getSource());
            UITagManager uiManager = (UITagManager)uiForm.getAncestorOfType(UITagManager.class);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String repository = ((UIECMAdminPortlet)uiForm.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
            String workspace = ((UIECMAdminPortlet)uiForm.getAncestorOfType(UIECMAdminPortlet.class)).getDMSSystemWorkspace(repository);
            String documentRange = (String)uiForm.getUIStringInput(UITagStyleForm.DOCUMENT_RANGE).getValue();
            String styleHTML = (String)uiForm.getUIFormTextAreaInput(UITagStyleForm.STYLE_HTML).getValue();
            if (!uiForm.validateRange(documentRange)) {
                uiApp.addMessage(new ApplicationMessage("UITagStyleForm.msg.range-validator", null));
                return;
            }
            try {
                if (uiForm.getTagStyle() == null) {
                    String tagStyleName = ((String)uiForm.getUIStringInput(UITagStyleForm.STYLE_NAME).getValue()).trim();
                    NewFolksonomyService newFolksonomyService = (NewFolksonomyService)uiForm.getApplicationComponent(NewFolksonomyService.class);
                    newFolksonomyService.addTagStyle(tagStyleName, "", "", workspace);
                    for (Node tagStyle : newFolksonomyService.getAllTagStyle(workspace)) {
                        if (!tagStyle.getName().equals(tagStyleName)) continue;
                        uiForm.selectedTagStyle_ = NodeLocation.getNodeLocationByNode((Node)tagStyle);
                        break;
                    }
                }
                uiForm.getTagStyle().setProperty("exo:styleRange", documentRange);
                uiForm.getTagStyle().setProperty("exo:htmlStyle", styleHTML);
                uiForm.getTagStyle().save();
                uiForm.getTagStyle().getSession().save();
                UITagStyleList uiTagList = (UITagStyleList)uiManager.getChild(UITagStyleList.class);
                uiTagList.refresh(uiTagList.getUIPageIterator().getCurrentPage());
            }
            catch (ItemNotFoundException ie) {
                String key = "UITagStyleForm.msg.item-not-existing";
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                return;
            }
            catch (Exception e) {
                String key = "UITagStyleForm.msg.error-update";
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                return;
            }
            UIPopupWindow uiPopup = (UIPopupWindow)uiManager.getChild(UIPopupWindow.class);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

