/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.templates;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.version.VersionHistory;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.webui.component.admin.templates.UIDialogTab;
import org.exoplatform.ecm.webui.component.admin.templates.UISkinTab;
import org.exoplatform.ecm.webui.component.admin.templates.UITemplatesManager;
import org.exoplatform.ecm.webui.component.admin.templates.UIViewTab;
import org.exoplatform.ecm.webui.component.admin.templates.UIViewTemplate;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RestoreActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RefreshActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddPermissionActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RemovePermissionActionListener.class})})
public class UITemplateContent
extends UIForm
implements UISelectable {
    public static final String FIELD_SELECT_VERSION = "selectVersion";
    public static final String FIELD_CONTENT = "content";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_VIEWPERMISSION = "viewPermission";
    public static final String FIELD_ENABLE_VERSION = "enableVersion";
    public static final String[] REG_EXPRESSION = new String[]{"[", "]", ":", "&", "%"};
    private boolean isAddNew_ = true;
    private String nodeTypeName_;
    private List<String> listVersion_ = new ArrayList<String>();
    private String templateType;
    public static final String TEMPLATE_PERMISSION = "TemplatePermission";

    public UITemplateContent() throws Exception {
        ArrayList options = new ArrayList();
        UIFormSelectBox versions = new UIFormSelectBox(FIELD_SELECT_VERSION, FIELD_SELECT_VERSION, options);
        versions.setOnChange("Change");
        versions.setRendered(false);
        this.addUIFormInput((UIFormInput)versions);
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_CONTENT, FIELD_CONTENT, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        UIFormCheckBoxInput isVersion = new UIFormCheckBoxInput(FIELD_ENABLE_VERSION, FIELD_ENABLE_VERSION, null);
        isVersion.setRendered(false);
        this.addUIFormInput((UIFormInput)isVersion);
        UIFormInputSetWithAction uiActionTab = new UIFormInputSetWithAction("UITemplateContent");
        uiActionTab.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_VIEWPERMISSION, FIELD_VIEWPERMISSION, null).setEditable(false).addValidator(MandatoryValidator.class, new Object[0]));
        uiActionTab.setActionInfo(FIELD_VIEWPERMISSION, new String[]{"AddPermission", "RemovePermission"});
        this.addUIComponentInput((UIComponent)uiActionTab);
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType;
    }

    public String getTemplateType() {
        return this.templateType;
    }

    public void setNodeTypeName(String nodeType) {
        this.nodeTypeName_ = nodeType;
    }

    public void update(String templateName) throws Exception {
        if (templateName != null) {
            this.isAddNew_ = false;
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            String templateContent = templateService.getTemplate(this.templateType, this.nodeTypeName_, templateName);
            Node template = templateService.getTemplateNode(this.templateType, this.nodeTypeName_, templateName, WCMCoreUtils.getSystemSessionProvider());
            this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setRendered(true);
            String templateRole = templateService.getTemplateRoles(template);
            boolean isVersioned = template.isNodeType("mix:versionable");
            if (isVersioned) {
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setRendered(true);
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setOptions(this.getVersionValues(template));
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setValue(template.getBaseVersion().getName());
                this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setEnable(false);
                this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setChecked(true);
                this.setActions(new String[]{"Save", "Restore", "Refresh", "Cancel"});
            } else {
                this.getUIFormSelectBox(FIELD_SELECT_VERSION).setRendered(false);
                this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setEnable(true);
                this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setChecked(false);
                this.setActions(new String[]{"Save", "Refresh", "Cancel"});
            }
            String content = Utils.encodeHTML((String)templateContent);
            this.getUIFormTextAreaInput(FIELD_CONTENT).setValue((Object)content);
            this.getUIStringInput(FIELD_NAME).setValue((Object)template.getName());
            this.getUIStringInput(FIELD_NAME).setEditable(false);
            this.getUIStringInput(FIELD_VIEWPERMISSION).setValue((Object)templateRole);
            return;
        }
        this.isAddNew_ = true;
        this.getUIFormSelectBox(FIELD_SELECT_VERSION).setRendered(false);
        this.getUIFormCheckBoxInput(FIELD_ENABLE_VERSION).setRendered(false);
        this.getUIStringInput(FIELD_NAME).setEditable(true);
        this.setActions(new String[]{"Save", "Refresh", "Cancel"});
    }

    private void refresh() throws Exception {
        UIViewTemplate uiViewTemplate = (UIViewTemplate)this.getAncestorOfType(UIViewTemplate.class);
        uiViewTemplate.refresh();
        UIComponent parent = this.getParent();
        if (parent instanceof UIDialogTab) {
            uiViewTemplate.setRenderedChild(UIDialogTab.class);
        } else if (parent instanceof UIViewTab) {
            uiViewTemplate.setRenderedChild(UIViewTab.class);
        } else if (parent instanceof UISkinTab) {
            uiViewTemplate.setRenderedChild(UISkinTab.class);
        }
        this.update(null);
        this.reset();
    }

    private VersionNode getRootVersion(Node node) throws Exception {
        VersionHistory vH = node.getVersionHistory();
        if (vH != null) {
            return new VersionNode(vH.getRootVersion(), node.getSession());
        }
        return null;
    }

    private List<String> getNodeVersions(List<VersionNode> children) throws Exception {
        List<VersionNode> child = new ArrayList();
        for (VersionNode version : children) {
            this.listVersion_.add(version.getName());
            child = version.getChildren();
            if (child.isEmpty()) continue;
            this.getNodeVersions(child);
        }
        return this.listVersion_;
    }

    private List<SelectItemOption<String>> getVersionValues(Node node) throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        List children = this.getRootVersion(node).getChildren();
        this.listVersion_.clear();
        List<String> versionList = this.getNodeVersions(children);
        for (int i = 0; i < versionList.size(); ++i) {
            for (int j = i + 1; j < versionList.size(); ++j) {
                if (Integer.parseInt(versionList.get(j)) >= Integer.parseInt(versionList.get(i))) continue;
                String temp = versionList.get(i);
                versionList.set(i, versionList.get(j));
                versionList.set(j, temp);
            }
            options.add((SelectItemOption<String>)new SelectItemOption(versionList.get(i), (Object)versionList.get(i)));
        }
        return options;
    }

    public void doSelect(String selectField, Object value) {
        String viewPermission = (String)this.getUIStringInput(FIELD_VIEWPERMISSION).getValue();
        if (viewPermission == null) {
            viewPermission = "";
        }
        viewPermission = viewPermission != null && viewPermission.length() == 0 ? value.toString() : viewPermission + "," + value.toString();
        this.getUIStringInput(FIELD_VIEWPERMISSION).setValue((Object)viewPermission);
        UITemplatesManager uiManager = (UITemplatesManager)this.getAncestorOfType(UITemplatesManager.class);
        uiManager.removeChildById(this.getId() + TEMPLATE_PERMISSION);
    }

    private static boolean areValidPermissions(String permissions, UITemplateContent uiTemplateContent, Event event) throws Exception {
        Boolean areValidPermissions = false;
        UIApplication uiApp = (UIApplication)uiTemplateContent.getAncestorOfType(UIApplication.class);
        if (permissions == null || permissions.trim().length() == 0) {
            uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.permission-null", null, 1));
            areValidPermissions = false;
            return areValidPermissions;
        }
        OrganizationService oservice = (OrganizationService)uiTemplateContent.getApplicationComponent(OrganizationService.class);
        String[] arrPermissions = permissions.split(",");
        Collection collection = oservice.getMembershipTypeHandler().findMembershipTypes();
        ArrayList<String> listMemberhip = new ArrayList<String>(5);
        for (Object obj : collection) {
            listMemberhip.add(((MembershipType)obj).getName());
        }
        listMemberhip.add("*");
        for (String itemPermission : arrPermissions) {
            if (itemPermission.length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.permission-path-invalid", null, 1));
                areValidPermissions = false;
                return areValidPermissions;
            }
            if (itemPermission.contains(":")) {
                String[] permission = itemPermission.split(":");
                if (permission[0] == null || permission[0].length() == 0) {
                    uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.permission-path-invalid", null, 1));
                    areValidPermissions = false;
                    return areValidPermissions;
                }
                if (!listMemberhip.contains(permission[0])) {
                    uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.permission-path-invalid", null, 1));
                    areValidPermissions = false;
                    return areValidPermissions;
                }
                if (permission[1] == null || permission[1].length() == 0) {
                    uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.permission-path-invalid", null, 1));
                    areValidPermissions = false;
                    return areValidPermissions;
                }
                if (oservice.getGroupHandler().findGroupById(permission[1]) != null) continue;
                uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.permission-path-invalid", null, 1));
                areValidPermissions = false;
                return areValidPermissions;
            }
            if (itemPermission.equals("*")) continue;
            uiApp.addMessage(new ApplicationMessage("UIDriveForm.msg.permission-path-invalid", null, 1));
            areValidPermissions = false;
            return areValidPermissions;
        }
        areValidPermissions = true;
        return areValidPermissions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UITemplateContent> {
        public void execute(Event<UITemplateContent> event) throws Exception {
            UITemplateContent uiTemplateContent = (UITemplateContent)((Object)event.getSource());
            UITemplatesManager uiManager = (UITemplatesManager)uiTemplateContent.getAncestorOfType(UITemplatesManager.class);
            uiManager.removeChildById("DialogFormTemplatePermission");
            uiManager.removeChildById("ViewFormTemplatePermission");
            uiManager.removeChildById("SkinFormTemplatePermission");
            uiTemplateContent.reset();
            uiManager.removeChild(UIPopupWindow.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RefreshActionListener
    extends EventListener<UITemplateContent> {
        public void execute(Event<UITemplateContent> event) throws Exception {
            UITemplateContent uiForm = (UITemplateContent)((Object)event.getSource());
            UITemplatesManager uiManager = (UITemplatesManager)uiForm.getAncestorOfType(UITemplatesManager.class);
            if (!uiForm.isAddNew_) {
                uiForm.update((String)uiForm.getUIStringInput(UITemplateContent.FIELD_NAME).getValue());
                return;
            }
            uiForm.update(null);
            uiForm.reset();
            uiForm.refresh();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemovePermissionActionListener
    extends EventListener<UITemplateContent> {
        public void execute(Event<UITemplateContent> event) throws Exception {
            UITemplateContent uiTemplateContent = (UITemplateContent)((Object)event.getSource());
            uiTemplateContent.getUIStringInput(UITemplateContent.FIELD_VIEWPERMISSION).setValue(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTemplateContent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddPermissionActionListener
    extends EventListener<UITemplateContent> {
        public void execute(Event<UITemplateContent> event) throws Exception {
            UITemplateContent uiTempContent = (UITemplateContent)((Object)event.getSource());
            UITemplatesManager uiManager = (UITemplatesManager)uiTempContent.getAncestorOfType(UITemplatesManager.class);
            UIViewTemplate uiViewTemp = (UIViewTemplate)uiTempContent.getAncestorOfType(UIViewTemplate.class);
            List uicomponents = uiManager.getChildren();
            ArrayList parentUIComponents = new ArrayList();
            parentUIComponents.addAll(uicomponents);
            for (UIComponent uicomponent : parentUIComponents) {
                if (!UIPopupWindow.class.isInstance(uicomponent) || uicomponent.getId().equals("TemplatePopup") || uicomponent.getId().equals("EditTemplatePopup")) continue;
                uiManager.removeChildById(uicomponent.getId());
            }
            String membership = (String)uiTempContent.getUIStringInput(UITemplateContent.FIELD_VIEWPERMISSION).getValue();
            uiManager.initPopupPermission(uiTempContent.getId(), membership);
            if (uiTempContent.getId().equals("DialogForm")) {
                uiViewTemp.setRenderedChild(UIDialogTab.class);
            } else if (uiTempContent.getId().equals("ViewForm")) {
                uiViewTemp.setRenderedChild(UIViewTab.class);
            } else if (uiTempContent.getId().equals("SkinForm")) {
                uiViewTemp.setRenderedChild(UISkinTab.class);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeActionListener
    extends EventListener<UITemplateContent> {
        public void execute(Event<UITemplateContent> event) throws Exception {
            UITemplateContent uiForm = (UITemplateContent)((Object)event.getSource());
            UITemplatesManager uiManager = (UITemplatesManager)uiForm.getAncestorOfType(UITemplatesManager.class);
            String name = (String)uiForm.getUIStringInput(UITemplateContent.FIELD_NAME).getValue();
            TemplateService templateService = (TemplateService)uiForm.getApplicationComponent(TemplateService.class);
            Node node = templateService.getTemplateNode(uiForm.getTemplateType(), uiForm.nodeTypeName_, name, WCMCoreUtils.getSystemSessionProvider());
            String version = (String)uiForm.getUIFormSelectBox(UITemplateContent.FIELD_SELECT_VERSION).getValue();
            String path = node.getVersionHistory().getVersion(version).getPath();
            VersionNode versionNode = uiForm.getRootVersion(node).findVersionNode(path);
            Node frozenNode = versionNode.getNode("jcr:frozenNode");
            String content = templateService.getTemplate(frozenNode);
            uiForm.getUIFormTextAreaInput(UITemplateContent.FIELD_CONTENT).setValue((Object)content);
            if (frozenNode.hasProperty("exo:roles")) {
                StringBuilder rule = new StringBuilder();
                Value[] rules = frozenNode.getProperty("exo:roles").getValues();
                for (int i = 0; i < rules.length; ++i) {
                    rule.append(rules[i].getString());
                }
                uiForm.getUIStringInput(UITemplateContent.FIELD_VIEWPERMISSION).setValue((Object)rule.toString());
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UITemplateContent> {
        public void execute(Event<UITemplateContent> event) throws Exception {
            UISkinTab uiSkinTab;
            UITemplateContent uiForm = (UITemplateContent)((Object)event.getSource());
            UITemplatesManager uiManager = (UITemplatesManager)uiForm.getAncestorOfType(UITemplatesManager.class);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            String name = (String)uiForm.getUIStringInput(UITemplateContent.FIELD_NAME).getValue();
            if (name == null || name.trim().length() == 0) {
                Object[] args = new Object[]{UITemplateContent.FIELD_NAME};
                uiApp.addMessage(new ApplicationMessage("ECMNameValidator.msg.empty-input", args, 1));
                return;
            }
            if (!Utils.isNameValid((String)name, (String[])REG_EXPRESSION)) {
                uiApp.addMessage(new ApplicationMessage("UITemplateContent.msg.name-invalid", null, 1));
                return;
            }
            String content = (String)uiForm.getUIFormTextAreaInput(UITemplateContent.FIELD_CONTENT).getValue();
            if (content == null) {
                content = "";
            }
            UIFormInputSetWithAction permField = (UIFormInputSetWithAction)uiForm.getChildById("UITemplateContent");
            String role = (String)permField.getUIStringInput(UITemplateContent.FIELD_VIEWPERMISSION).getValue();
            UIViewTemplate uiViewTemplate = (UIViewTemplate)uiForm.getAncestorOfType(UIViewTemplate.class);
            if (uiForm.getId().equals("DialogForm")) {
                UIDialogTab uiDialogTab = (UIDialogTab)uiViewTemplate.getChild(UIDialogTab.class);
                if (uiDialogTab.getListDialog().contains(name) && uiForm.isAddNew_) {
                    Object[] args = new Object[]{name};
                    uiApp.addMessage(new ApplicationMessage("UITemplateContent.msg.name-exist", args, 1));
                    return;
                }
            } else if (uiForm.getId().equals("ViewForm")) {
                UIViewTab uiViewTab = (UIViewTab)uiViewTemplate.getChild(UIViewTab.class);
                if (uiViewTab.getListView().contains(name) && uiForm.isAddNew_) {
                    Object[] args = new Object[]{name};
                    uiApp.addMessage(new ApplicationMessage("UITemplateContent.msg.name-exist", args, 1));
                    return;
                }
            } else if (uiForm.getId().equals("SkinForm") && (uiSkinTab = (UISkinTab)uiViewTemplate.getChild(UISkinTab.class)).getListSkin().contains(name) && uiForm.isAddNew_) {
                Object[] args = new Object[]{name};
                uiApp.addMessage(new ApplicationMessage("UITemplateContent.msg.name-exist", args, 1));
                return;
            }
            TemplateService templateService = (TemplateService)uiForm.getApplicationComponent(TemplateService.class);
            boolean isEnableVersioning = uiForm.getUIFormCheckBoxInput(UITemplateContent.FIELD_ENABLE_VERSION).isChecked();
            if (uiForm.isAddNew_) {
                templateService.addTemplate(uiForm.getTemplateType(), uiForm.nodeTypeName_, null, false, name, new String[]{role}, (InputStream)new ByteArrayInputStream(content.getBytes()));
            } else {
                Node node = templateService.getTemplateNode(uiForm.getTemplateType(), uiForm.nodeTypeName_, name, WCMCoreUtils.getSystemSessionProvider());
                if (isEnableVersioning && !node.isNodeType("mix:versionable")) {
                    node.addMixin("mix:versionable");
                }
                if (!UITemplateContent.areValidPermissions(role, uiForm, event)) {
                    return;
                }
                templateService.addTemplate(uiForm.getTemplateType(), uiForm.nodeTypeName_, null, false, name, new String[]{role}, (InputStream)new ByteArrayInputStream(content.getBytes()));
                node.save();
                if (isEnableVersioning) {
                    node.checkin();
                    node.checkout();
                }
            }
            uiForm.refresh();
            uiForm.isAddNew_ = true;
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RestoreActionListener
    extends EventListener<UITemplateContent> {
        public void execute(Event<UITemplateContent> event) throws Exception {
            UITemplateContent uiForm = (UITemplateContent)((Object)event.getSource());
            UITemplatesManager uiManager = (UITemplatesManager)uiForm.getAncestorOfType(UITemplatesManager.class);
            String name = (String)uiForm.getUIStringInput(UITemplateContent.FIELD_NAME).getValue();
            TemplateService templateService = (TemplateService)uiForm.getApplicationComponent(TemplateService.class);
            Node node = templateService.getTemplateNode(uiForm.getTemplateType(), uiForm.nodeTypeName_, name, WCMCoreUtils.getSystemSessionProvider());
            String vesion = (String)uiForm.getUIFormSelectBox(UITemplateContent.FIELD_SELECT_VERSION).getValue();
            String baseVesion = node.getBaseVersion().getName();
            UIApplication app = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            if (vesion.equals(baseVesion)) {
                return;
            }
            node.checkout();
            node.restore(vesion, true);
            Object[] args = new Object[]{uiForm.getUIStringInput(UITemplateContent.FIELD_SELECT_VERSION).getValue()};
            app.addMessage(new ApplicationMessage("UITemplateContent.msg.version-restored", args));
            uiForm.refresh();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

