/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.version.VersionHistory;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.component.admin.views.UICBTemplateList;
import org.exoplatform.ecm.webui.component.admin.views.UIECMTemplateList;
import org.exoplatform.ecm.webui.component.admin.views.UITemplateContainer;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.groovyscript.text.TemplateService;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ResetActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RestoreActionListener.class})})
public class UITemplateForm
extends UIForm {
    private static final String FIELD_VERSION = "version";
    private static final String FIELD_CONTENT = "content";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_HOMETEMPLATE = "homeTemplate";
    private static final String FIELD_ENABLEVERSION = "enableVersion";
    private NodeLocation template_ = null;
    private List<String> listVersion = new ArrayList<String>();
    private String baseVersionName_;
    private VersionNode selectedVersion_;
    public boolean isAddNew_ = false;
    private String templatePath_;
    private VersionNode rootVersionNode;
    private org.exoplatform.services.cms.templates.TemplateService templateService = (org.exoplatform.services.cms.templates.TemplateService)WCMCoreUtils.getService(org.exoplatform.services.cms.templates.TemplateService.class);

    public UITemplateForm() throws Exception {
        ArrayList options = new ArrayList();
        UIFormSelectBox versions = new UIFormSelectBox(FIELD_VERSION, FIELD_VERSION, options);
        versions.setOnChange("Change");
        versions.setRendered(false);
        this.addUIFormInput((UIFormInput)versions);
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_CONTENT, FIELD_CONTENT, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ECMNameValidator.class, new Object[0]));
        ArrayList typeList = new ArrayList();
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_HOMETEMPLATE, FIELD_HOMETEMPLATE, typeList));
        UIFormCheckBoxInput enableVersion = new UIFormCheckBoxInput(FIELD_ENABLEVERSION, FIELD_ENABLEVERSION, null);
        enableVersion.setRendered(false);
        this.addUIFormInput((UIFormInput)enableVersion);
    }

    public String getRepository() {
        try {
            return ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getConfiguration().getName();
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public void updateOptionList() throws Exception {
        this.getUIFormSelectBox(FIELD_HOMETEMPLATE).setOptions(this.getOptionList());
    }

    public List<SelectItemOption<String>> getOptionList() throws Exception {
        ArrayList<SelectItemOption<String>> typeList = new ArrayList<SelectItemOption<String>>();
        SessionProvider provider = WCMCoreUtils.getUserSessionProvider();
        if (this.getId().equalsIgnoreCase("ECMTempForm")) {
            Node ecmTemplateHome = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getTemplateHome("ecmExplorerTemplates", provider);
            if (ecmTemplateHome != null) {
                typeList.add((SelectItemOption<String>)new SelectItemOption(ecmTemplateHome.getName(), (Object)ecmTemplateHome.getPath()));
            }
        } else {
            Node cbTemplateHome = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getTemplateHome("contentBrowserTemplates", provider);
            if (cbTemplateHome != null) {
                NodeIterator iter = cbTemplateHome.getNodes();
                while (iter.hasNext()) {
                    Node template = iter.nextNode();
                    typeList.add((SelectItemOption<String>)new SelectItemOption(template.getName(), (Object)template.getPath()));
                }
            }
        }
        return typeList;
    }

    public boolean canEnableVersionning(Node node) throws Exception {
        return node.canAddMixin("mix:versionable");
    }

    private boolean isVersioned(Node node) throws RepositoryException {
        return node.isNodeType("mix:versionable");
    }

    private VersionNode getRootVersion(Node node) throws Exception {
        VersionHistory vH = node.getVersionHistory();
        return vH != null ? new VersionNode(vH.getRootVersion(), node.getSession()) : null;
    }

    private List<String> getNodeVersions(List<VersionNode> children) throws Exception {
        List<VersionNode> child = new ArrayList();
        for (VersionNode vNode : children) {
            this.listVersion.add(vNode.getName());
            child = vNode.getChildren();
            if (child.isEmpty()) continue;
            this.getNodeVersions(child);
        }
        return this.listVersion;
    }

    private List<SelectItemOption<String>> getVersionValues(Node node) throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        List children = this.getRootVersion(node).getChildren();
        this.listVersion.clear();
        List<String> versionList = this.getNodeVersions(children);
        for (int i = 0; i < versionList.size(); ++i) {
            for (int j = i + 1; j < versionList.size(); ++j) {
                if (Integer.parseInt(versionList.get(j)) >= Integer.parseInt(versionList.get(i))) continue;
                String temp = versionList.get(i);
                versionList.set(i, versionList.get(j));
                versionList.set(j, temp);
            }
            options.add((SelectItemOption<String>)new SelectItemOption(versionList.get(i), (Object)versionList.get(i)));
        }
        return options;
    }

    public void refresh() throws Exception {
        UIFormSelectBox versionField = this.getUIFormSelectBox(FIELD_VERSION);
        if (this.isAddNew_) {
            versionField.setRendered(false);
            this.getUIFormTextAreaInput(FIELD_CONTENT).setValue(null);
            this.getUIStringInput(FIELD_NAME).setEditable(true).setValue(null);
            this.getUIFormSelectBox(FIELD_HOMETEMPLATE).setValue(null);
            this.getUIFormSelectBox(FIELD_HOMETEMPLATE).setDisabled(false);
            this.getUIFormCheckBoxInput(FIELD_ENABLEVERSION).setRendered(false);
            this.template_ = null;
            this.selectedVersion_ = null;
            this.baseVersionName_ = null;
            return;
        }
        this.update(this.template_.getPath(), null);
    }

    public void update(String templatePath, VersionNode selectedVersion) throws Exception {
        if (templatePath != null) {
            this.templatePath_ = templatePath;
            Node templateNode = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getTemplate(templatePath, WCMCoreUtils.getUserSessionProvider());
            this.template_ = NodeLocation.getNodeLocationByNode((Node)templateNode);
            this.getUIStringInput(FIELD_NAME).setValue((Object)templateNode.getName());
            this.getUIStringInput(FIELD_NAME).setEditable(false);
            String value = templatePath.substring(0, templatePath.lastIndexOf("/"));
            this.getUIFormSelectBox(FIELD_HOMETEMPLATE).setValue(value);
            this.getUIFormSelectBox(FIELD_HOMETEMPLATE).setDisabled(false);
            this.getUIFormCheckBoxInput(FIELD_ENABLEVERSION).setRendered(true);
            if (this.isVersioned(templateNode)) {
                this.rootVersionNode = this.getRootVersion(templateNode);
                this.baseVersionName_ = templateNode.getBaseVersion().getName();
                List<SelectItemOption<String>> options = this.getVersionValues(templateNode);
                this.getUIFormSelectBox(FIELD_VERSION).setOptions(options).setRendered(true);
                this.getUIFormSelectBox(FIELD_VERSION).setValue(this.baseVersionName_);
                this.getUIFormCheckBoxInput(FIELD_ENABLEVERSION).setChecked(true).setEnable(false);
                if (options.size() > 1) {
                    this.setActions(new String[]{"Save", "Reset", "Restore", "Cancel"});
                } else {
                    this.setActions(new String[]{"Save", "Reset", "Cancel"});
                }
            } else if (this.canEnableVersionning(templateNode)) {
                this.getUIFormSelectBox(FIELD_VERSION).setRendered(false);
                this.getUIFormCheckBoxInput(FIELD_ENABLEVERSION).setChecked(false).setEditable(true);
            }
        }
        if (selectedVersion != null) {
            NodeLocation.getNodeByLocation((NodeLocation)this.template_).restore(selectedVersion.getName(), false);
            this.selectedVersion_ = selectedVersion;
            Object[] args = new Object[]{this.getUIStringInput(FIELD_VERSION).getValue()};
            UIApplication app = (UIApplication)this.getAncestorOfType(UIApplication.class);
            app.addMessage(new ApplicationMessage("UITemplateForm.msg.version-restored", args));
        }
        String content = this.templateService.getTemplate(NodeLocation.getNodeByLocation((NodeLocation)this.template_));
        this.getUIFormTextAreaInput(FIELD_CONTENT).setValue((Object)Utils.encodeHTML((String)content));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RestoreActionListener
    extends EventListener<UITemplateForm> {
        public void execute(Event<UITemplateForm> event) throws Exception {
            UITemplateForm uiForm = (UITemplateForm)((Object)event.getSource());
            String version = (String)uiForm.getUIFormSelectBox(UITemplateForm.FIELD_VERSION).getValue();
            String path = NodeLocation.getNodeByLocation((NodeLocation)uiForm.template_).getVersionHistory().getVersion(version).getPath();
            VersionNode selectedVesion = uiForm.rootVersionNode.findVersionNode(path);
            if (uiForm.baseVersionName_.equals(selectedVesion.getName())) {
                return;
            }
            uiForm.update(null, selectedVesion);
            UITemplateContainer uiTempContainer = (UITemplateContainer)uiForm.getAncestorOfType(UITemplateContainer.class);
            if (uiForm.getId().equalsIgnoreCase(UIECMTemplateList.ST_ECMTempForm)) {
                UIECMTemplateList uiECMTempList = (UIECMTemplateList)uiTempContainer.getChild(UIECMTemplateList.class);
                uiECMTempList.refresh(uiECMTempList.getUIPageIterator().getCurrentPage());
            }
            if (uiForm.getId().equalsIgnoreCase(UICBTemplateList.ST_CBTempForm)) {
                UICBTemplateList uiCBTempList = (UICBTemplateList)uiTempContainer.getChild(UICBTemplateList.class);
                uiCBTempList.refresh(uiCBTempList.getUIPageIterator().getCurrentPage());
            }
            uiForm.refresh();
            UITemplateContainer uiTemplateContainer = (UITemplateContainer)uiForm.getAncestorOfType(UITemplateContainer.class);
            if (uiForm.isAddNew_) {
                uiTemplateContainer.removeChildById(UIECMTemplateList.ST_ECMTempForm + "Add");
                uiTemplateContainer.removeChildById(UICBTemplateList.ST_CBTempForm + "Add");
            } else {
                uiTemplateContainer.removeChildById(UIECMTemplateList.ST_ECMTempForm + "Edit");
                uiTemplateContainer.removeChildById(UICBTemplateList.ST_CBTempForm + "Edit");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeActionListener
    extends EventListener<UITemplateForm> {
        public void execute(Event<UITemplateForm> event) throws Exception {
            UITemplateForm uiForm = (UITemplateForm)((Object)event.getSource());
            String version = (String)uiForm.getUIFormSelectBox(UITemplateForm.FIELD_VERSION).getValue();
            String path = NodeLocation.getNodeByLocation((NodeLocation)uiForm.template_).getVersionHistory().getVersion(version).getPath();
            VersionNode versionNode = uiForm.rootVersionNode.findVersionNode(path);
            Node frozenNode = versionNode.getNode("jcr:frozenNode");
            String content = uiForm.templateService.getTemplate(frozenNode);
            uiForm.getUIFormTextAreaInput(UITemplateForm.FIELD_CONTENT).setValue((Object)content);
            UITemplateContainer uiTempContainer = (UITemplateContainer)uiForm.getAncestorOfType(UITemplateContainer.class);
            if (uiForm.getId().equalsIgnoreCase(UIECMTemplateList.ST_ECMTempForm)) {
                UIECMTemplateList uiECMTempList = (UIECMTemplateList)uiTempContainer.getChild(UIECMTemplateList.class);
                uiECMTempList.refresh(uiECMTempList.getUIPageIterator().getCurrentPage());
            }
            if (uiForm.getId().equalsIgnoreCase(UICBTemplateList.ST_CBTempForm)) {
                UICBTemplateList uiCBTempList = (UICBTemplateList)uiTempContainer.getChild(UICBTemplateList.class);
                uiCBTempList.refresh(uiCBTempList.getUIPageIterator().getCurrentPage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ResetActionListener
    extends EventListener<UITemplateForm> {
        public void execute(Event<UITemplateForm> event) throws Exception {
            UITemplateForm uiForm = (UITemplateForm)((Object)event.getSource());
            UITemplateContainer uiTempContainer = (UITemplateContainer)uiForm.getAncestorOfType(UITemplateContainer.class);
            if (uiForm.selectedVersion_ != null && !uiForm.selectedVersion_.getName().equals(uiForm.baseVersionName_)) {
                Node templateNode = NodeLocation.getNodeByLocation((NodeLocation)uiForm.template_);
                templateNode.restore(uiForm.baseVersionName_, true);
                templateNode.checkout();
            }
            uiForm.refresh();
            if (uiForm.getId().equalsIgnoreCase(UIECMTemplateList.ST_ECMTempForm)) {
                UIECMTemplateList uiECMTempList = (UIECMTemplateList)uiTempContainer.getChild(UIECMTemplateList.class);
                uiECMTempList.refresh(uiECMTempList.getUIPageIterator().getCurrentPage());
            }
            if (uiForm.getId().equalsIgnoreCase(UICBTemplateList.ST_CBTempForm)) {
                UICBTemplateList uiCBTempList = (UICBTemplateList)uiTempContainer.getChild(UICBTemplateList.class);
                uiCBTempList.refresh(uiCBTempList.getUIPageIterator().getCurrentPage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UITemplateForm> {
        public void execute(Event<UITemplateForm> event) throws Exception {
            UITemplateForm uiForm = (UITemplateForm)((Object)event.getSource());
            uiForm.refresh();
            UITemplateContainer uiTemplateContainer = (UITemplateContainer)uiForm.getAncestorOfType(UITemplateContainer.class);
            if (uiForm.isAddNew_) {
                uiTemplateContainer.removeChildById(UIECMTemplateList.ST_ECMTempForm + "Add");
                uiTemplateContainer.removeChildById(UICBTemplateList.ST_CBTempForm + "Add");
            } else {
                uiTemplateContainer.removeChildById(UIECMTemplateList.ST_ECMTempForm + "Edit");
                uiTemplateContainer.removeChildById(UICBTemplateList.ST_CBTempForm + "Edit");
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTemplateContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UITemplateForm> {
        public void execute(Event<UITemplateForm> event) throws Exception {
            UITemplateForm uiForm = (UITemplateForm)((Object)event.getSource());
            String templateName = ((String)uiForm.getUIStringInput(UITemplateForm.FIELD_NAME).getValue()).trim();
            String content = (String)uiForm.getUIFormTextAreaInput(UITemplateForm.FIELD_CONTENT).getValue();
            String homeTemplate = (String)uiForm.getUIFormSelectBox(UITemplateForm.FIELD_HOMETEMPLATE).getValue();
            UITemplateContainer uiTempContainer = (UITemplateContainer)uiForm.getAncestorOfType(UITemplateContainer.class);
            ManageViewService manageViewService = (ManageViewService)uiForm.getApplicationComponent(ManageViewService.class);
            UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
            if (homeTemplate == null) {
                String tempPath = uiForm.template_.getPath();
                homeTemplate = tempPath.substring(0, tempPath.lastIndexOf("/"));
            }
            boolean isEnableVersioning = uiForm.getUIFormCheckBoxInput(UITemplateForm.FIELD_ENABLEVERSION).isChecked();
            String path = null;
            if (uiForm.getId().equalsIgnoreCase(UIECMTemplateList.ST_ECMTempForm)) {
                List ecmTemps = manageViewService.getAllTemplates("ecmExplorerTemplates", WCMCoreUtils.getUserSessionProvider());
                for (Node temp : ecmTemps) {
                    if (!temp.getName().equals(templateName) || !uiForm.isAddNew_) continue;
                    Object[] args = new Object[]{templateName};
                    uiApp.addMessage(new ApplicationMessage("UITemplateForm.msg.template-name-exist", args, 1));
                    return;
                }
            } else if (uiForm.getId().equalsIgnoreCase(UICBTemplateList.ST_CBTempForm) && uiForm.isAddNew_) {
                UICBTemplateList uiCBTempList = (UICBTemplateList)uiTempContainer.getChild(UICBTemplateList.class);
                List<Node> cbTemps = uiCBTempList.getAllTemplates();
                for (Node temp : cbTemps) {
                    if (!temp.getName().equals(templateName)) continue;
                    Object[] args = new Object[]{templateName};
                    uiApp.addMessage(new ApplicationMessage("UITemplateForm.msg.template-name-exist", args, 1));
                    return;
                }
            }
            if (uiForm.isAddNew_) {
                String oldHomeTemplate;
                if (uiForm.templatePath_ != null && !(oldHomeTemplate = uiForm.templatePath_.substring(0, uiForm.templatePath_.lastIndexOf("/"))).equals(homeTemplate)) {
                    Node oldNode = manageViewService.getTemplate(uiForm.templatePath_, WCMCoreUtils.getUserSessionProvider());
                    oldNode.remove();
                    manageViewService.getTemplate(oldHomeTemplate, WCMCoreUtils.getUserSessionProvider()).save();
                }
                path = manageViewService.addTemplate(templateName, content, homeTemplate);
                uiForm.template_ = NodeLocation.getNodeLocationByNode((Node)manageViewService.getTemplate(path, WCMCoreUtils.getUserSessionProvider()));
            } else {
                Node templateNode = NodeLocation.getNodeByLocation((NodeLocation)uiForm.template_);
                if (isEnableVersioning) {
                    if (!templateNode.isNodeType("mix:versionable")) {
                        templateNode.addMixin("mix:versionable");
                        templateNode.save();
                    } else {
                        templateNode.checkout();
                    }
                }
                path = manageViewService.updateTemplate(templateName, content, homeTemplate);
                templateNode.save();
                if (isEnableVersioning) {
                    templateNode.checkin();
                }
            }
            String workspaceName = NodeLocation.getNodeByLocation((NodeLocation)uiForm.template_).getSession().getWorkspace().getName();
            JCRResourceResolver resourceResolver = new JCRResourceResolver(workspaceName);
            TemplateService templateService = (TemplateService)uiForm.getApplicationComponent(TemplateService.class);
            if (path != null) {
                templateService.invalidateTemplate(path, (ResourceResolver)resourceResolver);
            }
            uiForm.refresh();
            if (uiForm.getId().equalsIgnoreCase(UIECMTemplateList.ST_ECMTempForm)) {
                UIECMTemplateList uiECMTempList = (UIECMTemplateList)uiTempContainer.getChild(UIECMTemplateList.class);
                uiECMTempList.refresh(uiECMTempList.getUIPageIterator().getCurrentPage());
                uiECMTempList.setRenderSibling(UIECMTemplateList.class);
            }
            if (uiForm.getId().equalsIgnoreCase(UICBTemplateList.ST_CBTempForm)) {
                UICBTemplateList uiCBTempList = (UICBTemplateList)uiTempContainer.getChild(UICBTemplateList.class);
                uiCBTempList.refresh(uiCBTempList.getUIPageIterator().getCurrentPage());
                uiCBTempList.setRenderSibling(UICBTemplateList.class);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTempContainer);
        }
    }
}

