/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.message;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.box.BoxMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageMacro
extends AbstractMacro<Object> {
    public static final String CONTENT_MISSING_ERROR = "The required content is missing.";
    @Requirement(value="box")
    private Macro<BoxMacroParameters> boxMacro;

    public AbstractMessageMacro(String macroName, String macroDescription) {
        super(macroName, macroDescription, (ContentDescriptor)new DefaultContentDescriptor(true));
    }

    public List<Block> execute(Object parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List result;
        if (StringUtils.isEmpty((String)content)) {
            throw new MacroExecutionException(CONTENT_MISSING_ERROR);
        }
        BoxMacroParameters boxParameters = new BoxMacroParameters();
        boxParameters.setCssClass(context.getCurrentMacroBlock().getId() + "message");
        if (!context.isInline()) {
            boxParameters.setTitle(content);
            result = this.boxMacro.execute((Object)boxParameters, "", context);
        } else {
            result = this.boxMacro.execute((Object)boxParameters, content, context);
        }
        return result;
    }

    public boolean supportsInlineMode() {
        return true;
    }
}

