/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.ecm.connector.fckeditor.FCKUtils;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.wcm.connector.BaseConnector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/contents/tag/")
public class TagConnector
extends BaseConnector
implements ResourceContainer {
    NewFolksonomyService tagService;

    public TagConnector(NewFolksonomyService tagService) {
        this.tagService = tagService;
    }

    @POST
    @Path(value="/add/{tag}")
    public Response addTag(@PathParam(value="tag") String tag, @QueryParam(value="jcrPath") String jcrPath) throws Exception {
        if (jcrPath.contains("%20")) {
            jcrPath = URLDecoder.decode(jcrPath, "UTF-8");
        }
        String[] path = jcrPath.split("/");
        String repositoryName = path[1];
        String workspaceName = path[2];
        if ((jcrPath = jcrPath.substring(repositoryName.length() + workspaceName.length() + 2)).charAt(1) == '/') {
            jcrPath.substring(1);
        }
        Node content = this.getContent(repositoryName, workspaceName, jcrPath, null, false);
        this.tagService.addPublicTag("/tags", new String[]{tag}, content, repositoryName, workspaceName);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        return Response.ok().header("Last-Modified", (Object)dateFormat.format(new Date())).build();
    }

    @GET
    @Path(value="/public")
    public Response getPublicTags(@QueryParam(value="jcrPath") String jcrPath) throws Exception {
        if (jcrPath.contains("%20")) {
            jcrPath = URLDecoder.decode(jcrPath, "UTF-8");
        }
        String[] path = jcrPath.split("/");
        String repositoryName = path[1];
        String workspaceName = path[2];
        if ((jcrPath = jcrPath.substring(repositoryName.length() + workspaceName.length() + 2)).charAt(1) == '/') {
            jcrPath.substring(1);
        }
        try {
            Node content = this.getContent(repositoryName, workspaceName, jcrPath, null, false);
            List tags = this.tagService.getLinkedTagsOfDocumentByScope(0, "", content, repositoryName, workspaceName);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element tagsElt = document.createElement("tags");
            for (Node tag : tags) {
                Element element = document.createElement("tag");
                element.setAttribute("name", tag.getName());
                tagsElt.appendChild(element);
            }
            document.appendChild(tagsElt);
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            return Response.ok((Object)new DOMSource(document), (String)"text/xml").header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        }
        catch (Exception e) {
            Response.serverError().build();
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            return Response.ok().header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        }
    }

    protected Node getRootContentStorage(Node parentNode) throws Exception {
        try {
            PortalFolderSchemaHandler folderSchemaHandler = (PortalFolderSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class);
            return folderSchemaHandler.getDocumentStorage(parentNode);
        }
        catch (Exception e) {
            WebContentSchemaHandler webContentSchemaHandler = (WebContentSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
            return webContentSchemaHandler.getDocumentFolder(parentNode);
        }
    }

    protected String getContentStorageType() throws Exception {
        return FCKUtils.DOCUMENT_TYPE;
    }
}

