/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.fckeditor;

import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.navigation.NavigationUtils;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/portalLinks/")
public class PortalLinkConnector
implements ResourceContainer {
    private final String PUBLIC_ACCESS = "public".intern();
    private final String PRIVATE_ACCESS = "private".intern();
    private final String EVERYONE_PERMISSION = "Everyone".intern();
    private final String RESOURCE_TYPE = "PortalPageURI".intern();
    private DataStorage portalDataStorage;
    private UserACL portalUserACL;
    private ServletContext servletContext;
    private static Log log = ExoLogger.getLogger(PortalLinkConnector.class);
    private static final String LAST_MODIFIED_PROPERTY = "Last-Modified";
    private static final String IF_MODIFIED_SINCE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss z";

    public PortalLinkConnector(InitParams params, DataStorage dataStorage, UserACL userACL, ServletContext servletContext) throws Exception {
        this.portalDataStorage = dataStorage;
        this.portalUserACL = userACL;
        this.servletContext = servletContext;
    }

    @GET
    @Path(value="/getFoldersAndFiles/")
    public Response getPageURI(@QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="command") String command, @QueryParam(value="type") String type) throws Exception {
        try {
            String userId = this.getCurrentUser();
            return this.buildReponse(currentFolder, command, userId);
        }
        catch (Exception e) {
            log.error((Object)"Error when perform getPageURI: ", (Throwable)e);
            SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
            return Response.ok().header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
        }
    }

    private String getCurrentUser() {
        try {
            ConversationState conversationState = ConversationState.getCurrent();
            return conversationState.getIdentity().getUserId();
        }
        catch (Exception e) {
            log.error((Object)"Error when perform getCurrentUser: ", (Throwable)e);
            return null;
        }
    }

    private Response buildReponse(String currentFolder, String command, String userId) throws Exception {
        Document document = null;
        document = currentFolder == null || "/".equals(currentFolder) ? this.buildPortalXMLResponse("/", command, userId) : this.buildNavigationXMLResponse(currentFolder, command, userId);
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat(IF_MODIFIED_SINCE_DATE_FORMAT);
        return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).header(LAST_MODIFIED_PROPERTY, (Object)dateFormat.format(new Date())).build();
    }

    private Document buildPortalXMLResponse(String currentFolder, String command, String userId) throws Exception {
        Element rootElement = this.initRootElement(command, currentFolder);
        Query query = new Query(null, null, null, null, PortalConfig.class);
        LazyPageList pageList = this.portalDataStorage.find(query, (Comparator)new Comparator<PortalConfig>(){

            @Override
            public int compare(PortalConfig pconfig1, PortalConfig pconfig2) {
                return pconfig1.getName().compareTo(pconfig2.getName());
            }
        });
        Element foldersElement = rootElement.getOwnerDocument().createElement("Folders");
        rootElement.appendChild(foldersElement);
        for (Object object : pageList.getAll()) {
            PortalConfig config = (PortalConfig)object;
            if (!this.portalUserACL.hasPermission(config)) continue;
            Element folderElement = rootElement.getOwnerDocument().createElement("Folder");
            folderElement.setAttribute("name", config.getName());
            folderElement.setAttribute("url", "");
            folderElement.setAttribute("folderType", "");
            foldersElement.appendChild(folderElement);
        }
        return rootElement.getOwnerDocument();
    }

    private Document buildNavigationXMLResponse(String currentFolder, String command, String userId) throws Exception {
        PortalContainer container = PortalContainer.getInstance();
        RequestLifeCycle.begin((ExoContainer)container);
        String portalName = currentFolder.substring(1, currentFolder.indexOf(47, 1));
        String pageNodeUri = currentFolder.substring(portalName.length() + 1);
        Element rootElement = this.initRootElement(command, currentFolder);
        Element foldersElement = rootElement.getOwnerDocument().createElement("Folders");
        Element filesElement = rootElement.getOwnerDocument().createElement("Files");
        rootElement.appendChild(foldersElement);
        rootElement.appendChild(filesElement);
        UserPortalConfigService pConfig = (UserPortalConfigService)WCMCoreUtils.getService(UserPortalConfigService.class);
        UserPortalContext NULL_CONTEXT = new UserPortalContext(){

            public ResourceBundle getBundle(UserNavigation navigation) {
                return null;
            }

            public Locale getUserLocale() {
                return Locale.ENGLISH;
            }
        };
        UserPortalConfig userPortalCfg = pConfig.getUserPortalConfig(portalName, userId, NULL_CONTEXT);
        UserPortal userPortal = userPortalCfg.getUserPortal();
        UserNavigation navigation = userPortal.getNavigation(SiteKey.portal((String)portalName));
        UserNode userNode = null;
        if (pageNodeUri == null) {
            RequestLifeCycle.end();
            return rootElement.getOwnerDocument();
        }
        if ("/".equals(pageNodeUri)) {
            userNode = userPortal.getNode(navigation, NavigationUtils.ECMS_NAVIGATION_SCOPE, null, null);
        } else {
            userNode = userPortal.resolvePath(navigation, null, pageNodeUri = pageNodeUri.substring(1, pageNodeUri.length() - 1));
            if (userNode != null) {
                userPortal.updateNode(userNode, NavigationUtils.ECMS_NAVIGATION_SCOPE, null);
            }
        }
        if (userNode != null) {
            for (UserNode child : userNode.getChildren()) {
                this.processPageNode(portalName, child, foldersElement, filesElement, userId, pConfig);
            }
        }
        RequestLifeCycle.end();
        return rootElement.getOwnerDocument();
    }

    private Element initRootElement(String commandStr, String currentPath) throws ParserConfigurationException {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        doc = builder.newDocument();
        Element rootElement = doc.createElement("Connector");
        doc.appendChild(rootElement);
        rootElement.setAttribute("command", commandStr);
        rootElement.setAttribute("resourceType", this.RESOURCE_TYPE);
        Element myEl = doc.createElement("CurrentFolder");
        myEl.setAttribute("path", currentPath);
        myEl.setAttribute("url", "");
        rootElement.appendChild(myEl);
        return rootElement;
    }

    private void processPageNode(String portalName, UserNode userNode, Element foldersElement, Element filesElement, String userId, UserPortalConfigService portalConfigService) throws Exception {
        String pageId = userNode.getPageRef();
        Page page = portalConfigService.getPage(pageId, userId);
        String pageUri = "";
        if (page == null) {
            pageUri = "/";
            Element folderElement = foldersElement.getOwnerDocument().createElement("Folder");
            folderElement.setAttribute("name", userNode.getName());
            folderElement.setAttribute("folderType", "");
            folderElement.setAttribute("url", pageUri);
            foldersElement.appendChild(folderElement);
        } else {
            pageUri = "/" + this.servletContext.getServletContextName() + "/" + portalName + "/" + userNode.getURI();
            Element folderElement = foldersElement.getOwnerDocument().createElement("Folder");
            folderElement.setAttribute("name", userNode.getName());
            folderElement.setAttribute("folderType", "");
            folderElement.setAttribute("url", pageUri);
            foldersElement.appendChild(folderElement);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            String datetime = formatter.format(new Date());
            Element fileElement = filesElement.getOwnerDocument().createElement("File");
            fileElement.setAttribute("name", userNode.getName());
            fileElement.setAttribute("dateCreated", datetime);
            fileElement.setAttribute("fileType", "page node");
            fileElement.setAttribute("url", pageUri);
            fileElement.setAttribute("size", "");
            filesElement.appendChild(fileElement);
        }
    }

    private UserNode getUserNode(UserNode root, String uri) {
        if (uri.equals("/" + root.getURI() + "/")) {
            return root;
        }
        Iterator childrenIter = root.getChildren().iterator();
        if (childrenIter == null) {
            return null;
        }
        while (childrenIter.hasNext()) {
            UserNode child = (UserNode)childrenIter.next();
            if (uri.equals("/" + child.getURI() + "/")) {
                return child;
            }
            UserNode deepChild = this.getUserNode(child, uri);
            if (deepChild == null) continue;
            return deepChild;
        }
        return null;
    }
}

