/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.mc.metadata.factory;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.portlet.impl.metadata.adapter.LocalizedStringAdapter;
import org.gatein.pc.portlet.impl.metadata.common.LocalizedDescriptionMetaData;

public class LocalizedStringBuilder {
    private Map<Object, LocalizedMetaDataContainer> map = new LinkedHashMap<Object, LocalizedMetaDataContainer>();
    private static final Logger log = LoggerFactory.getLogger(LocalizedStringBuilder.class);

    public void put(Object object, LocalizedDescriptionMetaData description) {
        LocalizedMetaDataContainer container = this.map.get(object);
        if (container == null) {
            container = new LocalizedMetaDataContainer();
            this.map.put(object, container);
        }
        container.addLocalizedDescription(description);
    }

    public LocalizedString getLocalizedString(Object key) {
        try {
            return this.map.get(key) != null ? this.map.get(key).getLocalizedString() : null;
        }
        catch (Exception e) {
            log.error((Object)"could not generate localized string.", (Throwable)e);
            return null;
        }
    }

    private static class LocalizedMetaDataContainer {
        private List<LocalizedDescriptionMetaData> list = new ArrayList<LocalizedDescriptionMetaData>();

        private LocalizedMetaDataContainer() {
        }

        public void addLocalizedDescription(LocalizedDescriptionMetaData description) {
            this.list.add(description);
        }

        public LocalizedString getLocalizedString() throws Exception {
            LocalizedStringAdapter adapter = new LocalizedStringAdapter();
            return adapter.unmarshal(this.list);
        }
    }
}

